#!/bin/awk -f 

#
#    REFERENCES -- bibliographic software
#    Copyright (C) 1995-2006  Volker Kiefel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#    USA
#

#
#    txt2html.awk -- convert a list of references into a formatted html-file
#
#    Usage:
#
#       awk [-v output_file=NameOfOutputFile.txt] -f txt2html.awk textfile
#
#
#    Versions:
#    30.7.2005: name of `outfile' may be changed (for References v4.2)
#
#


BEGIN {

   if (!output_file)
   {
     outfile = "reflist.html"
   } else
   {
     outfile=output_file
   }

   print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n\n" > outfile
   print "<HTML>" > outfile
   print "<HEAD>" > outfile
   print "<TITLE>File generated by References v4.2</TITLE>" > outfile
   print "</HEAD>\n" > outfile
   print "<BODY>" > outfile
}

{
   
   a = $0
   
   gsub(/&/,"\\&amp;",a) 

   gsub(/</,"\\&lt;",a)
   gsub(/>/,"\\&gt;",a)
   
   gsub(/___open-it\(/,"<I>",a) 
   gsub(/\)close-it___/,"</I>",a) 
   gsub(/___open-ul\(/,"<U>",a) 
   gsub(/\)close-ul___/,"</U>",a) 
   gsub(/___open-bf\(/,"<B>",a) 
   gsub(/\)close-bf___/,"</B>",a) 
   gsub(/___open-tt\(/,"<TT>",a) 
   gsub(/\)close-tt___/,"</TT>",a) 
   gsub(/___open-sc\(/,"",a) 
   gsub(/\)close-sc___/,"",a) 
   gsub(//,"\\&auml;",a)
   gsub(//,"\\&ouml;",a)
   gsub(//,"\\&uuml;",a)
   gsub(//,"\\&Auml;",a)
   gsub(//,"\\&Ouml;",a)
   gsub(//,"\\&Uuml;",a)
   gsub(//,"\\&szlig;",a)
   gsub(/"/,"\\&quot;",a)
   
   if (length(a) > 0)
   {
    print "<P>" > outfile 
   }
   print a  > outfile
   if (length(a) > 0)
   {
    print "</P>" > outfile 
   }
}

END {
   print "</BODY>" > outfile
   print "</HTML>" > outfile
   close(outfile)
   print "\nFile " outfile " created\n"
}

# vim:tw=2048

