/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   refs2tex.c: Conversion of references output files into TEX-files
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "refs.h"
#include "str_fun.h"
#include "interf.h"
#include "fl_ut.h"
#include "refs2tex.h"

#define MAXARR          32000
#define DOSN_LEN        150
#define Z_LEN           1000
#define WW_LEN          75



 extern char textpfad[PFAD_LEN+1];
 extern char wrtxtbu[WRTXTBU_LEN+1];

 extern config_set one_config_set;
 
 static char tex_name[PFAD_LEN +1];
 static char asc_name[PFAD_LEN +1];


 static char * eingabe;
 static char * ausgabe;

 static FILE * fptex;
 static FILE * fpasc;

 static int dateien_initialisieren(void);
 static void bearbeiten(void);



int refs2tex_main(void)
{

   if ((eingabe=(char*) malloc((MAXARR+1)*sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR: memory allocation 1 in "
        "'refs2tex_main()' failed\n");
      exit(1);
   }
   if ((ausgabe=(char*) malloc((MAXARR+1)*sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nERROR: memory allocation 1 in "
        "'refs2tex_main()' failed\n");
      exit(1);
   }

   strcpy(eingabe,"");
   strcpy(ausgabe,"");
   strcpy(asc_name,"");
   strcpy(tex_name,"");

   if (dateien_initialisieren())
   {
      bearbeiten();
      fclose(fpasc);
      fclose(fptex);
   }
   free(ausgabe);
   free(eingabe);
   return 0;
}

static int dateien_initialisieren(void)
{
   static char name_ohne_pfad[PFAD_LEN + 1];
   static char name_ohne_pfad_ohne_erweiterung[PFAD_LEN + 1];
   static char suchmuster[PFAD_LEN +1];

   strlimcpy(suchmuster,textpfad,PFAD_LEN);
   strlimcat(suchmuster,"*.txt",PFAD_LEN);
   // if (!datei_suchen("*.txt",name_ohne_pfad))
   // if (!datei_suchen(suchmuster,name_ohne_pfad))
   if (!datei_suchen(textpfad,"*.txt",name_ohne_pfad))
   {
      wrtxt("\n(No file selected, aborted)\n");
      return 0;
   }
   extractitem(1,name_ohne_pfad,".",name_ohne_pfad_ohne_erweiterung);
   strlimcpy(tex_name,textpfad,PFAD_LEN);
   strlimcat(tex_name,name_ohne_pfad_ohne_erweiterung,PFAD_LEN);
   strlimcat(tex_name,".tex",PFAD_LEN);
   
   strlimcpy(asc_name,textpfad,PFAD_LEN);
   strlimcat(asc_name,name_ohne_pfad,PFAD_LEN);

   if ((fpasc=fopen(asc_name,"r"))==NULL)
   {
      fprintf(stderr,"\nERROR: cannot read `%s'\n",asc_name);
      exit(1);
   }
   if ((fptex=fopen(tex_name,"w"))==NULL)
   {
      fprintf(stderr,"\nERROR: cannot write `%s'\n",tex_name);
      exit(1);
   }
   return 1;
}

static void bearbeiten(void)
{
   unsigned int i, n;
   long j;

   char zeile[Z_LEN + 1];
   strcpy(zeile,"");

   j=0;
   wrtxt("\n(Analyzing input TXT file)\n");
   while(fgets(eingabe,MAXARR,fpasc)!=NULL)
   {
      j++;
      /* if (strlen(eingabe)>=20-1) */
      if (strlen(eingabe)>=MAXARR-1)
      {
         sprintf(wrtxtbu,"\n>%s",eingabe);
         wrtxt(wrtxtbu);
         sprintf(wrtxtbu,"\nProblem in line %li: "
           "Line too long, file cannot be processed",j);
         wrtxt(wrtxtbu);
         wrtxt("\n(aborted)\n");
         return;
      }

      if (strcmp(eingabe,"\n") != 0)
      {
        if (is_substring("<",eingabe)!=1
           || is_substring(">",eingabe) >= 15 || is_substring(">",eingabe) == 0)
        {
           sprintf(wrtxtbu,"\n-> %s\n",eingabe);
           wrtxt(wrtxtbu);
           sprintf(wrtxtbu,"Problem in line %li:\nIncorrect format for refs2tex, must be <REFNO> ...\n",j);
           wrtxt(wrtxtbu);
           wrtxt("\n(aborted)\n");
           return;
        }
      }
   }
   fclose(fpasc);
   if ((fpasc=fopen(asc_name,"r"))==NULL)
   {
      fprintf(stderr,"\nERROR: cannot read `%s'\n",asc_name);
      exit(1);
   }
   wrtxt("\n(Writing .tex file)\n");

   fprintf(fptex,"%%\n%% File generated by REFERENCES v%s, "
                 "%s\n%%\n\n",REFS_VERSION,COPYRIGHT_STRING);
   fprintf(fptex,"\\begin{thebibliography}{99}\n\n");
   while(fgets(eingabe,MAXARR,fpasc)!=NULL)
   {
      n = strlen(eingabe) -1;
      if (strcmp(eingabe,"\n") != 0)
      {
         strcpy(ausgabe,"");
         for (i=0;i<=n;i++)
         {
           if (i==0)
           {
              strlimcat(ausgabe,"\\bibitem{",MAXARR);
           }
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"a",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"A",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"o",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"O",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"u",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\\"U",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"{\\ss}",MAXARR);
           else if (eingabe[i]=='[')
              strlimcat(ausgabe,"$[$",MAXARR);
           else if (eingabe[i]==']')
              strlimcat(ausgabe,"$]$",MAXARR);
           else if (eingabe[i]=='<')
              strlimcat(ausgabe,"$<$",MAXARR);
           else if (eingabe[i]=='#')
              strlimcat(ausgabe,"\\#",MAXARR);
           else if (eingabe[i]=='$')
              strlimcat(ausgabe,"\\$",MAXARR);
           else if (eingabe[i]=='&')
              strlimcat(ausgabe,"\\&",MAXARR);
           else if (eingabe[i]=='%')
              strlimcat(ausgabe,"\\%",MAXARR);
           else if (eingabe[i]=='_')
              strlimcat(ausgabe,"\\_",MAXARR);
           else if (eingabe[i]=='\"')
              strlimcat(ausgabe,"'",MAXARR);
           else if (eingabe[i]=='^' || eingabe[i]=='~')
              strlimcat(ausgabe,"",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\c{c}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\c{C}",MAXARR);

           else if (eingabe[i]=='^' || eingabe[i]=='~')
              strlimcat(ausgabe,"",MAXARR);

           /*franzoesiche Akzente*/

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{e}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{e}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{e}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\\"{e}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{E}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{a}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{a}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{a}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{o}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{o}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{o}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{u}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{u}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{u}",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\'{i}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"\\`{i}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\^{i}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\\"{i}",MAXARR);

           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\{AE}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\{ae}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\{AA}",MAXARR);
           else if (eingabe[i]=='')
             strlimcat(ausgabe,"\\{aa}",MAXARR);


           else if (eingabe[i]=='\"')
              strlimcat(ausgabe,"'",MAXARR);

           else if (eingabe[i]=='')
              strlimcat(ausgabe,"{\\ensuremath{^\\circ}}",MAXARR);
           else if (eingabe[i]=='')
              strlimcat(ausgabe,"{\\ensuremath{\\mu}}",MAXARR);

           else if (eingabe[i]=='>')
           {
               if (i < 15)
               {
                  strlimcat(ausgabe,"}",MAXARR);
               }
               else strlimcat(ausgabe,"$>$",MAXARR);
           }
           else
           {
              zeile[0]=eingabe[i];
              zeile[1]='\0';
              strlimcat(ausgabe,zeile,MAXARR);
           }
         }
         wwrap(ausgabe,WW_LEN);
         fprintf(fptex,"%s\n",ausgabe);
      }
   }
   fprintf(fptex,"\\end{thebibliography}\n\n");
   sprintf(wrtxtbu,"\n(List of REFERENCES for LaTeX converted into %s)\n",tex_name);
   wrtxt(wrtxtbu);
}

