\documentstyle[astyped]{article}
% @(#)reader.st	1.3 88/06/30
\title{{\tt read-st}}
\author{John D. Ramsdell}
\date{
88/06/30
}

\begin{document}

\maketitle

\verb;read-st; converts Scheme\TeX{} representations of Scheme objects
into the objects themselves much as \verb;read; does.  It uses the
non-standard, but generally available routine \verb;peek-char;.
(define (read-st . rest)		; Returns what \verb;read; returns.
  (let ((port (if (pair? rest)		; \verb;read-st; arguments are
		  (car rest)		; the same as \verb;read;'s.
		  (current-input-port))))
    (letrec				; Lines of a Scheme\TeX{} file
	(((text-mode-and-saw-newline)	; beginning with ``{\tt(}'', 
	  (let ((ch (peek-char port)))	; start a code section.
	    (cond ((eof-object? ch) ch)
		  ((char=? ch #\()	; If code section, then use
		   (got-code (read port))) ; \verb;read; to get code,
		  (else			; else skip this line as
		   (text-mode-within-a-line))))) ; it is a comment.
	 ((text-mode-within-a-line)	
	  (let ((ch (read-char port)))
	    (cond ((eof-object? ch) ch)
		  ((char=? ch #\newline)
		   (text-mode-and-saw-newline))
		  (else (text-mode-within-a-line)))))
	 ((got-code code)		; Ignore the remainder of the 
	  (let ((ch (read-char port)))	; last code line and return
	    (cond ((eof-object? ch) code) ;  the results of \verb;read;.
		  ((char=? ch #\newline)
		   code)
		  (else (got-code code))))))
      (text-mode-and-saw-newline)	; Start by looking 
      )))				; for a code line.
\end{document}

