/*
 * This ARexx script creates all binaries of the complete AmiWeb2c
 * distribution.  Before running `rx install' you should first
 * start `rx configure' to set up the necessary `SMakefile's.
 * Other files required for the installation will be created
 * automatically when this script is run.
 *
 * Copyright (C) 1995, 1997 by Andreas Scherer.
 * This configuration script is free software; the author gives
 * unlimited permission to copy, distribute, and modify it.
 *
 * Although called "install.rexx" itself, this script does not
 * by default install the binaries it creates.  However, you can
 * (try to) apply certain options (labels) for all SMakefiles
 * simultaneously.  (I only use "distclean" myself.)
 */

Address COMMAND /* We will run external programs. */

Parse Arg LABELS

NL = '0a'x /* `new line' character. */

/*
 * Save the name of the root directory, i.e., `<something>/web2c-7.2'.
 */
HOMEDIR = Pragma('Directory')

/*
 * We want to install the following subdirectories.  Do NOT change
 * the order given here; the individual parts are somewhat depending
 * on previous results.  At least the first two entries are mandatory.
 */
INSTALL_DIRS = "kpathsea web2c/lib web2c/web2c"
/*
 * The "web2c/pdftexdir/" stuff is only necessary when you create PDFTeX.
 * This has to be present prior to the compilation of "web2c/".
 */
INSTALL_DIRS = INSTALL_DIRS "web2c/pdftexdir"
INSTALL_DIRS = INSTALL_DIRS "web2c/pdftexdir/zlib web2c/pdftexdir/libpng"
INSTALL_DIRS = INSTALL_DIRS "web2c web2c/doc web2c/mpware web2c/otps"
/*
 * You may of course skip the following entries.  However, some if
 * not all of these tools are quite useful in connection with "TeX
 * and friends".
 */
INSTALL_DIRS = INSTALL_DIRS "dtl dvidvi dviljk dvipsk gsftopk lacheck"
INSTALL_DIRS = INSTALL_DIRS "makeindexk musixflx ps2pkm seetexk tex4htk"

/*
 * Try a simple check whether `rx configure' has been run before.
 */
DUMMY = INSTALL_DIRS
Parse Value DUMMY With CHECK_CONFIG DUMMY

Do While "" ~= CHECK_CONFIG
  If ~Exists(HOMEDIR"/"CHECK_CONFIG"/SMakefile") Then Do
    Say "Please run `rx configure' before compilation."
    Exit 1
  End
  Parse Value DUMMY With CHECK_CONFIG DUMMY
End

/*
 * Call "SMake" in the main directories.
 */
Parse Value INSTALL_DIRS With INSTALL_DIR INSTALL_DIRS

Do While "" ~= INSTALL_DIR
  Pragma('Directory', HOMEDIR"/"INSTALL_DIR)

  Say "Compiling `"Pragma('Directory')".'"

  SMake LABELS

  Parse Value INSTALL_DIRS With INSTALL_DIR INSTALL_DIRS
End

/*
 * Come home again.
 */
Pragma('Directory',HOMEDIR)

Say "Congratulations!"

Exit 0

/*
 * And now comes the really hard part.  It's up to you to collect all
 * the binaries created above and put them into the directory where
 * the OS can find them.  Depending on the settings you chose in
 * "make/common.smake" and "make/paths.smake" you should use something
 * like "<Device>:AmiWeb2c-2.1/bin/m68000-amigaos2.1".
 *
 * Additional files to install:
 *
 *    kpathsea/texmf.cnf: The general configuration for all programs
 *       using the Kpathsea library.  Put this somewhere in the path
 *       defined by TEXMFCNF.
 *
 *    web2c/mpware/makempx.rexx: Used by METAPOST for typesetting
 *       TeX labels.  Put this in your REXX: directory.
 */

/*
 * EOF install.rexx
 */
