/* mftalk.c -- generic METAFONT window server.

   Copyright (C) 1994, 1995 Ralph Schleicher	*/

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Please remember the following if porting to UNIX:

	pid = fork ();
	if (pid == 0)
	  execve (...);		pid = spawnve (mode, ...);
	else if (pid == -1)	if (pid == -1)
	  error ();		  error ();
	else			else
	  success ();		  success ();

   spawnve(2) has many different modes and a `session' is indicated by
   running on an extra terminal.  */


#define	EXTERN		extern
#include "../mfd.h"

#ifdef MFTALKWIN

#undef read
#undef write
#ifdef OS2
#include <sys/param.h>
#include <process.h>
extern int close (int);
extern int pipe (int *);
extern int read (int, void *, size_t);
extern int setmode (int, int);
extern int write (int, const void *, size_t);
#endif
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include "mftalk.h"

#define fatal(func, true)	\
	do { if (true) {	\
	  perror (#func);	\
	  abort ();		\
	} } while (0)

static RETSIGTYPE child_died (int sig);
static int app_type (char *prog, char *buf, int len);

static int pid = -1;			/* Process ID of our child. */
static int win = -1;			/* Write handle to the `window'. */
static int buf[8];			/* Temporary buffer. */
static void (*old) (int sig);		/* Old signal handler. */

#if defined (OS2)
#define MFTALK "mftalk.exe"
#else /* not OS2 */
#define MFTALK "mftalk"
#endif /* not OS2 */


boolean
mf_mftalk_initscreen (void)
{
  int app;				/* Client application type. */
  char *prog, name[MAXPATHLEN];		/* Client program name. */
  char height[16], width[16];		/* Size of METAFONT window. */
  char input[16], output[16];		/* Inherited pipe handles. */
  char parent[16];			/* My own process ID. */
  int pio[2];				/* Pipe I/O handles. */
  int res, ack;				/* Wait until child is ready. */

  prog = getenv ("MFTALK");
  if (prog == NULL)
    prog = MFTALK;

  app = app_type (prog, name, MAXPATHLEN);
  if (app == -1)
    return 0;

  if (pipe (pio) == -1)
    return 0;
#ifdef OS2
  fatal (setmode, setmode (pio[0], O_BINARY) == -1);
  fatal (setmode, setmode (pio[1], O_BINARY) == -1);
#endif

  old = signal (SIGCLD, child_died);
  fatal (old, old == SIG_ERR);

  sprintf (height, "-h%d", screendepth);
  sprintf (width, "-w%d", screenwidth);
  sprintf (input, "-i%d", pio[0]);
  sprintf (output, "-o%d", pio[1]);
  sprintf (parent, "-p%d", getpid ());

#ifdef OS2
  pid = spawnl (app, name, prog, height, width, input, output, parent, NULL);
#else /* not OS2 */
  pid = fork ();
#endif /* not OS2 */
  switch (pid)
    {
#ifndef OS2
    case 0:
      execlp (prog, prog, height, width, input, output, parent, NULL);
#endif
    case -1:
    failure:
      fatal (close, close (pio[0]) == -1);
      fatal (close, close (pio[1]) == -1);
      fatal (signal, signal (SIGCLD, old) == SIG_ERR);
      break;
    default:
      res = read (pio[0], &ack, sizeof (int));
      if (res != sizeof (int) || ack != MF_ACK)
	goto failure;
      fatal (close, close (pio[0]) == -1);
      win = pio[1];
      break;
    }

  return (win == -1) ? 0 : 1;
}


void
mf_mftalk_updatescreen (void)
{
  buf[0] = MF_FLUSH;

  write (win, buf, sizeof (int));
}


void
mf_mftalk_blankrectangle (left, right, top, bottom)
screencol left;
screencol right;
screenrow top;
screenrow bottom;
{
  buf[0] = MF_RECT;
  buf[1] = MF_WHITE;
  buf[2] = left;
  buf[3] = bottom;
  buf[4] = right;
  buf[5] = top;

  write (win, buf, 6 * sizeof (int));
}


void
mf_mftalk_paintrow (row, init_color, transition_vector, vector_size)
screenrow row;
pixelcolor init_color;
transspec transition_vector;
screencol vector_size;
{
  buf[0] = MF_LINE;
  buf[1] = init_color == 0 ? MF_WHITE : MF_BLACK;
  buf[2] = *transition_vector++;
  buf[3] = row;
  buf[4] = --vector_size;

  write (win, buf, 5 * sizeof (int));
  write (win, transition_vector, vector_size * sizeof (int));
}


static int
app_type (char *prog, char *buf, int len)
{
#ifdef OS2

  int res, app;

  res = DosSearchPath (0x02 | 0x01, "PATH", prog, buf, len);
  if (res != 0)
    return -1;

  res = DosQueryAppType (buf, &app);
  if (res != 0)
    return -1;

  switch (app & 0x07)			/* Quick guess. */
    {
    case 0x00: return (P_SESSION | P_DEFAULT);
    case 0x01: return (P_SESSION | P_FULLSCREEN);
    case 0x02: return (P_SESSION | P_WINDOWED);
    case 0x03: return (P_PM);
    }

  return -1;

#else /* not OS2 */

  return 0;

#endif /* not OS2 */
}


static RETSIGTYPE
child_died (int sig)
{
#ifdef OS2
  fatal (signal, signal (sig, SIG_ACK) == SIG_ERR);
#endif
  fatal (signal, signal (sig, SIG_IGN) == SIG_ERR);

  if (pid == -1 || kill (-pid, 0) == 0)	/* This was not our child. */
    {
      if (old != SIG_IGN)
	{
	  fatal (signal, signal (sig, old) == SIG_ERR);
	  fatal (raise, raise (sig) == -1);
	}
      fatal (signal, signal (sig, child_died) == SIG_ERR);
    }
  else
    {
      close (win);			/* This may fail. */
      win = -1;

      pid = -1;

      screenstarted = false;		/* METAFONT variables. */
      screenOK = false;

      fatal (signal, signal (sig, old) == SIG_ERR);
    }
}

#else /* not MFTALKWIN */

int mftalk_dummy;

#endif /* not MFTALKWIN */
