The eqexam Package 
Dated: 2021-01-20
Author: D. P. Story

eqExam is a LaTeX package for writing exams, tests, quizzes,
homework assignments, etc. It is a stand alone package, yet is
tightly integrated with the AcroTeX eDucation Bundle (AeB). Highlights of
this package are as follows:

    1.  Can create exams (tests, quizzes, homework assignments) for
        paper, with points in the left or right margins (or both), totals
        for each page optionally shown at the bottom corner of each page.
        Questions can be objective, fill-in, true false, or multiple
        choice.
    2.  Solutions can optionally be included in the source file, and
        by changing options, can be displayed (for an answer key), in a
        couple of different ways. A solutions only document can also be
        generated.
    3.  Can create multi-part exams, as I often do for final exams, these
        multiple exams are meant to be graded individually.
    4.  The one thing that distinguishes this package from the other
        exam package is its support for PDF, and this is where AeB comes
        in. When you have AeB installed, and you select any of
        several options (pdf, links, online or email), a variety of
        things can happen. For example, in the case of the online or
        email options, white space for solutions is converted into
        multi-line text field, spaces to fill in answers are converted to
        text fields,multiple choice questions are converted into radio
        button fields, etc. When the email option is used, a "Submit"
        button is automatically created at the top of the first page of
        the test. The student can take the test online (perhaps in a
        testing lab) then submit responses to the instructor. The email
        that is generated to the instructor attaches the FDF file of
        form data, so the instructor gets a copy of all responses.
        She/He can then open the file and view the responses of the
        student. Get the latest AeB (AcroTeX eDucation Bundle,
        web,exerquiz,etc)
    5.  A major option, fortextbook, is designed to support (U.S.) textbook
        authors. Documentation for this option is found in the doc/fortextbook
        folder. See also the series of blogs at
        http://www.acrotex.net/blog/?tag=fortextbook

What's New (2021-01-20) Defined \trackProblemsOn and \numPtsOfProblem; 
added \doNoRandomizeChoices and \allowRandomizedChoices. See documentation.

What's New (2020-03-14) Defined several commands and one environment to 
support the insertion of a figure into a problem. Demo file that illustrates 
these new commands and environment is found at 
http://www.acrotex.net/blog/?p=1419 

What's New (2020-01-06) Fixed a bug in eqexam, so that now comment.sty is 
fully supported. For consistency, aeb-comment.sty is nothing more than 
version 3.8 dating to July 2016. 

What's New (2019-12-17) fortextbook: added \autoInsSolns, as explained in 
fortextbook.pdf; fixed a bug in the use of aeb-comment with the fortextbook 
option. Updated that custom package, now dated 2019/12/18. (aeb-comment is 
distributed with acrotex.) 

What's New (2019-10-29) Fixed a bug with the online option. The  \fillineol* 
command now allows verbatim text in the third argument (as well as the 
first). 

What's New (2019-01-31) Package uses aeb-comment, an older version of the 
comment package. The newer version has some incompatibilities with eqexam. 

What's New (2018-12-13) Changes to support the mi-solns package

What's New (2018-04-15) Minor bug fixes

What's New (2018-02-19): Extended the vertical space fill types 
and added \fillineol. Refer to the table of contents under Sections 10.11
and 10.12.

Sample files, previous distributed with eqexam are now available from

    http://www.acrotex.net/blog/?cat=107
and
    http://www.acrotex.net/blog/?tag=eqexam-package

The home page for eqexam is

    http://www.math.uakron.edu/~dpstory/eqexam.html

The home page for AeB is

    http://www.math.uakron.edu/~dpstory/webeq.html

Comments and suggestions are always gratefully accepted and seriously
considered.

D. P. Story

