/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.localization;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.arara.api.localization.MPPLocale;
import org.islandoftex.arara.api.localization.Messages;
import org.islandoftex.arara.core.localization.BrazilianLanguage;
import org.islandoftex.arara.core.localization.DutchLanguage;
import org.islandoftex.arara.core.localization.GermanLanguage;
import org.islandoftex.arara.core.localization.ItalianLanguage;
import org.islandoftex.arara.core.localization.NorfolkLanguage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/islandoftex/arara/core/localization/LanguageController;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "messages", "Lorg/islandoftex/arara/api/localization/Messages;", "getMessages$annotations", "getMessages", "()Lorg/islandoftex/arara/api/localization/Messages;", "setMessages", "(Lorg/islandoftex/arara/api/localization/Messages;)V", "loadMessagesFor", "", "locale", "Lorg/islandoftex/arara/api/localization/MPPLocale;", "core"})
public final class LanguageController {
    @NotNull
    public static final LanguageController INSTANCE = new LanguageController();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(LanguageController::logger$lambda$0);
    @NotNull
    private static Messages messages = new Messages(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, -1, 131071, null);

    private LanguageController() {
    }

    @NotNull
    public static final Messages getMessages() {
        return messages;
    }

    public static final void setMessages(@NotNull Messages messages) {
        Intrinsics.checkNotNullParameter(messages, "<set-?>");
        LanguageController.messages = messages;
    }

    @JvmStatic
    public static /* synthetic */ void getMessages$annotations() {
    }

    @JvmStatic
    public static final void loadMessagesFor(@NotNull MPPLocale locale) {
        Messages messages;
        Intrinsics.checkNotNullParameter(locale, "locale");
        MPPLocale mPPLocale = locale;
        if (Intrinsics.areEqual(mPPLocale, new MPPLocale("de"))) {
            messages = new GermanLanguage();
        } else if (Intrinsics.areEqual(mPPLocale, new MPPLocale("it"))) {
            messages = new ItalianLanguage();
        } else if (Intrinsics.areEqual(mPPLocale, new MPPLocale("nl"))) {
            messages = new DutchLanguage();
        } else if (Intrinsics.areEqual(mPPLocale, new MPPLocale("pt-BR"))) {
            messages = new BrazilianLanguage();
        } else if (Intrinsics.areEqual(mPPLocale, new MPPLocale("en-QN"))) {
            messages = new NorfolkLanguage();
        } else if (Intrinsics.areEqual(mPPLocale, new MPPLocale("en"))) {
            messages = new Messages(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, -1, 131071, null);
        } else {
            logger.warn(() -> LanguageController.loadMessagesFor$lambda$1(locale));
            messages = new Messages(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -1, -1, 131071, null);
        }
        LanguageController.messages = messages;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object loadMessagesFor$lambda$1(MPPLocale $locale) {
        return "Language " + $locale.getDisplayLanguage() + " not available; defaulting to English.";
    }
}

