---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, colonnes
---

# Comment fixer la largeur d'une colonne ?

Il suffit d'utiliser le "descripteur de colonne" `p{largeur}`. Dans ce cas,
si le texte doit s'étaler sur plusieurs lignes, l'alignement vertical 
se fait sur la première ligne. L'extension <ctanpkg:array> définit 
les descripteurs `m{largeur}`, pour que le texte soit centré verticalement, 
et `b{largeur}` pour que le texte soit aligné en bas.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{tabular}{|p{2cm}|p{2cm}|p{2cm}|}
  \hline 
  un & deux       & trois \\ \hline
  un & deux virgule zéro & trois et des brouettes \\ \hline
\end{tabular}
\end{document}
```