---
myst:
  html_meta:
    keywords: LaTeX,titres,sectionnement,sections,numéroter
---
# Comment modifier la numérotation des sections ?

## Contrôler la réinitialisation des numéros de sections

Par défaut, les niveaux de sectionnement inférieurs sont remis à zéro
quand on avance dans un niveau de sectionnement supérieur :
par exemple, si on passe au chapitre 3 après la section 2.8,
la prochaine section que l'on créera sera numérotée 3.1, et non 3.9.
Pour numéroter de manière continue un niveau de sectionnement
même quand on avance dans le niveau de sectionnement supérieur,
on peut utiliser la commande `\@removefromreset`
en spécifiant comme arguments
d'abord le niveau qui doit garder la numérotation continue,
puis le niveau qui ne doit pas susciter de réinitialisation[^1].
Par exemple :

```{noedit}
\@removefromreset{section}{chapter}
```
signifie « le compteur `section` ne doit pas être réinitialisé
quand le compteur `chapter` augmente ».

[^1]: `\@removefromreset` ne se limite pas aux niveaux de sectionnement :
    on peut aussi l'utiliser par exemple
    [avec les numérotations de figures et d'équations](/3_composition/texte/renvois/numeroter_les_equations_et_figures_en_continu).

L'opération inverse, avec la même syntaxe, est permise par `\@addtoreset`.

En utilisant <ctanpkg:chngcntr>, vous pouvez utiliser `\counterwithout`
à la place de `\@removefromreset` et `\counterwithin`
à la place de `\@addtoreset`. La syntaxe est la même,
mais `\counterwithout` supprime en outre dans les références internes
la mention du niveau de sectionnement qui ne réinitialise plus
(en suivant l'exemple ci-dessus, on aura « voir section 9 » au lieu de « voir section 3.9 ») ;
cette fonctionnalité supplémentaire est inhibée dans la version étoilée de la commande.
