---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              structures, indices, exposants, taille des indices, 
              taille des exposants
---

# Comment modifier la taille des indices et exposants ?

Il peut arriver que vous souhaitiez modifier la taille des 
[indices et exposants](/4_domaines_specialises/mathematiques/structures/indices/start)
dans un document. Voici plusieurs méthodes pour y arriver, classée 
de la plus recommandée à la moins recommandée.


## Avec les commandes de style mathématiques

Les commandes de 
[style mathématique](/4_domaines_specialises/mathematiques/styles/les_huit_styles_mathematiques) 
`\scriptstyle` ou `\scriptscriptstyle` permettent de gérer ces tailles.
La première donne aux éléments mathématiques la taille d'un indice ou exposant
de premier ordre, la seconde la taille d'un indice ou exposant de second ordre
(autrement dit, par exemple, la taille de l'indice d'un indice).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Au premier ordre :
\[
  X_{AB} = X_{\scriptstyle AB} \neq X_{\scriptscriptstyle AB}.
\]

Au second ordre :
\[
  X_{AB_{CD}}
   = X_{AB_{\scriptscriptstyle CD}} \neq X_{AB_{\scriptstyle CD}}.
\]
\end{document}
```


## Avec des commandes de taille de texte classique

La question 
"[](/3_composition/texte/symboles/polices/changer_la_taille_d_une_fonte)". 
Cependant, il s'agit là d'une logique assez contradictoire avec celle 
d'utiliser un environnement mathématique et il peut devenir rapidement 
fastidieux de garder une uniformité sur un document assez long. 
Cette utilisation est donc déconseillée et devrait rester exceptionnelle.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Un exemple peu subtil et guère recommandé :
\[
  X_{AB_{CD}} \neq
    X_{\textit{\footnotesize AB}_{\textit{\normalsize CD}}}
\]
\end{document}
```


## Avec la commande `\DeclareMathSizes`

La commande `\DeclareMathSizes` permet d'effectuer des réglages généraux 
sur la taille des polices. Elle est présentée à la question 
"[](/4_domaines_specialises/mathematiques/symboles/polices/tailles_de_fonte_en_mode_mathematique)". 

Elle n'est cependant pas recommandée car LaTeX fournit normalement 
des dimensions bien adaptées. 
[David Carlisle](https://davidcarlisle.github.io/dcarlisle/david/) 
détaille d'ailleurs [ce cas](https://tex.stackexchange.com/q/99981) 
et précise que cette commande ne devrait servir que lors de la définition 
de [nouvelles classes](/2_programmation/extensions/creer_sa_propre_classe).

Il ne faut pas ici oublier que le premier paramètre de cette commande 
est la taille du texte environnant. Notre document ci-dessous ayant une fonte
de `10pt` par défaut, il faut bien entamer la commande `\DeclareMathSizes` 
avec un argument valant `10`. Les arguments suivants donnent la taille 
de `\textfont` (10pt), de `\scriptfont` (9pt) et de `\scriptscriptfont` (8pt).
Ces deux derniers réglages vont donner des indices assez grands 
et pas forcément très agréables visuellement.

```
\documentclass[10pt]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \DeclareMathSizes{10}{10}{9}{8}

\begin{document}
Voici un exemple de taille augmentée à comparer avec le résultat des
exemples précédents :
\[  X_{AB_{CD}}  \]
\end{document}
```


:::{sources}
- [When should we use \DeclareMathSizes, \xxxstyle and font size changing macros (\tiny, \small, etc)?](https://tex.stackexchange.com/q/99981/18401),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::