%%
%% This is file `leiletter.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% leiletter.dtx  (with options: `class')
%% ----------------------------------------------------------------
%% LEIletter --- letter class for Leiden University
%% E-mail: m.t.kreutzer@science.leidenuniv.nl
%% Released under the LaTeX Project Public License v1.3c or later
%% See http://www.latex-project.org/lppl.txt
%% ----------------------------------------------------------------
%% 
\def\fileversion{1.3}
\def\filedate{2020/02/9}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{LEIletter}[\filedate\space\fileversion\space  Michiel Kreutzer's letter class based on UL huisstijl in  https://huisstijl.leidenuniv.nl/nl/corporate/briefpapier-zetaanwijzingen/]
\RequirePackage{ifthen}
\RequirePackage{kvoptions}
\SetupKeyvalOptions{family=leil, prefix=leil@}
\DeclareBoolOption{dutch}
\DeclareBoolOption{english}
\DeclareBoolOption{briefdrager}
\DeclareStringOption[dutch]{lang}
\DeclareStringOption[fwn]{faculty}
\DeclareStringOption{author}
\setkeys{leil}{dutch}
\ProcessKeyvalOptions{leil}
\ifthenelse{\boolean{leil@english}}{\renewcommand*{\leil@lang}{english}}{}
\ifthenelse{\equal{\leil@lang}{dutch}\OR\equal{\leil@lang}{english}}{\relax}%
    {\PackageWarningNoLine{leiletter}{Only languages supported are Dutch and English.
     Defaulting to Dutch now, you specified \leil@lang}} 
\ifthenelse{\equal{\leil@faculty}{fwn}\OR\equal{\leil@faculty}{fgw}\OR
            \equal{\leil@faculty}{fsw}\OR\equal{\leil@faculty}{gga}\OR
            \equal{\leil@faculty}{med}\OR\equal{\leil@faculty}{law}\OR
            \equal{\leil@faculty}{arch}}{\relax}%
    {\PackageWarningNoLine{leiletter}{You specified illegal input for the faculty.
     Switching back to fwn, you specified \leil@faculty}
     \renewcommand*{\leil@faculty}{fwn}} 
\LoadClass{scrlttr2}
\KOMAoptions{
  fontsize=11pt,
  paper=a4,
  usegeometry=true,
  parskip=full,
  pagenumber=false,
  enlargefirstpage=on,    % More space on first page
  fromrule=off,           % No Rule after sender name in letter head
  addrfield=topaligned,   % Adress field for envelope with window
  backaddress=off,         % Sender address in this window (use plain to remove rule)
  refline=nodate,
  foldmarks=on,           % Print foldmarks
}
\RequirePackage{scrlayer-scrpage}
\pagestyle{scrheadings}
\RequirePackage{array}
\RequirePackage{etoolbox}
\RequirePackage[\leil@lang]{babel}
\RequirePackage{hyperref}
\hypersetup{colorlinks, breaklinks, urlcolor=black, linkcolor=black}
\RequirePackage{ragged2e}
\RaggedRight
\RequirePackage{textcase}
\RequirePackage{microtype}
\RequirePackage[fullfamily,opticals]{MinionPro}
\DeclareRobustCommand{\spacedallcaps}[1]{\textssc{\MakeTextUppercase{#1}}}
\DeclareRobustCommand{\spacedlowsmallcaps}[1]{\textssc{\MakeTextLowercase{#1}}}
\RequirePackage[left=4.8cm,right=2.2cm,top=142pt,bottom=44pt,foot=2em]{geometry}
\@setplength{toaddrhpos}{24mm}
\@setplength{toaddrvpos}{146pt}
\@setplength{toaddrwidth}{72mm}
\@setplength{toaddrheight}{77pt}
\@setplength{backaddrheight}{0pt}
\@setplength{subjectaftervskip}{0pt}
\@setplength{subjectbeforevskip}{0pt}
\@setplength{refaftervskip}{0pt}
\@setplength{sigbeforevskip}{3.0\baselineskip}
\@setplength{refvpos}{350pt}
\setlength\parindent{0pt}
\renewcommand*{\raggedsignature}{\raggedright}
\setkomavar{enclseparator}{: }
\def\leil@fontsize{11pt}
\def\leil@baseline{14pt}
\renewcommand\normalsize{%
   \baselineskip=\leil@baseline%
   \@setfontsize\normalsize{\leil@fontsize}{\leil@baseline}%
   \lineskip=0pt
   \lineskiplimit=-\leil@fontsize%
   \abovedisplayskip \baselineskip%
   \abovedisplayshortskip .5\baselineskip%
   \belowdisplayskip \abovedisplayskip
   \belowdisplayshortskip \abovedisplayshortskip
   \let\@listi\@listI}
\renewcommand\small{%
   \baselineskip=\leil@baseline%
   \@setfontsize\normalsize{10pt}{\leil@baseline}%
   \lineskip=0pt
   \lineskiplimit=-\leil@fontsize%
   \abovedisplayskip \baselineskip%
   \abovedisplayshortskip .5\baselineskip%
   \belowdisplayskip \abovedisplayskip
   \belowdisplayshortskip \abovedisplayshortskip
   \let\@listi\@listI}
\normalsize
\parskip \leil@baseline
\newdimen\floatunit
\newskip\allfloats
\setlength\floatunit{\the\baselineskip}
\begingroup
  \catcode`P=12
  \catcode`T=12
  \lowercase{
    \def\x{\def\rem@decimal##1.##2PT{##1}}}
  \expandafter\endgroup\x
\def\strip@decimal{\expandafter\rem@decimal\the}
\begingroup
  \catcode`P=12
  \catcode`T=12
  \lowercase{
    \def\y{\def\rem@dot##1.##2PT{##1##2}}}
  \expandafter\endgroup\y
\def\strip@dot{\expandafter\rem@dot\the}
\newdimen\halfbaselineskip
\halfbaselineskip=\floatunit
\divide\halfbaselineskip by 2
\newdimen\figboxht
\newdimen\figboxdp
\long\def\roundoff{\figboxht=\fight%
    \advance\figboxht by \baselineskip%
    \multiply\figboxht by 10%
    \xdef\xbaselineskip{\strip@dot\baselineskip}%
    \divide\figboxht by \xbaselineskip%
    \xdef\mylines{\strip@decimal\figboxht}%
    \figboxht=\baselineskip%
    \multiply\figboxht by\mylines%
    \advance\figboxht by -\fight%
    \ifdim\the\figboxht>\the\halfbaselineskip%
      \advance\figboxht by -\floatunit%
    \else\fi%
    }
\long\def\fltroundoff{\figboxht=\fight%
\figboxdp=\figdp%
\addtolength{\figboxht}{\figdp}%
\addtolength{\figboxdp}{\fight}%
\typeout{figboxht is now (dp added) \the\figboxht}%
    \advance\figboxht by \baselineskip%
    \multiply\figboxht by 10%
    \xdef\xbaselineskip{\strip@dot\baselineskip}%
    \divide\figboxht by \xbaselineskip%
    \xdef\mylines{\strip@decimal\figboxht}%
    \figboxht=\baselineskip%
    \multiply\figboxht by\mylines%
    \advance\figboxht by -\figboxdp%
    \ifdim\the\figboxht>\the\halfbaselineskip%
      \advance\figboxht by -\floatunit%
    \else\fi%
    }
\newenvironment{gridfltenv}
         {\global\setbox0=\vbox\bgroup}
         {\egroup%
          \xdef\fight{\the\ht0}%
  \xdef\figdp{\the\dp0}%
      \typeout{figboxht starts at \fight, \figdp  is depth}
          \fltroundoff%
          \leavevmode\vadjust{\box0\vskip\figboxht}\hfil\break%
         }
\newenvironment{gridenv}
         {\global\setbox0=\vbox\bgroup}
         {\egroup%
          \xdef\fight{\the\ht0}%
          \roundoff%
          \leavevmode%
          \vadjust{\vskip0.5\figboxht%
                   \box0%
                   \vskip0.5\figboxht%
                   }\hfil\break%%
         }
\jot=\baselineskip
  \def\enumerate{%
    \ifnum \@enumdepth >\thr@@\@toodeep\else
      \advance\@enumdepth\@ne
      \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
        \expandafter
        \list
          \csname label\@enumctr\endcsname
          {\usecounter\@enumctr\def\makelabel##1{\hss\llap{##1}}%
           \topsep\z@\partopsep\z@\parskip\z@\itemsep\z@%
           \@outerparskip\z@\parsep\z@\@topsep\z@\@topsepadd\z@}%
    \fi}
  \def\itemize{%
    \ifnum \@itemdepth >\thr@@\@toodeep\else
      \advance\@itemdepth\@ne
      \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
      \expandafter
      \list
        \csname\@itemitem\endcsname
        {\def\makelabel##1{\hss\llap{##1}}%
         \topsep\z@\partopsep\z@\parskip\z@\itemsep\z@%
         \@outerparskip\z@\parsep\z@\@topsep\z@\@topsepadd\z@}%
    \fi}
\newcounter{section}
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]
\renewcommand*{\thesection}{\Alph{section}.}
\renewcommand*{\thesubsection}{\Roman{subsection}.}
\renewcommand*{\thesubsubsection}{\arabic{subsubsection}.}
\renewcommand*{\p@subsection}{\thesection}
\renewcommand*{\p@subsubsection}{\p@subsection\thesubsection}
\let\size@section\normalsize
\newcommand*{\scr@fnt@section}{\size@section}
\newcommand*{\scr@fnt@subsection}{\size@section}
\newcommand*{\scr@fnt@subsubsection}{\size@section}
\newcommand*\sectfont{\normalcolor\bfseries}
\newcommand*{\scr@fnt@disposition}{\sectfont}
\aliaskomafont{sectioning}{disposition}
\setcounter{secnumdepth}{4}
\newcommand\section{\@startsection{section}{1}{\z@}%
  {-0.999\baselineskip}%
  {0.001\baselineskip}%
  {\raggedsection\normalfont\usekomafont{disposition}\nobreak
    \usekomafont{section}\nobreak}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
  {\baselineskip}%
  {-0.35\baselineskip}%
  {\bfseries\unskip}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
  {\baselineskip}%
  {-.35\baselineskip}%
  {\itshape\unskip}}
\let\raggedsection\raggedright
\patchcmd\@startsection
    {\addvspace\@tempskipa}
    {\advance\@tempskipa-\parskip\addvspace\@tempskipa}
    {}{\typeout{Couldn't patch \string\@startsection}}
\patchcmd\@xsect
    {\vskip\@tempskipa}
    {\advance\@tempskipa-\parskip\vskip\@tempskipa}
    {}{\typeout{Couldn't patch \string\@xsect}}
\newcommand{\leil@facultypoboxname}{Postbus}
\ifthenelse{\equal{\leil@lang}{english}}{\renewcommand{\leil@facultypoboxname}{P.O.~Box}}{}
\newcommand{\leil@facultyname}{}
\newcommand{\leil@facultypobox}{}
\newcommand{\leil@facultyaddress}{}
\newcommand{\leil@facultyphone}{}
\ifthenelse{\equal{\leil@faculty}{fwn}}{
\ifthenelse{\equal{\leil@lang}{english}}{
\renewcommand{\leil@facultyname}{Faculty of Science}}{
\renewcommand{\leil@facultyname}{Faculteit der Wiskunde en Natuurwetenschappen}}
\renewcommand{\leil@facultypobox}{\leil@facultypoboxname~9502\\\textsc{2300~ra}~Leiden}
\renewcommand{\leil@facultyphone}{(071)\,527\,4400}
\renewcommand{\leil@facultyaddress}{Einsteinweg~55}
}{}
\ifthenelse{\equal{\leil@faculty}{law}}{
\ifthenelse{\equal{\leil@lang}{english}}{
\renewcommand{\leil@facultyname}{Faculty of Law}}{
\renewcommand{\leil@facultyname}{Faculteit der Rechtsgeleerdheid}}
\renewcommand{\leil@facultypobox}{\leil@facultypoboxname~9520\\\textsc{2300~ra}~Leiden}
\renewcommand{\leil@facultyphone}{(071)\,527\,7512}
\renewcommand{\leil@facultyaddress}{Steenschuur~25}
}{}
\ifthenelse{\equal{\leil@faculty}{arch}}{
\ifthenelse{\equal{\leil@lang}{english}}{
\renewcommand{\leil@facultyname}{Faculty of Archeology}}{
\renewcommand{\leil@facultyname}{Faculteit der Archeologie}}
\renewcommand{\leil@facultypobox}{\leil@facultypoboxname~9514\\\textsc{2300~ra}~Leiden}
\renewcommand{\leil@facultyphone}{(071)\,527\,3500}
\renewcommand{\leil@facultyaddress}{Einsteinweg~55}
}{}
\ifthenelse{\equal{\leil@faculty}{fgw}}{
\ifthenelse{\equal{\leil@lang}{english}}{
\renewcommand{\leil@facultyname}{Faculty of Humanities}}{
\renewcommand{\leil@facultyname}{Faculteit der Geesteswetenschappen}}
\renewcommand{\leil@facultypobox}{\leil@facultypoboxname~9514\\\textsc{2300~ra}~Leiden}
\renewcommand{\leil@facultyphone}{(071)\,527\,2300}
\renewcommand{\leil@facultyaddress}{Cleveringaplaats~1} 
}{}
\ifthenelse{\equal{\leil@faculty}{fsw}}{
\ifthenelse{\equal{\leil@lang}{english}}{
\renewcommand{\leil@facultyname}{Faculty of Social and Behavioural Sciences}}{
\renewcommand{\leil@facultyname}{Faculteit der Sociale Wetenschappen}}
\renewcommand{\leil@facultypobox}{\leil@facultypoboxname~9555\\\textsc{2300~rb}~Leiden}
\renewcommand{\leil@facultyphone}{(071)\,527\,3600}
\renewcommand{\leil@facultyaddress}{Wassenaarseweg~52}
}{}
\ifthenelse{\equal{\leil@faculty}{med}}{
\ifthenelse{\equal{\leil@lang}{english}}{
\renewcommand{\leil@facultyname}{Faculty of Medicine}}{
\renewcommand{\leil@facultyname}{Faculteit der Geneeskunde}}
\renewcommand{\leil@facultypobox}{\leil@facultypoboxname~9600\\\textsc{2300~rc}~Leiden}
\renewcommand{\leil@facultyphone}{(071)\,526\,9111}
\renewcommand{\leil@facultyaddress}{Einthovenweg~20}
}{}
\ifthenelse{\equal{\leil@faculty}{gga}}{
\ifthenelse{\equal{\leil@lang}{english}}{
\renewcommand{\leil@facultyname}{Faculty of Governance and Global Affairs}}{
\renewcommand{\leil@facultyname}{Faculteit Governance and Global Affairs}}
\renewcommand{\leil@facultypobox}{\leil@facultypoboxname~13228\\\textsc{2501~ee}~Den~Haag}
\renewcommand{\leil@facultyphone}{(070)\,800\,9500}
\renewcommand{\leil@facultyaddress}{Turfmarkt~99}
}{}
\ifthenelse{\boolean{leil@briefdrager}}{\relax}{
\RequirePackage{graphicx}
\DeclareNewLayer[
   background,
      align=tl,
      hoffset=24mm,
      voffset=35pt,
      addvoffset=22.35mm,% <- height of leiden-logo.pdf
      mode=picture,
      contents=\putUL{\includegraphics{leiden-logo}}
]{letterimage}
\AddLayersToPageStyle{@everystyle@}{letterimage}
}
\setkomavar{firsthead}{}
\DeclareNewLayer[
  background,
  height=56pt,
  width=48mm,
  voffset=74pt,
  hoffset=144mm,
  contents={%
\begin{raggedright}
\unskip\small\textbf{\leil@facultyname}\\
\ifdefined\leil@unit \leil@unit{} \fi
\end{raggedright}
  }
]{top.header}
\AddLayersToPageStyle{scrheadings}{top.header}
\AddLayersToPageStyle{empty}{top.header}
\defcaptionname{dutch}\pagename{Blad}
\DeclareNewLayer[
  background,
  height=10mm,
  width=22mm,
  voffset=144pt,
  hoffset=24mm,
  contents={%
  \pagename~\thepage/\letterlastpage
  }
]{margin.pagenumber}
\AddLayersToPageStyle{scrheadings}{margin.pagenumber}
\newcommand{\leil@number}{-- \ClassWarning{LEIletter}{Please, specify
    the number of the letter using the \noexpand\leilnumber macro
in the preamble of your letter.}}
\newcommand{\leilnumber}[1]{\renewcommand\leil@number{#1}}
\newcommand{\leil@yourref}{-- \ClassWarning{LEIletter}{Please, specify
    the number of the letter using the \noexpand\leilyourref macro
in the preamble of your letter.}}
\newcommand{\leilyourref}[1]{\renewcommand\leil@yourref{#1}}
\newcommand{\leil@subject}{-- \ClassWarning{LEIletter}{Please, specify
    the number of the letter using the \noexpand\leilsubject macro
in the preamble of your letter.}}
\newcommand{\leilsubject}[1]{\renewcommand\leil@subject{#1}}
\newcommand{\leil@title}{\ClassWarning{LEIletter}{Please, specify the title
of the sender using the \noexpand\leiltitle macro in a separate .lco
file or in the preamble of your letter.}}
\newcommand{\leiltitle}[1]{\renewcommand\leil@title{#1}}
\newcommand{\leil@firstname}{\ClassWarning{LEIletter}{Please, specify the
    first name of the sender using the \noexpand\leilfirstname macro in a
separate .lco file or in the preamble of your letter.}}
\newcommand{\leilfirstname}[1]{\renewcommand\leil@firstname{#1}}
\newcommand{\leil@lastname}{\ClassWarning{LEIletter}{Please, specify the last
    name of the sender using the \noexpand\leillastname macro in a separate
.lco file or in the preamble of your letter.}}
\newcommand{\leillastname}[1]{\renewcommand\leil@lastname{#1}}
\newcommand{\leil@email}{\ClassWarning{LEIletter}{Please, specify the email
    address of the sender using the \noexpand\leilemail macro in a separate
.lco file or in the preamble of your letter.}}
\newcommand{\leilemail}[1]{\renewcommand\leil@email{#1}}
\newcommand{\leil@directphone}{-- \ClassWarning{LEIletter}{Please, specify
    the direct dial phone number of the sender using the
\noexpand\leildirectphone macro in a separate .lco file or in the preamble
of your letter.}}
\newcommand{\leildirectphone}[1]{\renewcommand\leil@directphone{#1}}
\newcommand{\leil@contact}{-- \ClassWarning{LEIletter}{Please, specify
    the direct contact person for the sender using the \noexpand\leilcontact
macro in a separate .lco file or in the preamble of your letter.}}
\newcommand{\leilcontact}[1]{\renewcommand\leil@contact{#1}}
\newcommand{\leil@jobtitle}{-- \ClassWarning{LEIletter}{Please, specify the
    job title of the sender using the \noexpand\leiljobtitle macro in a
    separate .lco file or in the preamble of your letter.}}
\newcommand{\leiljobtitle}[1]{\renewcommand\leil@jobtitle{#1}}
\newcommand{\leil@building}{-- \ClassWarning{LEIletter}{Please, specify the
    building of the sender using the \noexpand\leilbuilding macro in a
    separate .lco file or in the preamble of your letter.}}
\newcommand{\leilbuilding}[1]{\renewcommand\leil@building{#1}}
\newcommand{\leil@unit}{-- \ClassWarning{LEIletter}{Please, specify the
    building of the sender using the \noexpand\leilunit macro in a
    separate .lco file or in the preamble of your letter.}}
\newcommand{\leilunit}[1]{\renewcommand\leil@unit{#1}}
\ifdefined\leil@author
\LoadLetterOption{\leil@author}
\setkomavar{signature}{\leil@title~\leil@firstname~\leil@lastname{}\\ \leil@jobtitle} 
\fi
\DeclareNewLayer[
  background,
  height=112pt,
  width=48mm,
  voffset=144pt,
  hoffset=144mm,
  contents={%
\small
\ifdefined\leil@building \leil@building \\ \fi
    \leil@facultyaddress \\
\leil@facultypobox \\
Telefoon~\leil@facultyphone{}\\
  }
]{firstpage.senderinfo}
\AddLayersToPageStyle{empty}{firstpage.senderinfo}
\newcommand{\leilNumbername}{Nummer}
\newcommand{\leilYourrefname}{Uw brief van}
\newcommand{\leilSubjectname}{Onderwerp}
\newcommand{\leilDatename}{Datum}
\newcommand{\leilDialdirectname}{Doorkiesnr.}
\newcommand{\leilContactname}{Contactpersoon}
\ifthenelse{\equal{\leil@lang}{english}}{
\renewcommand{\leilNumbername}{Number}
\renewcommand{\leilYourrefname}{Your letter of} 
\renewcommand{\leilSubjectname}{Subject}
\renewcommand{\leilDatename}{Date}
\renewcommand{\leilDialdirectname}{Dial-direct Nr.} 
\renewcommand{\leilContactname}{Contact} 
}{}
\DeclareNewLayer[
  background,
  height=70pt,
  width=170mm,
  voffset=270pt,
  hoffset=24mm,
  contents={%
\begingroup%\setlength\extrarowheight{-1pt}%
\unskip\begin{tabular}{@{}>{\small}p{24mm}@{}>{\small}p{48mm}@{}p{24mm}@{}>{\small}p{24mm}@{}>{\small}p{48mm}}
\textit{\leilNumbername} & \leil@number  & & \textit{\leilDatename} & \usekomavar{date} \\
\textit{\leilYourrefname} & \leil@yourref & & \textit{\leilDialdirectname} & \leil@directphone \\
\textit{\leilSubjectname} & \leil@subject{} & & \textit{\leilContactname} & \leil@contact \\
\end{tabular}
\endgroup
  }
]{firstpage.refline}
\AddLayersToPageStyle{empty}{firstpage.refline}
%% 
%% Copyright (C) 2009 by Michiel Kreutzer <m.t.kreutzer@science.leidenuniv.nl>
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License (LPPL), either
%% version 1.3c of this license or (at your option) any later
%% version.  The latest version of this license is in the file:
%% 
%% http://www.latex-project.org/lppl.txt
%% 
%% The Leiden University logo is licensed under the Creative Commons
%% Attribution-Share Alike 3.0 Unported license, as explained at
%% 
%% https://commons.wikimedia.org/wiki/File:UniversiteitLeidenLogo.svg
%% 
%% This work is "maintained" (as per LPPL maintenance status) by
%% Michiel Kreutzer.
%% 
%% This work consists of the file  LEIletter.dtx and
%%                                 leiden-logo.pdf
%% and the derived files           LEIletter.ins,
%%                                 LEIletter.pdf,
%%                                 LEIletter.cls,
%%                                 leiletter-voorbeeld.tex and
%%                                 medewerker.lco
%% 
%%
%% End of file `leiletter.cls'.
