BXglyphwiki パッケージバンドル
==============================

LaTeX: 「グリフウィキ」に登録された文字を利用する

フリーな「漢字字形共有サイト」である [グリフウィキ] で登録された漢字字形
を LaTeX 文書で簡単に利用できるようにする。

[グリフウィキ]: <http://glyphwiki.org/>

### 前提環境

  - TeX 処理系： pLaTeX、upLaTeX、XeLaTeX、LuaLaTeX
  - DVI ウェア（DVI 出力時）： dvips、dvipdfmx
  - LuaTeX エンジンを Lua インタプリタとして使用するのでインストール
    されている必要がある。
  - 前提パッケージ：
      * pdftexcmds、ifluatex、ifxetex
  - インターネットへのアクセス ;-)
  - HTTPS 接続のため、以下の **何れか** が必要
      - curl コマンド (SSL 対応のもの)
      - wget コマンド (SSL 対応のもの)
      - Windows の PowerShell
      - Lua の LuaSec モジュール

### インストール

`bxglyphwiki.sty` は `$TEXMF/tex/latex/BXglyphwiki` に移動する。

`bxglyphwiki.lua` については、それが `bxglyphwiki` というコマンド名で
実行可能であるようにする。具体的な手順は環境により異なる。 
（`$TEXMFBIN` は TeX 関連の実行ファイルの場所を表す。）

  * Unix 系 OS の場合：
      - ファイル名を `bxglyphwiki` に改名する。
      - 先頭の shebang を有効にし、実行可能権限を付与する。
      - 実行パスの通ったディレクトリに置く。

  * Windows 版 TeX Live の場合： 
      - `$TEXMFBIN/runscript.exe` を `bxglyphwiki.exe` という名前で
        コピーする。
      - それを実行パスの通ったディレクトリに置く。
      - `bxglyphwiki.lua` を `$TEXMF/scripts/BXglyphwiki` に移動する。

上述の説明が実行できない場合は、回避策として、`bxglyphwiki.lua` を
カレントディレクトリ（文書ファイルがある場所）に置いても動作する。

#### W32TeX の場合

現在の W32TeX は BXglyphwiki を含んでいる。インストールに以下のアーカイブ
を含めると BXglyphwiki が使用できる。

  - cjkzr.tar.xz
  - luasec-w32.tar.xz

bxglyphwiki パッケージ
----------------------

### パッケージの読込

    \usepackage[<オプション>]{bxglyphwiki}

パッケージオプション：

  - ドライバ指定： `dvips`、`dvipdfmx`、`pdftex`、`xetex`、`luatex`
    の何れか。（graphicx のドライバと同じにする。）
  - `download` （既定）： 「グリフウィキ」サイトからのダウンロードを
    行う。
  - `nodownload` ： ダウンロードを一切行わない。（既にダウンロードされた
    キャッシュファイルのみを使用する。）
  - `internallua` ： “internallua”モードを有効にする。Lua スクリプトを
    LuaTeX の内部の Lua 呼出により実行する。
  - `nointernallua` ： “internallua”モードを無効にする。
      * LuaLaTeX では `internallua` が、それ以外では `nointernallua` が
        既定値である。
  - `dir=<ディレクトリ名>` ： キャッシュファイルを置くディレクトリ。
    既定値は `.`（カレントディレクトリ）。
  - `cache=<数値>` ： キャッシュファイルの有効期限（分単位）。既定値は
    `10080` （一週間）。値を `forever` とすると無期限になる。

本パッケージは graphicx パッケージの読込を必要とする。graphicx が未読込の
場合でドライバ指定がある場合はそのドライバで自動的に graphicx を読み込む。
逆に、graphicx が既に読み込まれている場合は、ドライバ指定が省略可能で、
その場合は graphicx のドライバ指定を引き継ぐ。

本パッケージでは外部 Lua スクリプトの実行を利用するので、シェル呼出機能を
有効にする（コマンドラインで `-shell-escape` オプションを指定する）必要が
ある。シェル呼出機能が無効である場合は自動的に `nodownload` オプション
指定時の動作にフォールバックする。

※以前の版では、“internallua”モードでの動作には制限付シェル呼出しか必要
とせず `-shell-escape` は不要であった。しかし現在では HTTPS 接続のために
外部コマンド呼出（か外部ライブラリ読込の何れか）が要求されるため、LuaTeX
においても `-shell-escape` が必要である。

### 機能

#### グリフ出力

  * `\GWI[*][<バージョン指定>]{<グリフ名>}` ：
    指定のグリフ名の文字（グリフ）を出力する。

バージョン指定のオプションは以下の通り。既定値は `+` であるが、`*` 付き
の場合は `*` となる（`\GWI*{...}` は `\GWI[*]{...}` と同じ）。

  * `<数字>` ： 指定のバージョンのみを使用する。
      - 指定のバージョンのキャッシュが有効（期限内）ならそれを使用。
      - そうでないならダウンロードを行う。
      - それが失敗した場合はフォールバック表示。
  * `+` ： 最新のバージョンを使用する。
      - *何れかのバージョンの* キャッシュが有効なら、 *全ての* バージョン
        の中で最新のものを使用する。
      - そうでないなら最新のバージョンをダウンロードする。
      - それが失敗した場合はフォールバック表示。
  * `*` ： キャッシュの中で最新のバージョンを使用する。
      - *何れかのバージョンの* キャッシュが有効なら、 *全ての* バージョン
        の中で最新のものを使用する。
      - そうでないならキャッシュに存在する全てのバージョンの中で最新の
        ものをダウンロードする。
      - それが失敗した場合はフォールバック表示。
  * `<数字>+` ： `+` と同様だが、指定した値以降のバージョンのみを使用
    する。
  * `<数字>*` ： `*` と同様だが、指定した値以降のバージョンのみを使用
    する。

#### パラメタ設定

  * `\setgwscale{<実数>}` ：
    グリフ出力のスケールの倍率を指定する。既定値は 1.05。
    ※この値が 1 の場合は 1zw 四方の正方形に合わせて画像データが出力
    される。値が 1 以外の場合も、文字の外見の横幅は 1zw のままである。

  * `\setgwyvertadjust{<実数>}` ：
    横組時のグリフの出力位置の上方向の補正値。既定値は 0。

  * `\setgwtvertadjust{<実数>}` ：
    縦組時のグリフの出力位置の“上方向”（実際は右方向）の補正値。
    既定値は 0。

更新履歴
--------

  * Version 0.5  〈2020/08/28〉
      - 「グリフウィキ」の API の仕様の変更に伴い HTTPS 接続に対応させた。
  * Version 0.4c 〈2019/11/26〉
      - 入力漢字コードの自動判別の誤判定への対処。
  * Version 0.4b 〈2019/11/24〉
      - Lua 5.3 に対応した。
  * Version 0.4a 〈2017/05/07〉
      - XeTeX／LuaTeX ではドライバを自動推定する。
      - 縦組時の処理を改良。
  * Version 0.4  〈2016/05/05〉
      - LuaTeX v0.85 以降への対応。
      - “internallua”モードを追加。
      - LuaTeX-ja の縦組みモードに対応。
  * Version 0.3b 〈2015/07/20〉
      - 出力する文字の高さ・深さについて、`\cht`・`\cdp` が利用可能なら
        それに合わせるようにした。
      - README を更新。
  * Version 0.3a 〈2015/05/06〉
      - 「グリフウィキ」の一部のグリフにおいて、v0.3 で決め打ちした形式
        （単一の path 要素）とは異なる形式（polygon 要素を含む）の SVG
        画像が使用されていたので、それに対応した。
  * Version 0.3  〈2015/02/26〉
      - 「グリフウィキ」の EPS 画像出力機能が廃止になったので、SVG 画像
        をダウンロードしてそれを（一旦）EPS に変換する方式に変更した。
        SVG→EPS の変換ロジックはグリフウィキの出力するファイルに特化
        したものとなっている。
      - `\setgwscale`、`\setgwyvertadjust`、`setgwtvertadjust` を新設。
  * Version 0.2  〈2013/10/16〉
      - 最初の公開版

--------------------
Takayuki YATO (aka. "ZR")  
https://github.com/zr-tex8r
