/* Copyright 2007, 2008 Taco Hoekwater.
   You may freely use, modify and/or distribute this file.  */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

static const char __svn_version[] =
    "$Id: makecpool.c 1230 2008-05-03 11:11:32Z oneiros $ $URL: http://scm.foundry.supelec.fr/svn/luatex/trunk/src/texk/web2c/luatexdir/makecpool.c $";

int main(int argc, char *argv[])
{
    char *filename;
    char *fname;
    FILE *fh;
    int b, c; 
    c =0;
    if (argc != 2) {
      fprintf(stderr,
              "%s: need one argument (lua input file name).\n",
              argv[0]);
      exit(EXIT_FAILURE);
    }
    filename = argv[1];
    fh = fopen(filename, "r");
    if (!fh) {
      fprintf(stderr, "%s: can't open %s for reading.\n", argv[0], filename);
      exit(EXIT_FAILURE);
    }
    fname = strdup(filename);
    *(fname + strlen(filename)-4) = '_';
    printf("/*\n"
           " * This file is auto-generated by \"%s %s %s\"\n"
           " */\n\n"
           "#include \"lua.h\"\n"
           "#include \"lauxlib.h\"\n\n"
           "int luatex_%s_open (lua_State *L) { \n"
           "    static unsigned char B[] = {\n   "
           , argv[0], filename, fname, fname );

    while ((b = fgetc(fh))!=EOF) {
      c++;
      if (b==0) {
        fprintf(stderr,"NULL found!\n");
        return EXIT_FAILURE;
      }
      printf("%3u," ,b);
      if (c==20) {
        printf("\n");
        c=0;
      }
    }
    fclose(fh);

    printf("\n 0 };\n"
           "  return luaL_dostring(L, (const char*)B); \n"
           "} /* end of embedded lua code */\n\n");

    return EXIT_SUCCESS;
}
