/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:       unq_str.lex
Date:       1 Juin 2003
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |unq_str| Thread.\fbreak
This recognizer could be
 used in a ``file name'' option of
  a command line sequence: a quoted filename is used if it 
contains spaces or other abnormal characters
to be included as part of it.
The expression recognized is crude: just a wild character loop. 
Once parsed, it does no checking.
It is left for the calling context to do the validity check.
Regarding file processing,
one must still go to the file system for the existance check. 
\fbreak
Note how the lookahead (LA) character (current token) 
is checked using fsm's 
|la_bnds_chk|
function to turn off the \allshift consumption. 

Why is there no escape sequence like UNIX's scripting: 
the blackslash character-to-literal-accept?
Well i'm not fighting different contexts and
how many variants do u need?
Hear the stomping of my foot? Enough ... just quote it!
@/
fsm	
(fsm-id	"unq_str.lex",fsm-filename unq_str,fsm-namespace NS_unq_str
,fsm-class		Cunq_str{
	user-declaration
		public:
		bool la_bnds_fnd(CAbs_lr1_sym* Sym){
			using namespace NS_yacco2_terminals;
			int id = Sym->enumerated_id__;
			switch (id){
	        case T_Enum::T_raw_open_brace_: break;
	        case T_Enum::T_raw_close_brace_: break;
	        case T_Enum::T_raw_lf_: break;
	        case T_Enum::T_raw_cr_: break;
			case T_Enum::T_LR1_eog_: break;
			case T_Enum::T_T_eol_: break;
			case T_Enum::T_raw_ht_: break;
			case T_Enum::T_raw_sp_: break;
			case T_Enum::T_raw_vt_: break;
			case T_Enum::T_raw_ff_: break;
			case T_Enum::T_raw_dbl_quote_: break;
			default:{
				return false;
				}
			}
			return true;
		};
		std::string c_;
	***
	op
	  parser__->set_use_all_shift_on();
	  c_.erase();
	  if(la_bnds_fnd(parser__->start_token__) == true)
	    parser__->set_use_all_shift_off();// stop the parse
	***
  }
,fsm-version	"1.0"	,fsm-date		"29 Nov. 2002"
,fsm-debug		"false"	,fsm-comments	"Unquoted string of characters: raw and basic.")
parallel-parser	
(	
  parallel-thread-function
    TH_unq_str
  ***
  parallel-la-boundary
eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{	
Runq_str  (){
  -> Rchr {
    op
	  Cunq_str* fsm = (Cunq_str*)rule_info__.parser__->fsm_tbl__;	  
      CAbs_lr1_sym* sym = new T_unquoted_string(fsm->c_);
      sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
      RSVP(sym);
    ***
	}
}

Rchr  (){	
  -> Rall_shift
  -> Rchr Rall_shift
}

Rall_shift  (){
  -> |+|{
    op
	  Cunq_str* fsm = (Cunq_str*)rule_info__.parser__->fsm_tbl__;	  
	  CAbs_lr1_sym* sym = sf->p1__;
	  fsm->c_ += sym->id__;
	  if(fsm->la_bnds_fnd(rule_info__.parser__->current_token()) == true){// chk LA
	    rule_info__.parser__->set_use_all_shift_off();
	  }
	***
    }
}
}// end of rules
