/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/*
 * Default path and directory definitions and such. The .o file of this file is always
 * removed after a "make prepare" in the main directory.
 * This way it is made sure, that any changes to variables in
 * local-defs are passed along to the other programs. This module is
 * included by dvitps, pfd2tfm and printpdr.
 */

/* The final value used may be changed to to environment variables. */
char *texfonts_default = TEXFONTS_DEF;

char *tmpdir_default = TMPDIR;

/* The final value may be changed due to the -P option of the driver. */
char *driver_ps_prologue_path = DVITPS_PROLOGUE_FILES_PATH_DEF;

/* The final value may be changed due to the ... option of the driver */
char *dvitps_cap_dir = DVITPS_CAP_DIR;

int OrderOfOutput = DVITPS_DEFAULT_ORDER;

int PsPrintEnabled = DVITPS_PS_PRINT_ENABLED;

int TpicIsEnabled = TPIC;

char *DvitpsBinaryName = DVITPS_BINARY_NAME;

/* Maximum number of characters in a pixel based font. Must be
   either 128 or 256. This value is sent to the printer
   (NumCharsInPixelFonts PostScript Variable) */
int NumCharsInPixelFonts = NUMBER_CHARS_IN_PIXEL_FONTS;

/* Default afm path */
char *afm_path_default = AFMPATH_DEF;

/* Default encoding for PS fonts can be found in this directory. */
char *ps_def_encodings_dir = PS_DEF_ENCODINGS;

/* Can PostScript write information into a log file? This is used
   for the TransScript log file writing. */
int  DvitpsPsPrintEnabled = DVITPS_PS_PRINT_ENABLED;

/* Default paper format specification. */
char *DefaultPaperSpec = DEFAULT_PAPER_SPEC;

/*
 * DvitpsCheckDefaults
 * *******************
 * This routine checks whether some of the default settings
 * for the driver are done correctly. Not very much is done here....
 */
void
DvitpsCheckDefaults()
{
  if (NumCharsInPixelFonts != 128 &&
      NumCharsInPixelFonts != 256)
    Fatal ("DvitpsCheckDefaults(): NUMBER_CHARS_IN_PIXEL_FONTS must be either 128 or 256.");
}
