/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */


/*
 * Code to fix the font widths according to specification in
 * the PFD file.
 */

#include <stdio.h>
#include <sys/file.h>
#include "defs.h"
#include "pfd2tfm.h"
#include "char.h"

extern CAFM AfmChar[MAX_CHAR_PS];

int ChangeWidthArrayIndex;

struct cw {
  char * cw_name; /* name of the character */
  int cw_code; /* which code */
  int cw_amount; /* how much */
} ChangeWidthArray[PFD_CHANGES_WIDTH];

/*
 * ChangeWidthPfd
 * **************
 * This procedure is called after a ChangeWidth instruction in the PFD
 * file has been read in. The procedure will save the change for future
 * references. FixFontWidths() incorporates the changes
 * into the AfmChar data structure.
 * name: name of the character, for which the width is changed.
 * amount: the new width of this character.
 */
ChangeWidthPfd(name, amount)
char * name;
int amount;
{
  ChangeWidthArray[ChangeWidthArrayIndex].cw_name = name;
  ChangeWidthArray[ChangeWidthArrayIndex].cw_amount = amount;
  ChangeWidthArray[ChangeWidthArrayIndex].cw_code = -1;
  if (++ChangeWidthArrayIndex == PFD_CHANGES_WIDTH)
    Fatal ("ChangeWidthPfd(): too many ChangeWidth instructions in pfd file");
}

/*
 * FixFontWidths
 * *************
 * After the AFM file has been read in, we call this procedure
 * to incorporate those changes into the current AFM structure.
 * This way the changes get into the TFM file.
 */
FixFontWidths()
{
  int i;

  for (i=0; i<ChangeWidthArrayIndex; i++) {
    ChangeWidthArray[i].cw_code =
      CharNameToIndex(ChangeWidthArray[i].cw_name);
    AfmChar[ChangeWidthArray[i].cw_code].c_wx =
      ChangeWidthArray[i].cw_amount;
  } /* for */
}

/*
 * InitFixFontWidths
 * *****************
 * Initialize the changing of font widths.
 */
InitializeFixFontWidths()
{
  ChangeWidthArrayIndex = 0;    
}
