[a-zA-Z][-a-zA-Z0-9]*   {
		return (T_ID);
	    }

[-]*[0-9]+  {
		 if (sscanf (yytext, "%d", &LexInt) != 1)
		    Fatal ("special-1.lex(): error scanning integer.");
		 return (T_INT);
	    }

[-]*[0-9]+\.[0-9]* { /* Two different formats of flp numbers: first one
			requires at least one digit before the period, and a period followed
			by optional digit(s). */
		 if (sscanf (yytext, "%lf", &LexDouble) != 1)
		   Fatal ("special-2.lex(): error scanning double.");
		 return (T_DOUBLE);
	    }

[-]*[0-9]*\.[0-9]+ { /* Second format of flp numbers: leading digits may be missing. */
		 if (sscanf (yytext, "%lf", &LexDouble) != 1)
		   Fatal ("special-2.lex(): error scanning double.");
		 return (T_DOUBLE);
	    }
\"[^"]*\"   {
		/* Strip off the quotes of the string.
		   Save the string in its own dynamically allocated
		   buffer. */
		SpecialStringReturn = StrncpyAlloc(yytext+1, strlen(yytext)-2);
		*(SpecialStringReturn+strlen(yytext)-2) = '\0';
		return (T_STRING_QUOTED);
	    }

.               {return (T_ILLEGAL);}
%%
