";"		{return (T_SEMICOLON);}
"Comment"[^\n]+$  {yylval.s = StrcpyAlloc(yytext);
			return (S_Comment);}
"Notice"[^\n]+$   {yylval.s = StrcpyAlloc(yytext);
			return (S_Notice);}

[a-zA-Z][-a-zA-Z0-9]*   {
		yylval.s = StrcpyAlloc(yytext);
		return (T_ID);
		}

[-]*[0-9]+       {
		 if (sscanf (yytext, "%d", &yylval.i) != 1)
		    Fatal ("afm-2.lex(): error scanning integer");
		 if (LexDebug) {
		    fprintf (stderr, "Integer is %d\n", yylval.i);
		    fflush (stderr);
	         }
		 return (T_INT);
	       }

[-]*[0-9]+\.[0-9]+        {
		 if (sscanf (yytext, "%lf", &yylval.d) != 1)
		   Fatal ("afm-2.lex(): error scanning float");
		 if (LexDebug) {
		   fprintf (stderr, "Floating point number is %6.2lf\n",
				yylval.d);
		   fflush (stderr);
	         }
		 return (T_FLOAT);
	       }

.               {return (T_ILLEGAL);}
%%
