";"		{return (T_SEMICOLON);}
","		{return (T_COMMA);}

\"[^"]*\"   {
		/* Strip off the quotes of the string.
		   Save the string in its own dynamically allocated
		   buffer. */
		yylval.s = StrncpyAlloc(yytext+1, strlen(yytext)-2);
		if (LexDebug)
		  fprintf (stderr, "STRING: \"%s\"\n", yylval.s);
		return (T_STRING);
		}

[A-Za-z][A-Za-z0-9]* {
		yylval.s = StrcpyAlloc(yytext);
		if (LexDebug)
		  fprintf (stderr, "ID: \"%s\"\n", yylval.s);
		return (T_ID);
		}

[-]*[0-9]+  {
		 if (sscanf (yytext, "%d", &yylval.i) != 1)
		    Fatal ("pfd-2.lex(): error scanning integer");
		 if (LexDebug) {
		     fprintf (stderr, "Integer is %d\n", yylval.i);
		     fflush (stderr);
	         }
		 return (T_INT);
	       }

8#[0-7]+  {
		/* Skip '8#' when reading the number */
		 if (sscanf (yytext+2, "%o", &yylval.i) != 1)
		    Fatal ("pfd-2.lex(): error scanning octal");
		 if (LexDebug) {
		     fprintf (stderr, "Octal is %o\n", yylval.i);
		     fflush (stderr);
	         }
		 return (T_INT);
	       }

16#[0-9a-fA-F]+  {
		/* Skip '16#' when reading the number */
		 if (sscanf (yytext+3, "%x", &yylval.i) != 1)
		    Fatal ("pfd-2.lex(): error scanning hexadecimal");
		 if (LexDebug) {
		     fprintf (stderr, "Hexadecimal is %d\n", yylval.i);
		     fflush (stderr);
	         }
		 return (T_INT);
	       }

[-]*[0-9]+\.[0-9]+        {
		 if (sscanf (yytext, "%lf", &yylval.d) != 1)
		    Fatal ("pfd-2.lex(): error scanning float");
		 if (LexDebug)
		    fprintf (stderr, "Floating point number is %6.2lf\n",
				yylval.d);
		 return (T_FLOAT);
	       }

"%".*$          {;}

.               {return (T_ILLEGAL);}
%%
