!!/bin/sh
!
!   This script file makes a new TeX PK font, because one wasn't
!   found.  Parameters are:
!
!   name dpi bdpi magnification [mode]
!
!   `name' is the name of the font, such as `cmr10'.  `dpi' is
!   the resolution the font is needed at.  `bdpi' is the base
!   resolution, useful for figuring out the mode to make the font
!   in.  `magnification' is a string to pass to MF as the
!   magnification.  `mode', if supplied, is the mode to use.
!
!   Note that this file must execute Metafont, and then gftopk,
!   and place the result in the correct location for the PostScript
!   driver to find it subsequently.  If this doesn't work, it will
!   be evident because MF will be invoked over and over again.
!
!   Of course, it needs to be set up for your site.
!
! TEMPDIR needs to be unique for each process because of the possibility
! of simultaneous processes running this script.
$ PID = f$getjpi ("","PID")
$ TEMPDIR := d11:[SCRATCH.'PID]
$ TEMPDIRNAME := d11:[scratch]'PID.dir.1
$ NAME := P1
$ DPI  = f$integer(P2)
$ BDPI = f$integer(P3)
$ MAG  = f$edit(P4,"LOWERCASE")
$ MODE = P5
$ if MODE .EQS. "" then 
$   if BDPI .EQ. 300 
$   then
$      MODE := "imagen"
$      goto GotMode
$   endif
$   if BDPI .EQ. 400 
$   then
$      MODE := "nexthi"
$      goto GotMode
$   endif
$   if BDPI .EQ. 100 
$   then
$      MODE := "nextscreen"
$      goto GotMode
$   endif
$   if BDPI .EQ. 635 
$   then
$      MODE := "linolo"
$      goto GotMode
$   endif
$   if BDPI .EQ. 1270
$    then
$      MODE := "linohi"
$      goto GotMode
$   endif
$   if BDPI .EQ. 2540
$    then
$      MODE := "linosuper"
$      goto GotMode
$   endif
$   write sys$output "I don't know the mode for ",BDPI
$   write sys$output "Have your system admin update MakeTeXPK"
$   exit 1
$ GotMode:
$ 
$ GFNAME = f$fao("!AS.!ASgf",'NAME,f$string(DPI))
$ PKNAME = f$fao("!AS.!ASpk",'NAME,f$string(DPI))
$ 
$ pkfilename = f$fao("tex_pk:!AS",PKNAME)
$ pkfile = f$search (pkfilename)
$ if pkfile .EQS. "" 
$ then
$!    Clean up on normal or abnormal exit
$     on control_y then goto ControlY
$     on error then goto ControlY
$     on severe_error then goto ControlY
$ 
$     create/dir 'TEMPDIR
$     OLDDIR = f$environment("DEFAULT")
$     set def 'TEMPDIR
$     command = f$fao ("mf ""\mode:=!AS; mag:=!AS; batchmode; input !AS""",MODE,MAG,'NAME)
$     write sys$output command
$     command
$
$     gffile = f$search (gfname)
$     if gffile .EQS. ""
$     then
$         write sys$output "Metafont failed for some reason on ",gfname
$         goto ControlY
$     endif
$  
$     gftopk 'gfname 
$
$     copy 'pkname tex_pk:'pkname
$     set prot=(o:r,g:r,w:r) tex_pk:'pkname
$     goto GoodExit
$ else
$     write sys$output "tex_pk:",PKNAME," already exists!"
$     exit 
$ endif
$
$
$ GoodExit:
$   set default 'olddir
$   delete 'tempdir*.*.*
$   set prot=w:rewd 'tempdirname
$   delete 'tempdirname
$   exit 
$
$ ControlY:
$   set default 'olddir
$   delete 'tempdir*.*.*
$   set prot=w:rewd 'tempdirname
$   delete 'tempdirname
$   exit 1
