#include <stdio.h>
#include <ctype.h>
#include <X11/Xlib.h>

/* X toolkit header files */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

/* Widget header files. */

/*
 * Insure that a single directory is in the font path
 */

extern char *ProgName;

static int
fontPathInsureSingleDirectory(dpy, path)
     Display *dpy;
     char *path;
{
  int ncurrent;
  int i;
  char **currentList = XGetFontPath (dpy, &ncurrent);
  if (!currentList) {
    fprintf (stderr, "%s:  unable to get old font path.\n",
	     ProgName);
    return(0);
  }
  
  
  for ( i= 0; i < ncurrent; i++ ) {
    if ( strcmp(currentList[i], path) == 0 ) {
      /* it's in there .. */
      return(1);

    }
  }
  
  /* Wasn't found, so install it at the beginning */
  
  {
    char **newList = (char **) malloc( sizeof( char *) * (ncurrent + 1) );

    for (i = 0 ; i < ncurrent; i++ ) {
      newList[i] = currentList[i];
    }
    newList[ncurrent] = path;

    XSetFontPath(dpy, newList, ncurrent + 1);
    free( newList );
    XFreeFontPath( currentList );
  }
}

fontPathInsurePaths(dpy, stringOfPaths)
     Display *dpy;
     char *stringOfPaths;
{

  /* make a copy of stringOfPaths, because we modify it */

  int len = strlen( stringOfPaths );

  if (len > 0) {
    char *newString = (char *) malloc( sizeof(char ) * (len + 1) );
    char *start, *end;
    int done = FALSE;

    strcpy(newString, stringOfPaths);

    start = end = newString;

    done = (start == 0 || *start == 0);

    while ( !done ) {

      int atEnd;

      while ( start && isspace(*start) ) start++;
      end = start;
      while ( end && *end != 0 && ! (*end == ',' || *end == ':') ) end++;
      done = (*end == 0);

      /* terminate string, check it's non-null and shove to X server */

      *end = 0;
      if ( strlen(start) >  0) {
	fontPathInsureSingleDirectory( dpy, start );
      }

      start = end + 1;

    }

    /* delete copy we allocated */

    free( newString );
  }
}
