/*
** Datei: DVISPLIN.H
** Autor: Ingo Eichenseher
*/

#ifdef IBMPC
# define MAX_VERTICES 500
typedef float real;
#else
# define MAX_VERTICES 1000
typedef double real;
#endif

# define MAX_INTERVAL 20

# define MAX_X 32767

typedef struct coord
{
    real    x,y;
} coord;

typedef struct interval_t
{
    real    t0, t1;
} interval_t;

extern void setdash(real *pat, int len);
extern void setlinewidth(real width);
extern void setlinecap(int startstyle, int endstyle);
extern void setarrowsize(real width, real length);
extern void setarrowline(real linewidth);
extern void setarrowshape(real t, real l);
extern void setdotsize(real diam);
extern void gr_defaults(void);
extern void gr_init(long mag, long orig_mag);
extern void gr_error(char *format, ...);
extern int  gr_install(void);
extern void gr_destall(void);

extern void spline(const coord *, int, const interval_t *, int, int);
extern void g_dot(const coord *p);
extern void g_draw(const coord *p, const coord *q, coord *r, int n, int closed);
extern void g_dpoly(const coord *p, const coord *r, int n, int closed);

extern void clip_init(void);
extern int  clip_exec(unsigned char *clip_mask);
extern void clip_end(void);
extern void clip_clean(int phase);
