Program Afm2Tex_A;      {  Version 1.6   -- 12. Mai 1994}
                    { fuer Adobe(tm) und Corel's Wfnboss(tm)}
Uses DOS;

{ (c) 1994, 1995 Markus Neteler    Hannover
  email: neteler@geog.uni-hannover.de

PROGRAMMBESCHREIBUNG:

 Afm2TeXA stellt afm-Dateien in die richtige Reihenfolge fuer TeX um und
 speichert die neuen Informationen in *.aft.
 Anschlieend kann Afm2Tfm angewendet werden, fuer TeX ist damit keine
 neue Encodierung der Zeichen noetig. D.h., die Schriften koennen wie
 die computer-modern-Schriften verwendet werden.

ZU AENDERNDE BUCHSTABEN IN ZEICHENSATZ.AFM :

 !! Postscript Adobe-Standard-Encoding (original Adobe-afm) !!
          ( Adobe(tm) und Corel's Wfnboss(tm))
 Bei anderen Encodierungen (ghostscript's getafm) afm2texG.exe benutzten.
 Um die vorliegende Encodierung zu ueberpruefen, kann die Datei <font>.afm
 angesehen werden. Dort muss das Zeichen "grave" der Nummer C 128 zugeordnet
 sein: "C 128 ... grave " oder C 96: "C 96 ... grave.


  Postscript (sort.)   TeX        myNo.    | myNo.    PS      TeX (sort.)
   (Org-number)       (for .aft)           |          No.     No. (for .aft)
-------------------------------------------|--------------------------------
    34  quotedbl        125       23       |   1      137 fi             12
    128 grave           18         4       |   2      138 fl             13
    129 circumflex      24         8       |   3      131 dotlessi       16
    130 tilde           126       24       |   4      128 grave          18
    131 dotlessi        16         3       |   5      180 acute          19
    133 quotedblleft    92        19       |   6      143 breve          21
    134 quotedblright   34        16       |   7      176 ring           23
    137 fi              12         1       |   8      129 circumflex     24
    138 fl              13         2       |   9      223 germandbls     25
    141 endash          123       21       |  10      230 ae             26
    143 breve           20         6       |  11      247 oe             27
    161 exclamdown      60        17       |  12      248 oslash         28
    168 dieresis        127       25       |  13      198 AE             29
    173 emdash          124       22       |  14      215 OE             30
    176 ring            23         7       |  15      216 Oslash         31
    180 acute           19         5       |  16      134 quotedblright  34
    183 periodcentered  95        20       |  17      161 exclamdown     60
    191 questiondown    62        18       |  18      191 questiondown   62
    198 AE              29        13       |  19      133 quotedblleft   92
    215 OE              30        14       |  20      183 periodcentered 95
    216 Oslash          31        15       |  21      141 endash         123
    223 germandbls      25         9       |  22      173 emdash         124
    230 ae              26        10       |  23       34 quotedbl       125
    247 oe              27        11       |  24      130 tilde          126
    248 oslash          28        12       |  25      168 dieresis       127
                                         (maxletters)

 1. Change const. maxletters, if adding letters!
 2. Add numbers to Dummy-Table!
 3. Change writing-out part of program!
----------------------------------------------------------------------------

ACHTUNG: Es muessen echte "carriage returns" an den Zeilenenden der
         afm-Datei stehen!
}
const maxletters =25;

Type Str255=String[255];
     Str25 =String[25];

var f,p             : Text;
    PostscriptAlt   : Array[0..maxletters] of Str255;
    PostscriptNeu   : Array[0..maxletters] of Str255;
    Zeile1,Dummy    : Str255;
    DatName,DatName2: String[12];
    i,k             : Integer;
    PS              : Array[1..maxletters] of Integer;
    TeX             : Array[1..maxletters] of String[3];
    flag            : Boolean;
    Fehler          : Byte;


Procedure breve(Var Kette:Str255);
Var Zeichenkette : Str255;
    j            : Integer;

begin
 Zeichenkette:='C ';
 j:=1;
 While not (Kette[j] in ['0'..'9']) do j:=j+1;
 Zeichenkette:=Zeichenkette+TeX[7];
 While not (Kette[j]=' ') Do j:=j+1;
 While not (Length(Kette)=j+1) Do Begin
    Zeichenkette:=Zeichenkette + Kette[j];
    j:=j+1;
 End;
 Kette:=Zeichenkette+' ;';
end;

Procedure Analyse(Var Kette:Str255);
Var Zeichenkette : Str255;
    j            : Integer;

Begin
 Zeichenkette:='';
 j:=1;
 While not (Kette[j] in ['-','0'..'9']) do j:=j+1;

  { C -1 ; WX ... -> C 00 ; WX ... : unschaedlich machen}
 If (Kette[j]='-') then Begin
                         Kette[j]:='0';
                         Kette[j+1]:='0'
                        End;

 While not (Kette[j]=' ') Do Begin
    Zeichenkette:=Zeichenkette + Kette[j];
    j:=j+1;
 End;
 Kette:=Zeichenkette;
End;

function IToS(i: Longint): string;
{ Convert any Integer type to a string }
var s: string[11];
begin
  Str(i, s);
  IToS := s;
end;

function Datum:Str25;
const days : array [0..6] of String[9] =
             ('sunday','monday','tuesday',
              'wednesday','thursday','friday',
              'saturday');
var
  y, m, d, dow : Word;
begin
  GetDate(y,m,d,dow);
  Datum:= days[dow]+', '+ ItoS(d)+ '.'+ ItoS(m)+ '.'+ ItoS(y);
end;

Function Zeit:Str25;
 var h, m, s, hund : Word;

   function LeadingZero(w : Word) : String;
   var  s : String;
   begin
     Str(w:0,s);
     if Length(s) = 1 then
        s := '0' + s;
     LeadingZero := s;
   end;
begin
  GetTime(h,m,s,hund);
  Zeit:=LeadingZero(h)+':'+LeadingZero(m)+':'+LeadingZero(s)+'.'+LeadingZero(hund);
end;

Procedure Analyse2(Var Kette:Str255);
Var Zeichenkette : Str255;
    j            : Integer;
Begin
 Zeichenkette:='C ';
 j:=1;
 While not (Kette[j] in ['0'..'9']) do j:=j+1;
 Zeichenkette:=Zeichenkette+TeX[i];
 While not (Kette[j]=' ') Do j:=j+1;
 While not (Length(Kette)=j+1) Do Begin
    Zeichenkette:=Zeichenkette + Kette[j];
    j:=j+1;
 End;
 Kette:=Zeichenkette+' ;';
End;


Begin       {main program}
 For i:=1 to maxletters Do Begin
  PS [i]:=0;
  TeX[i]:='';
 End;
 For i:=0 to maxletters Do PostscriptAlt[i]:='';
 For i:=0 to maxletters Do PostscriptNeu[i]:='';

 {Tex-numbers from TeX-sorted}
  TeX[1 ]:='12';
  TeX[2 ]:='13';
  TeX[3 ]:='16';
  TeX[4 ]:='18';
  TeX[5 ]:='19';
  TeX[6 ]:='21';
  TeX[7 ]:='23';
  TeX[8 ]:='24';
  TeX[9 ]:='25';
  TeX[10]:='26';
  TeX[11]:='27';
  TeX[12]:='28';
  TeX[13]:='29';
  TeX[14]:='30';
  TeX[15]:='31';
  TeX[16]:='34';
  TeX[17]:='60';
  TeX[18]:='62';
  TeX[19]:='92';
  TeX[20]:='95';
  TeX[21]:='123';
  TeX[22]:='124';
  TeX[23]:='125';
  TeX[24]:='126';
  TeX[25]:='127';

{Standard-Adobe-encoding }
{myNo-numbers from Postscript-sorted}
 PS[1 ]:=23;
 PS[2 ]:= 4;
 PS[3 ]:= 8;
 PS[4 ]:=24;
 PS[5 ]:= 3;
 PS[6 ]:=19;
 PS[7 ]:=16;
 PS[8 ]:= 1;
 PS[9 ]:= 2;
 PS[10]:=21;
 PS[11]:= 6;
 PS[12]:=17;
 PS[13]:=25;
 PS[14]:=22;
 PS[15]:= 7;
 PS[16]:= 5;
 PS[17]:=20;
 PS[18]:=18;
 PS[19]:=13;
 PS[20]:=14;
 PS[21]:=15;
 PS[22]:= 9;
 PS[23]:=10;
 PS[24]:=11;
 PS[25]:=12;

 Writeln('     --* Conversion of .afm fontdefinitions to TeX      -  V1.6  1994 *--');
 Writeln('                 for the use with afm2tfm                (c) M. Neteler');
 Writeln;
 Writeln('              Encoded for postscript-fonts made by ');
 Writeln('                 Adobe (tm), Corel`s Wfnboss (tm)  ');
 Writeln('                   and Fontographer-Apple (tm) ');
 Writeln('                            ** **              ');
 Writeln;
 Writeln('                   check font.afm for          ');
 Writeln('                      "C 128 ... grave" or     ');
 Writeln('                      "C 96  ... grave"         ');
 Writeln;
 Writeln('                    else use afm2texG.exe        ');
 Writeln;
 If Paramcount=0 Then Begin
     Write(' Name of font (with extension .afm): ');
     Readln(Datname);
    End
 Else Datname:=Paramstr(1);

 DatName2:='';
 i:=1;
 While not ((DatName[i] ='.') or (i=Length(DatName)+1)) do Begin
  DatName2:=DatName2+Datname[i];
  i:=i+1
 End;
 If Datname2='' Then Halt;
 Datname:=Datname2;
 {$i-}
 Assign(f,DatName+'.afm');
 Reset(f);
 Writeln;
 Writeln;
 Writeln;
 Fehler:=IOResult;
 IF Fehler=2 Then Begin Writeln(' Problem! '+DatName+'.afm not found...'); Halt end;
 IF Fehler=3 Then Begin Writeln(' Problem! Path of '+DatName+'.afm not found...'); Halt End;
 Assign(p,Datname2+'.aft');
 Rewrite(p);
 Fehler:=IOResult;
 IF Fehler=2 Then Begin Writeln(' Problem! '+DatName+'.afm not found...'); Halt end;
 IF Fehler=3 Then Begin Writeln(' Problem! Path of '+DatName+'.afm not found...'); Halt End;
 {$i+}

 Write('Conversion in process ');
 flag:=false;

 i:=1;
 While (not (EOF(f) or flag)) and (i<3) Do Begin
  Readln(f,Zeile1);
  Write('.');
  If (Zeile1[1]='C') and (Zeile1[2]=' ') Then flag:=True
   Else Writeln(p,Zeile1);
  I:=i+1;
 End; {while}

 Writeln(p,'Comment Converted with afm2teX-A  to TeX  at ',Datum,' -- ',Zeit);

 While not (EOF(f) or flag) Do Begin
  Readln(f,Zeile1);
  Write('.');
  If (Zeile1[1]='C') and (Zeile1[2]=' ') Then flag:=True
   Else Writeln(p,Zeile1);
 End; {while}

{Zeichendefinition beginnt}
 i:=1;
 k:=1;
 While not EOF(f) DO Begin
  Dummy:=Zeile1;
  Analyse(Dummy);

 {Postscript- numbers original:}

  If (Dummy ='34') or (Dummy='128') or (Dummy='129') or (Dummy='130') or
     (Dummy='131') or (Dummy='133') or (Dummy='134') or (Dummy='137') or
     (Dummy='138') or (Dummy='141') or (Dummy='143') or
     (Dummy='161') or (Dummy='168') or (Dummy='173') or (Dummy='176') or
     (Dummy='180') or (Dummy='183') or (Dummy='191') or (Dummy='198') or
     (Dummy='215') or (Dummy='216') or (Dummy='223') or (Dummy='230') or
     (Dummy='247') or (Dummy='248')
    Then Begin
      PostscriptAlt[i]:=Zeile1;
      i:=i+1 ;
    End; {if}
  Readln(f,Zeile1);
 End; {while}
 Close(f);

 {umkopieren}


 For i:=1 to maxletters do
  PostscriptNeu[PS[i]]:=PostscriptAlt[i];

 {Charakternummern aendern}
 For i:=1 to maxletters do
  If PostscriptNeu[i]<>'' Then Analyse2(PostscriptNeu[i]);

  {und noch einmal lesen}
 Assign(f,DatName+'.afm');
 Reset(f);

 flag:=false;
 While not (EOF(f) or flag) Do Begin
  Readln(f,Zeile1);
  Write('.'); {screen}
  If (Zeile1[1]='C') and (Zeile1[2]=' ') Then flag:=True  {definition found}
 End; {while}

 {-----------------------------------------------------------------
  ------ start writing of characters ------------------------------
  ---  change here also, if you add characters --------------------}

{write beginning }  {i=myNo-postscript new defined}
 For i:=1 to 15 do  {to Oslash}
  If PostscriptNeu[i]<>'' Then Writeln(p,PostscriptNeu[i]);

 writeln(p,Zeile1); {write : 32 space}
 readln (f,Zeile1); {write : 33 exclam}
 writeln(p,Zeile1);
     
 readln (f,Zeile1); {no quotedbl}
 If PostscriptNeu[16]<>'' Then Writeln(p,PostscriptNeu[16]); { quotedblright}

 For k:=35 to 59  do begin   {k=Postscript-number original: C 35 numbersign ,...}
  readln (f,Zeile1);    {till semicolon}
  writeln(p,Zeile1);
 end;

 readln(f,Zeile1);  {60 ueberspringen : less}
 If PostscriptNeu[17]<>'' Then Writeln(p,PostscriptNeu[17]); {exclamdown}

  readln (f,Zeile1); {write : 61 equal}
  writeln(p,Zeile1);

 readln(f,Zeile1);  {62 ueberspringen : greater}
 If PostscriptNeu[18]<>'' Then Writeln(p,PostscriptNeu[18]); {questiondown}

 For k:=63 to 91  do begin {write}
  readln (f,Zeile1);
  writeln(p,Zeile1);
 end;

  readln(f,Zeile1);  {92 ueberspringen:  backslash }
  If PostscriptNeu[19]<>'' Then Writeln(p,PostscriptNeu[19]); {quotedblleft}

  readln (f,Zeile1); {93 schreiben: bracketright}
  writeln(p,Zeile1);

  readln(f,Zeile1);  {94 schreiben: asciicircum }
  writeln(p,Zeile1);

  readln(f,Zeile1);  {95 ueberspringen:  underscore }
  If PostscriptNeu[20]<>'' Then Writeln(p,PostscriptNeu[20]); {periodcentered}

  For k:=96 to 122  do begin
  readln (f,Zeile1);
  writeln(p,Zeile1);
 end;

 {enlarge maxletters here for more than 128 characters:}
  For i:=21 to maxletters  do   {Rest of converted postscript}
  If PostscriptNeu[i]<>'' Then Writeln(p,PostscriptNeu[i]);

 {den Rest: Kerning etc.}
  While not EOF(f) Do Begin
  Readln(f,Zeile1);
  Write('.');
  If (Zeile1[1]<>'C') and (Zeile1[2]<>' ') Then Writeln(p,Zeile1);
 End; {while}
  Writeln;
  Writeln('   Ready .');
  Writeln;
  Writeln('   Now convert ',Datname,'.aft with afm2tfm like');
  Writeln;
  Writeln('          afm2tfm ',Datname,'.aft');
  Writeln;
  Writeln('   to get the TeX-encoded tfm-file. Convert the Postscript-font');
  Writeln('   with ps2mf. Now you can use the font like the standard');
  Writeln('   computer-modern fonts (cm-encoding-scheme).');
  Writeln;
  Writeln('   Have fun!');
  Close(f);
  Close(p);

End.
