/*
 * Copyright 1991 Klaus Zitzmann, 1993-1996 Johannes Sixt
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose other than its commercial exploitation
 * is hereby granted without fee, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation. The authors
 * make no representations about the suitability of this software for
 * any purpose. It is provided "as is" without express or implied warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Klaus Zitzmann <zitzmann@infko.uni-koblenz.de>
 *          Johannes Sixt <Johannes.Sixt@telecom.at>
 */


#ifndef _IO_TRANS_H_
#define _IO_TRANS_H_

#define MOVE_BASE_STR_LEN	10

typedef enum {
	MoveBaseUp, MoveBaseDown, MoveBaseLeft, MoveBaseRight, MoveBaseCenter
} MoveBaseID;

typedef void (*OffsetFunc)(int x_off, int y_off);
typedef void (*ErrorCB)(char *text);

extern TeXPictObj *objList;		/* list of objects */
extern Boolean changeMade;		/* database changed since last save? */
extern Widget pboard;
extern char moveBaseStr[MOVE_BASE_STR_LEN + 1];

void InitDB(Widget parent, float initMoveBase, String initUnitLength);
int LoadFromFile(char *name, ErrorCB errorCB);
int SaveToFile(char *name, ErrorCB errorCB, char *savesuffix);
void SetCoordOrigin(void);
void GetCoords(int x, int y, float *xf, float *yf);
void GetOverallExtent(TeXObjExtent *overall);
void RescaleAll(float zoom);
void Erase(void);
void RegisterOffset(OffsetFunc func);
void MoveBase(Widget cmd, XtPointer typ, XtPointer call_data);

#endif /* _IO_TRANS_H_ */
