---
myst:
  html_meta:
    keywords: LaTeX
---
# Comment fonctionne le modèle de boîtes de TeX (donc de LaTeX) ?


Pour TeX, produire un document revient à produire des listes de boîtes (contenant éventuellement d'autres boîtes) et à les placer sur la page. C'est au moment de la visualisation que les caractères sont placés dans les boîtes et que le document ressemble à ce qui était souhaité.

```{image} /_static/images/textisboxes.png
:alt: /_static/images/textisboxes.png
:class: align-middle
```

:::{note}
Un caractère n'est pas toujours « complètement » contenu dans sa boîte.
:::

Contrairement à ce que suggère l'intuition, une boîte TeX ne possède pas deux, mais trois dimensions : une hauteur, une largeur, et une profondeur. La troisième dimension est liée à l'existence d'une ligne de base sans laquelle il serait difficile d'aligner les caractères. On pourrait spécifier les trois dimensions de façon équivalente sous la forme : largeur, hauteur totale et décalage vertical. C'est ce qui est fait pour certaines commandes comme `\rule` et la syntaxe LaTeX manque un peu d'homogénéité sur ce point.

```{image} /_static/images/boxdimen.png
:alt: /_static/images/boxdimen.png
:class: align-middle
```

Dans certaines circonstances (rotation de graphiques, `minipage`), on doit repérer un point verticalement et/ou horizontalement dans une boîte. Une convention courante est d'utiliser deux lettres, dont la première est `t` (haut), `b` (bas), `c` (centre) ou `B` (ligne de base) pour le positionnement vertical, et la deuxième est `l` (gauche), `r` (droite) ou `c` (centre) pour le positionnement horizontal.

```{image} /_static/images/boxplaces.png
:alt: /_static/images/boxplaces.png
:class: align-middle
```

:::{sources}
<https://www.elzevir.fr/imj/latex/tips.html#boxmodel>
:::
