---
myst:
  html_meta:
    keywords: LaTeX
---
# Comment créer des unités de mesure ?

- L'extension <ctanpkg:siunitx> permet de mettre en forme de manière cohérente et unifiée les unités de mesure, que ce soit en mode texte ou en mode mathématique. L'extension utilise la police mathématique droite courante (par défaut). La façon d'afficher les nombres et les unités est largement configurable.

:::{warning} Avec la version 3 de <ctanpkg:siunitx>, les commandes du document ont été révisées pour être plus descriptives. Ainsi, les commandes `\SI`, `\SIlist`, `\SIrange` et \SI restent disponibles mais il n'est pas recommandé de les utiliser dans les nouveaux documents. Utilisez plutôt les nouvelles commandes `\qty...` : elles sont plus claires et, dans certains cas, légèrement plus rapides. Il en est de même de la commande `\si` à plutôt remplacer par `\unit`.

L'approche de la saisie pour la version 3 est légèrement plus structurée et restreinte que pour la version 2. Outre les noms mis à jour pour les commandes de documents, cela signifie notamment que :
- les produits de nombres doivent maintenant être donnés en utilisant les commandes dédiées `\numproduct` et `\qtyproduct` (et non plus `\num`, `\SI` ou `\qty`) ;
- les valeurs complexes doivent être indiquées à l'aide de la commande dédiée `\complexnum` (et non plus `\num`).

Ces modifications ont été prises en compte ci-dessous.
:::

```
\documentclass{article}
\usepackage{siunitx}
\pagestyle{empty}
\begin{document}
\noindent\qty{12}{\kilogram}\\
\qty{12}{\kilogram}\\
\qty{5.8}{\meter\per\second}\\
\qty{1.23}{\joule\per\mole\per\kelvin}\\
\qty{15}{\electronvolt}\\
\qty{89}{\giga\pascal}\\
\qty{658.4}{\tera\hertz}\\
\qty{25}{\degreeCelsius}
\end{document}
```

Les nombres sont traités en tenant compte des exposants, des nombres complexes et des multiplications :

```
\documentclass{article}
\usepackage{siunitx}
\pagestyle{empty}
\begin{document}
\noindent\num{12345,67890}\\
\complexnum{1+-2i}\\
\num{.3e45}\\
\numproduct{1.654 x 2.34 x 3.430}
\end{document}
```

L'extension est capable de reconnaître les unités écrites sous forme de texte comme sous forme de macros (dans ce dernier cas, différents formats sont possibles) :

```
\documentclass{article}
\usepackage{siunitx}
\pagestyle{empty}
\begin{document}
\noindent\unit{kg.m.s^{-1}}\\
\unit{\kilogram\metre\per\second}\\
\unit[per-mode=symbol]{\kilogram\metre\per\second}\\
\unit[per-mode=symbol]{\kilogram\metre\per\ampere\per\second}\\
\qty[per-mode=fraction]{1.345}{\coulomb\per\mole}
\end{document}
```

L'extension peut aussi représenter des gammes de valeurs :

```
\documentclass{article}
\usepackage{siunitx}
\pagestyle{empty}
\begin{document}
\noindent\numlist{10;20;30}\\
\qtylist{0.13;0.67;0.80}{\milli\metre}\\
\numrange{10}{20}\\
\qtyrange{0.13}{0.67}{\milli\metre}\\
\end{document}
```

:::{warning}
Information obsolète. Ce qui suit est informatif.
:::

- Le problème du mode mathématique est qu'il change automatiquement de police et qu'il utilise une gestion particulière des espaces. Le mieux pour écrire des unités de mesures du type `m/s` sans avoir à taper systématiquement des barbarismes du type `\rm\,m/s\mit` ou `\,\textrm{m}/\textrm{s}` et de définir une commande spéciale dans le préambule du document.

Exemples avec <ctanpkg:amsmath> :

Unités avec <ctanpkg:amsmath>

```{noedit}
\newcommand{\units}[2]{#1\textrm{\thinspace #2}}
\units{10}{m/s}
```

Ou plus rapide :

Unités avec <ctanpkg:amsmath>

```{noedit}
\newcommand{\units}[2]{#1\textrm{\thinspace #2}}
\newcommand{\ms}[1]{\units{#1}{m/s}}
 \ms{10}
```
