/*
 * $Log:	jc.c,v $
 * Revision 1.1  89/02/07  23:56:19  onoe
 * Initial revision
 * 
 */

/*
 * Modified by (mleisher@nmsu.edu) Mark Leisher Mon Dec  3 22:08:13 1990
 * for GuoBiao, Shift-GuoBiao, and 8 bit GuoBiao
 * conversions.
 */

#include <stdio.h>
    
#define GB	0
#define SGB	1
#define GB8	2
    
#define GBIN	'A'
#define	GBOUT	'B'
#define ESC	'\033'
#define hanziIn() ((mode == GB) ? printf("\033$%c", hin) : 0)
#define hanziOut() ((mode == GB) ? printf("\033(%c", hout) : 0)

#define HT_HIN  0x01
#define HT_HOUT 0x02
#define HT_ESC  0x04
#define HT_GB   0x08
#define HT_SGB1 0x10
#define HT_SGB2 0x20
#define HT_GB81 0x40
#define HT_GB82 0x80

int htype[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*00*/
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*10*/
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, /*  !"#$%&' */
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, /* ()*+,-./ */
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, /* 01234567 */
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, /* 89:;<=>? */
    0x29, 0x2b, 0x2b, 0x28, 0x28, 0x28, 0x28, 0x28, /* @ABCDEFG */
    0x2a, 0x28, 0x2a, 0x28, 0x28, 0x28, 0x28, 0x28, /* HIJKLMNO */
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, /* PQRSTUVW */
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, /* XYZ[\]^_ */
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, /*  abcdefg */
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, /* hijklmno */
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, /* pqrstuvw */
    0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, /* xyz{|}~  */
    0x20, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, /*80*/
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, /*90*/
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, /*A0*/
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, /*B0*/
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, /*C0*/
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, /*D0*/
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, /*E0*/
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, /*F0*/
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xc0, 0xc0, 0x00,
};

int mode = GB;
char hin = GBIN;
char hout = GBOUT;


main(argc, argv)
   int argc;
   char *argv[];
{
    FILE *fp;
    char *buf, *getenv();
    char *program = argv[0];
    
    if (buf = getenv("HIN"))
	hin = *buf;
    if (buf = getenv("HOUT"))
	hout = *buf;
    
    while (*++argv) {
	if (**argv == '-') {
	    switch (*(*argv + 1)) {
              case 'g':
              case 'G':
		mode = GB;
		if (*(*argv + 2)) {
		    hin = *(*argv + 2);
		    if (*(*argv + 3))
                      hout = *(*argv + 3);
		}
		break;
              case 's':
              case 'S':
		mode = SGB;
		break;
              case 'u':
              case 'U':
		mode = GB8;
		break;
              default:
		fprintf(stderr, "%s: Unknown switch: %c.  Ignored.\n", program,
                        argv[0][1]);
		fprintf(stderr, "Usage: %s [-{g|s|u}] [file ...]\n", program);
		break;
	    }
	    argc--;
	} else {
	    if (fp = fopen(*argv, "r+b")) {
		hc(fp);
		fclose(fp);
	    } else
              perror(*argv);
	}
    }
    if (argc == 1)
	hc(stdin);
}

hc(fp)
   FILE *fp;
{
    char ch;
    int flag;
    register unsigned int ch1, ch2;
    int hanzi = 0, h_default = HT_GB81;
    
    flag = 0;
    
    while ((ch = getc(fp)) != EOF)
    {
	ch1 = (unsigned char) ch;
	if (ch == '\033')
	{
	    flag = HT_ESC;
	    continue;
	}
	if (flag & HT_ESC)
	{
	    if (ch == '$')
		flag = HT_HIN;
	    else if (ch == '(')
		flag = HT_HOUT;
	    else
	    {
		flag = 0;
		putchar('\033');
		putchar(ch);
	    }
	    continue;
	    
	}
	if (flag & HT_HIN)
	{
	    if (htype[ch1] & HT_HIN)
	    {
		hanzi = HT_HIN | HT_HOUT;
		hanziIn();
		flag = 0;
		continue;
	    }
	}
	else if (flag & HT_HOUT)
	{
	    if (htype[ch1] & HT_HOUT)
	    {
		hanzi = 0;
		hanziOut();
		flag = 0;
		continue;
	    }
	}
	if (flag & HT_SGB1)
	{
	    flag = 0;
	    if (htype[ch1] & HT_SGB2)
              {
                  ch2 = ((ch2 - 0x81) << 1) + 0x21;
                  if (ch1 >= 0x9f) {
                      ch2++;
                      ch1 -= 0x7e;
                  } else
                    ch1 -= 0x1f + ((ch1 > 0x7f) ? 1 : 0);

		if (!(hanzi & HT_HOUT))
		{
		    hanziIn();
		    hanzi |= HT_HOUT;
		}
		putHanzi(ch2, ch1);
		h_default = HT_SGB1;
		continue;
	    }
	}
	if (flag & HT_GB81)
	{
	    flag = 0;
	    if (htype[ch1] & HT_GB82)
	    {
		if (!(hanzi & HT_HOUT))
		{
		    hanziIn();
		    hanzi |= HT_HOUT;
		}
		putHanzi(ch2 & 0x7f, ch1 & 0x7f);
		h_default = HT_GB81;
		continue;
	    }
	}
	if (htype[ch1] & HT_GB)
	{
	    if (hanzi & HT_HIN)
	    {
		if (flag & HT_GB)
		{
		    putHanzi(ch2, ch1);
		    flag = 0;
		}
		else
		{
		    ch2 = ch1;
		    flag = HT_GB;
		}
	    }
	    else
	    {
		if (hanzi & HT_HOUT)
	        {
		    hanziOut();
		    hanzi &= ~ HT_HOUT;
		}
		putchar(ch);
	    }
	    continue;
	}
	if (htype[ch1] & HT_GB81)
	{
	    if (h_default == HT_GB81 || !(htype[ch1] & HT_SGB1))
	    {
		flag = HT_GB81;
		ch2 = ch1;
		continue;
	    }
	}
	if (htype[ch1] & HT_SGB1)
	{
	    flag = HT_SGB1;
	    ch2 = ch1;
	    continue;
	}
	if (ch == '\n' && mode == GB && hanzi & HT_HOUT)
	{
	    hanziOut();
	    putchar('\n');
	    hanziIn();
	}
	else
	{
	    if (hanzi)
	    {
		hanziOut();
		hanzi = 0;
	    }
	    putchar(ch);
	}
    }
    
    if (hanzi)
	hanziOut();
}

putHanzi(hi, lo)
   unsigned int hi, lo;
{
    switch (mode)
    {
    case GB8:
	putchar(hi | 0x80);
	putchar(lo | 0x80);
	break;
    case SGB:
	if (hi & 1) {
	    lo += 0x1f;
            if (lo >= 0x7f)
              lo++;
	} else
	    lo += 0x7e;
	hi = 0x81 + ((hi - 0x21) >> 1);
	/* DROP THROUGH */
    case GB:
	putchar(hi);
	putchar(lo);
	break;
    }
}
