{$A+,B-,D+,E-,F-,I+,L-,N-,O-,R+,S+,V+}
{$M 10000,0,655360}
PROGRAM REFLIST;


USES UTILS,TIJD;


CONST
  Filenaamset = ['!'..'-','/'..#96,'{'..'~'];   {96='}
  Formatset = ['!'..'-','/'..#96,'{'..'~'];

VAR
  OrgExitProc     : pointer;          {voor wijzen naar exit proc.}
  Klaar           : boolean;
  fout            : boolean;
  InDirectory     : Str64;
  UitDirectory    : Str64;
  Format          : Str64;
  invoer          : array[1..9] of text;
  invoerfilenaam  : array[1..9] of Str64;
  uitvoer         : text;
  uitvoerfilenaam : Str64;
  kladfile        : text;
  kladfilenaam    : Str64;
  i,j             : longint;
  AantalInvoer    : longint;


{$F+} PROCEDURE TERMINATIONPROC; {$F-}
{Dit is de exit procedure, wordt altijd uitgevoerd}
BEGIN
  Exitproc:=OrgExitProc;
  WriteToWindow(nil);
  ClrScr;
  FlushKeyBoardBuffer;
END;


PROCEDURE CLS;
BEGIN
  CheckCtrlC;
  GotoLC(3,5); ClrToL(25);
  GotoLC(4,5);
END;


PROCEDURE VRAAGINIT;
BEGIN
  GotoC(43); Write(':'); GotoC(45);
END;


PROCEDURE INITIALISATIE;
BEGIN
  SetLeftMargin(10); GotoLC(2,10);
  Writeln(CenterStr('REFLIST (C) August 1992, 4TeX UserGroup',55));
  Color:=CheckColor(10); SetLeftMargin(5);
  Cls;
  Writeln('This program generates a .tex file, with entries the total of');
  Writeln('references in the .bib files, which are to be specified.');
  Writeln('Answer the following questions:');

{INVOERFILES}
  AantalInvoer:=1;
  GotoLC(8,5); Write('Number of inputfiles');
  Vraaginit;
  AantalInvoer:=InInt(1,9,AantalInvoer,1);
  For i:=2 to AantalInvoer do invoerfilenaam[i]:='';
  Klaar:=false;
  While not klaar do
  BEGIN
    CheckCtrlC;
    GotoLC(9,5);
    Write('Directory of inputfile(s) (end with \)');
    Vraaginit;
    GetStr(InDirectory,FileSpecCharSet,30); Writeln;
    For i:=1 to AantalInvoer do
    BEGIN
      Write('Name inputfile ',i:1,' (.bib)');
      Vraaginit;
      GetStr(Invoerfilenaam[i],Filenaamset,8); Writeln;
    END;
    Getnow;

{CONTROLE INVOERFILE}
    fout:=false;
    If copy(InDirectory,length(InDirectory),length(InDirectory))<>'\'
    then BEGIN
           ERROR('The directory has to be ended with a \',
                 'Press a key and correct.','');
           fout:=true;
         END;
    For i:=1 to AantalInvoer do If not fout then
    If Strip(invoerfilenaam[i])=''
    then BEGIN
           ERROR('No inputfilename:',
                 IntToStr(i,1),
                 'Press a key and correct.');
           fout:=true;
         END
    else If not EXISTFILE(InDirectory+InvoerFilenaam[i]+'.bib')
         then BEGIN
                ERROR('A specified file does not exist:',
                      IntToStr(i,1),
                      'Press a key and correct.');
                fout:=true;
              END;
    If not fout then klaar:=true;
  END;
  For i:=1 to AantalInvoer do
  Assign(invoer[i],InDirectory+invoerFilenaam[i]+'.bib');

{UITVOERFILE}
  klaar:=false;
  While not klaar do
  BEGIN
    CheckCtrlC;
    fout:=false;
    GotoLC(10+AantalInvoer,5);
    Write('Directory outputfile (end with \)');
    Vraaginit;
    GetStr(UitDirectory,FileSpecCharSet,30); Writeln;
    Write('Name of outputfile (.tex)');
    Vraaginit;
    GetStr(Uitvoerfilenaam,filenaamset,8);
    Getnow;

{CONTROLE UITVOERFILE}
    If copy(UitDirectory,length(UitDirectory),length(UitDirectory))<>'\'
    then BEGIN
           ERROR('The directory has to be ended with a \',
                 'Press a key and correct.','');
           fout:=true;
         END;
    If not fout then If Strip(UitvoerFileNaam)=''
    then BEGIN
           ERROR('No outputfilename.',
                 'Press a key and correct.','');
           fout:=true;
         END;
    If not fout then If EXISTFILE(UitDirectory+uitvoerFileNaam+'.tex')
    then BEGIN
           Write('The specified file already exists. Overwrite? (y/n) ');
           If InChoice('yes|no',1)=2 then fout:=true;
           GotoLC(ThisL-1,5); ClrEol;
         END;
    If not fout then klaar:=true;
  END;
  Assign(uitvoer,UitDirectory+uitvoerFilenaam+'.tex');

{FORMAAT}
  GotoLC(12+Aantalinvoer,5);
  klaar:=false;
  While not klaar do
  BEGIN
    Write('Style file for format (.bst)');
    Vraaginit;
    Format:=InStr(Formatset,Format,8);
    If Strip(Format)='' then ERROR('No format.','Press a key and correct.','')
                        else klaar:=true;
  END;
END;


PROCEDURE INLEZEN_EN_WEGSCHRIJVEN;
VAR
  dubbel     : String[160];
  regel      : Str80;
  code       : str80;
  teller,
  tellerleeg,
  tellervol  : longint;
BEGIN
{INLEZEN EN WEGSCHRIJVEN NAAR UITVOER}
  Cls; GotoLC(4,5); Writeln('Working...');
  tellervol:=0; tellerleeg:=0;
  Rewrite(uitvoer);
  Writeln(uitvoer,'\documentstyle[a4wide]{article}');
  Writeln(uitvoer,'\begin{document}');
  Writeln(uitvoer,'\noindent \today');
  For i:=1 to AantalInvoer do
  BEGIN
    Reset(invoer[i]);
    While not EOF(invoer[i]) do
    BEGIN
      dubbel:=''; regel:='';
      Readln(invoer[i],regel);
      If pos('@',regel)>0
      then if ((pos('@STRING',regel)=0) and (pos('@string',regel)=0))
      then
      BEGIN
	dubbel:=regel;
	Readln(invoer[i],regel);
	dubbel:=dubbel+regel;
	code:='';
	code:=copy(dubbel,pos('{',dubbel)+1,pos(',',dubbel)-pos('{',dubbel)-1);
	If Strip(code)<>''
        then BEGIN
               Writeln(uitvoer,'\nocite{',code,'}');
               tellervol:=tellervol+1;
               GotoLC(4,20); Write(tellervol:1);
             END
        else tellerleeg:=tellerleeg+1;
      END;
    END;
    close(invoer[i]);
  END;
  writeln(uitvoer,'\bibliographystyle{',Format,'}');
  write(uitvoer,'\bibliography{');
  for i:=1 to AantalInvoer do
    begin
    write(uitvoer,InvoerFileNaam[i]);
    if i < AantalInvoer then
      write(uitvoer,',')
    end;
  writeln(uitvoer,'}');
  writeln(uitvoer,'\end{document}');
  close(uitvoer);
  if ParamStr(5)='' then
  begin
    writeln;
    write('Press a key ... ');
    WaitForKeyPressed;FlushKeyboardBuffer;
  end;
END;



{HOOFDPROGRAMMA}
BEGIN
  SetLeftMargin(5);
  if (ParamCount = 0) or (pos('?',Paramstr(1))>0)
  then BEGIN
         ClrScr;
         Writeln('REFLIST generates a .tex file with entries all references');
         Writeln('in the specified .bib files.');
         Writeln;
         Writeln('syntax:');
         Writeln('reflist a b c d e');
         Writeln('where a = input directory (end with \)');
         Writeln('      b = first input filename (without .bib)');
         Writeln('      c = output directory (end with \)');
         Writeln('      d = output filenaam (without .tex)');
         Writeln('      e = format (without .bst)');
         Writeln;
         Writeln('for instance:');
         Writeln('reflist g:\tex\bib\ articles g:\tex\texfiles\ article plainref');
       END
  else BEGIN
         OrgExitProc:=Exitproc;
         Exitproc:=@TERMINATIONPROC;
         QuickOpenWindow('Interrupt: Ctrl-C',1,1,25,80,DataColor);

         InDirectory:=ParamStr(1);
         InvoerFileNaam[1]:=ParamStr(2);
         UitDirectory:=ParamStr(3);
         UitvoerFileNaam:=ParamStr(4);
         Format:=ParamStr(5);

         if ParamStr(6)='no' then INITIALISATIE
         else
         begin
           Assign(uitvoer,UitDirectory+uitvoerFilenaam+'.tex');
           Assign(invoer[1],InDirectory+invoerFilenaam[1]+'.bib');
           AantalInvoer:=1;
           reset(invoer[1]);
         end;
         INLEZEN_EN_WEGSCHRIJVEN;
       END;
END.
