/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.internal.JSystem;
import org.luaj.vm2.internal.LuaDate;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 .2\u00020\u0001:\u0002./B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0004J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0012\u0010 \u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\u000fH\u0014J\u001c\u0010\"\u001a\u00020\u00192\b\u0010#\u001a\u0004\u0018\u00010\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000fH\u0014J\u001c\u0010%\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u000fH\u0004J\u0012\u0010\u0011\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010)H\u0004J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010+\u001a\u00020\u000fH\u0014J\u0018\u0010,\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u001bH\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/luaj/vm2/lib/OsLib;", "Lorg/luaj/vm2/lib/TwoArgFunction;", "()V", "globals", "Lorg/luaj/vm2/Globals;", "beginningOfYear", "Lorg/luaj/vm2/internal/LuaDate;", "d", "call", "Lorg/luaj/vm2/LuaValue;", "modname", "env", "clock", "", "date", "", "format", "time", "difftime", "t2", "t1", "execute", "Lorg/luaj/vm2/Varargs;", "command", "exit", "", "code", "", "getenv", "varname", "isDaylightSavingsTime", "", "remove", "filename", "rename", "oldname", "newname", "setlocale", "locale", "category", "table", "Lorg/luaj/vm2/LuaTable;", "timeZoneOffset", "tmpname", "weekNumber", "startDay", "Companion", "OsLibFunc", "luak"})
public class OsLib
extends TwoArgFunction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @Nullable
    protected Globals globals;
    @JvmField
    @NotNull
    public static String TMP_PREFIX = ".luaj";
    @JvmField
    @NotNull
    public static String TMP_SUFFIX = "tmp";
    private static final int CLOCK = 0;
    private static final int DATE = 1;
    private static final int DIFFTIME = 2;
    private static final int EXECUTE = 3;
    private static final int EXIT = 4;
    private static final int GETENV = 5;
    private static final int REMOVE = 6;
    private static final int RENAME = 7;
    private static final int SETLOCALE = 8;
    private static final int TIME = 9;
    private static final int TMPNAME = 10;
    @NotNull
    private static final String[] NAMES;
    private static long tmpnames;
    @NotNull
    private static final String[] WeekdayNameAbbrev;
    @NotNull
    private static final String[] WeekdayName;
    @NotNull
    private static final String[] MonthNameAbbrev;
    @NotNull
    private static final String[] MonthName;

    @Override
    @NotNull
    public LuaValue call(@NotNull LuaValue modname, @NotNull LuaValue env) {
        this.globals = env.checkglobals();
        LuaTable os = new LuaTable();
        int n = NAMES.length;
        for (int i = 0; i < n; ++i) {
            os.set(NAMES[i], (LuaValue)new OsLibFunc(i, NAMES[i]));
        }
        env.set("os", (LuaValue)os);
        env.get("package").get("loaded").set("os", (LuaValue)os);
        return os;
    }

    protected final double clock() {
        return Duration.getInSeconds-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()));
    }

    protected final double difftime(double t2, double t1) {
        return t2 - t1;
    }

    @NotNull
    public final String date(@NotNull String format2, double time) {
        String format3 = format2;
        double time2 = time;
        LuaDate d = new LuaDate((long)(time2 * (double)1000));
        if (StringsKt.startsWith$default(format3, "!", false, 2, null)) {
            time2 -= (double)this.timeZoneOffset(d);
            d = new LuaDate((long)(time2 * (double)1000));
            String string = format3.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            format3 = string;
        }
        char[] cArray = format3.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
        char[] fmt = cArray;
        int n = fmt.length;
        Buffer result2 = new Buffer(n);
        char c = '\u0000';
        int i = 0;
        while (i < n) {
            OsLib $this$date_u24lambda_u240 = this;
            boolean bl = false;
            int n2 = i;
            i = n2 + 1;
            c = fmt[n2];
            char c2 = c;
            if (c2 == '\n') {
                result2.append("\n");
                continue;
            }
            if (c2 == '%') {
                if (i >= n) break;
                OsLib $this$date_u24lambda_u241 = this;
                boolean bl2 = false;
                int n3 = i;
                i = n3 + 1;
                c = fmt[n3];
                char c3 = c;
                if (c3 == '%') {
                    result2.append((byte)37);
                    continue;
                }
                if (c3 == 'a') {
                    result2.append(WeekdayNameAbbrev[d.getWday() - 1]);
                    continue;
                }
                if (c3 == 'A') {
                    result2.append(WeekdayName[d.getWday() - 1]);
                    continue;
                }
                if (c3 == 'b') {
                    result2.append(MonthNameAbbrev[d.getMonth()]);
                    continue;
                }
                if (c3 == 'B') {
                    result2.append(MonthName[d.getMonth()]);
                    continue;
                }
                if (c3 == 'c') {
                    result2.append(this.date("%a %b %d %H:%M:%S %Y", time2));
                    continue;
                }
                if (c3 == 'd') {
                    String string = String.valueOf(100 + d.getDay()).substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    result2.append(string);
                    continue;
                }
                if (c3 == 'H') {
                    String string = String.valueOf(100 + d.getHour()).substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    result2.append(string);
                    continue;
                }
                if (c3 == 'I') {
                    String string = String.valueOf(100 + d.getHour() % 12).substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    result2.append(string);
                    continue;
                }
                if (c3 == 'j') {
                    LuaDate y0 = this.beginningOfYear(d);
                    int dayOfYear = (int)((d.getTime() - y0.getTime()) / 86400000L);
                    String string = String.valueOf(1001 + dayOfYear).substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    result2.append(string);
                    continue;
                }
                if (c3 == 'm') {
                    String string = String.valueOf(101 + d.getMonth()).substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    result2.append(string);
                    continue;
                }
                if (c3 == 'M') {
                    String string = String.valueOf(100 + d.getMinute()).substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    result2.append(string);
                    continue;
                }
                if (c3 == 'p') {
                    result2.append(d.getHour() < 12 ? "AM" : "PM");
                    continue;
                }
                if (c3 == 'S') {
                    String string = String.valueOf(100 + d.getSecond()).substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    result2.append(string);
                    continue;
                }
                if (c3 == 'U') {
                    result2.append(String.valueOf(this.weekNumber(d, 0)));
                    continue;
                }
                if (c3 == 'w') {
                    result2.append(String.valueOf((d.getWday() + 6) % 7));
                    continue;
                }
                if (c3 == 'W') {
                    result2.append(String.valueOf(this.weekNumber(d, 1)));
                    continue;
                }
                if (c3 == 'x') {
                    result2.append(this.date("%m/%d/%y", time2));
                    continue;
                }
                if (c3 == 'X') {
                    result2.append(this.date("%H:%M:%S", time2));
                    continue;
                }
                if (c3 == 'y') {
                    String string = String.valueOf(d.getYear()).substring(2);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    result2.append(string);
                    continue;
                }
                if (c3 == 'Y') {
                    result2.append(String.valueOf(d.getYear()));
                    continue;
                }
                if (c3 == 'z') {
                    String m;
                    String h;
                    int tzo = this.timeZoneOffset(d) / 60;
                    int a = Math.abs(tzo);
                    Intrinsics.checkNotNullExpressionValue(String.valueOf(100 + a / 60).substring(1), "this as java.lang.String).substring(startIndex)");
                    Intrinsics.checkNotNullExpressionValue(String.valueOf(100 + a % 60).substring(1), "this as java.lang.String).substring(startIndex)");
                    result2.append((tzo >= 0 ? "+" : "-") + h + m);
                    continue;
                }
                LuaValue.Companion.argerror(1, "invalid conversion specifier '%" + c + '\'');
                throw new KotlinNothingValueException();
            }
            result2.append((byte)c);
        }
        return result2.tojstring();
    }

    private final LuaDate beginningOfYear(LuaDate d) {
        return new LuaDate(d.getYear(), 0, 1, 0, 0, 0, 0);
    }

    private final int weekNumber(LuaDate d, int startDay) {
        throw new NotImplementedError(null, 1, null);
    }

    private final int timeZoneOffset(LuaDate d) {
        return 0;
    }

    private final boolean isDaylightSavingsTime(LuaDate d) {
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    protected Varargs execute(@Nullable String command2) {
        return LuaValue.Companion.varargsOf(LuaValue.Companion.getNIL(), LuaValue.Companion.valueOf("exit"), LuaValue.Companion.getONE());
    }

    protected final void exit(int code) {
        JSystem.INSTANCE.exit(code);
    }

    @Nullable
    protected String getenv(@Nullable String varname) {
        String string = varname;
        Intrinsics.checkNotNull(string);
        return JSystem.getProperty$default(JSystem.INSTANCE, string, null, 2, null);
    }

    protected void remove(@Nullable String filename) {
        throw new IOException("not implemented");
    }

    protected void rename(@Nullable String oldname, @Nullable String newname) {
        throw new IOException("not implemented");
    }

    @NotNull
    protected final String setlocale(@Nullable String locale, @Nullable String category) {
        return "C";
    }

    protected final double time(@Nullable LuaTable table) {
        LuaDate d = table == null ? new LuaDate() : new LuaDate(table.get("year").checkint(), table.get("month").checkint() - 1, table.get("day").checkint(), table.get("hour").optint(12), table.get("min").optint(0), table.get("sec").optint(0), 0);
        return (double)d.getTime() / 1000.0;
    }

    @NotNull
    protected synchronized String tmpname() {
        long l = tmpnames;
        tmpnames = l + 1L;
        return TMP_PREFIX + l + TMP_SUFFIX;
    }

    static {
        String[] stringArray = new String[]{"clock", "date", "difftime", "execute", "exit", "getenv", "remove", "rename", "setlocale", "time", "tmpname"};
        NAMES = stringArray;
        stringArray = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        WeekdayNameAbbrev = stringArray;
        stringArray = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        WeekdayName = stringArray;
        stringArray = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        MonthNameAbbrev = stringArray;
        stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        MonthName = stringArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0096\u0002\u00a8\u0006\n"}, d2={"Lorg/luaj/vm2/lib/OsLib$OsLibFunc;", "Lorg/luaj/vm2/lib/VarArgFunction;", "opcode", "", "name", "", "(Lorg/luaj/vm2/lib/OsLib;ILjava/lang/String;)V", "invoke", "Lorg/luaj/vm2/Varargs;", "args", "luak"})
    public final class OsLibFunc
    extends VarArgFunction {
        public OsLibFunc(@NotNull int opcode, String name) {
            this.opcode = opcode;
            this.name = name;
        }

        @Override
        @NotNull
        public Varargs invoke(@NotNull Varargs args) {
            try {
                switch (this.opcode) {
                    case 0: {
                        return LuaValue.Companion.valueOf(OsLib.this.clock());
                    }
                    case 1: {
                        double t;
                        String s = args.optjstring(1, "%c");
                        double d = t = args.isnumber(2) ? args.todouble(2) : OsLib.this.time(null);
                        if (Intrinsics.areEqual(s, "*t")) {
                            LuaDate d2 = new LuaDate((long)(t * (double)1000));
                            LuaTable tbl = LuaValue.Companion.tableOf();
                            tbl.set("year", d2.getYear());
                            tbl.set("month", d2.getMonth1());
                            tbl.set("day", d2.getDay());
                            tbl.set("hour", d2.getHour());
                            tbl.set("min", d2.getMinute());
                            tbl.set("sec", d2.getSecond());
                            tbl.set("wday", d2.getWday());
                            tbl.set("yday", d2.getYday());
                            tbl.set("isdst", (LuaValue)LuaValue.Companion.valueOf(OsLib.this.isDaylightSavingsTime(d2)));
                            return tbl;
                        }
                        String string = s;
                        Intrinsics.checkNotNull(string);
                        return LuaValue.Companion.valueOf(OsLib.this.date(string, t == -1.0 ? OsLib.this.time(null) : t));
                    }
                    case 2: {
                        return LuaValue.Companion.valueOf(OsLib.this.difftime(args.checkdouble(1), args.checkdouble(2)));
                    }
                    case 3: {
                        OsLib osLib = OsLib.this;
                        Varargs varargs = args;
                        boolean bl = true;
                        Intrinsics.checkNotNull(null);
                        throw new KotlinNothingValueException();
                    }
                    case 4: {
                        OsLib.this.exit(args.optint(1, 0));
                        return LuaValue.Companion.getNONE();
                    }
                    case 5: {
                        String val;
                        String string = val = OsLib.this.getenv(args.checkjstring(1));
                        return string != null ? (Varargs)LuaValue.Companion.valueOf(string) : (Varargs)LuaValue.Companion.getNIL();
                    }
                    case 6: {
                        OsLib.this.remove(args.checkjstring(1));
                        return LuaValue.Companion.getBTRUE();
                    }
                    case 7: {
                        OsLib.this.rename(args.checkjstring(1), args.checkjstring(2));
                        return LuaValue.Companion.getBTRUE();
                    }
                    case 8: {
                        OsLib osLib = OsLib.this;
                        Varargs varargs = args;
                        boolean bl = true;
                        Intrinsics.checkNotNull(null);
                        throw new KotlinNothingValueException();
                    }
                    case 9: {
                        LuaValue.Companion companion = LuaValue.Companion;
                        OsLib osLib = OsLib.this;
                        Varargs varargs = args;
                        boolean bl = true;
                        Intrinsics.checkNotNull(null);
                        throw new KotlinNothingValueException();
                    }
                    case 10: {
                        return LuaValue.Companion.valueOf(OsLib.this.tmpname());
                    }
                }
                return LuaValue.Companion.getNONE();
            }
            catch (IOException e) {
                LuaValue luaValue = LuaValue.Companion.getNIL();
                String string = e.getMessage();
                Intrinsics.checkNotNull(string);
                return LuaValue.Companion.varargsOf(luaValue, (Varargs)LuaValue.Companion.valueOf(string));
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/luaj/vm2/lib/OsLib$Companion;", "", "()V", "CLOCK", "", "DATE", "DIFFTIME", "EXECUTE", "EXIT", "GETENV", "MonthName", "", "", "[Ljava/lang/String;", "MonthNameAbbrev", "NAMES", "REMOVE", "RENAME", "SETLOCALE", "TIME", "TMPNAME", "TMP_PREFIX", "TMP_SUFFIX", "WeekdayName", "WeekdayNameAbbrev", "tmpnames", "", "luak"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

