#
# bicyclib.pm
# library module for bicyclic compounds
#
print "module bicyclib version 1.0 1999-04-12\n";

# Norbornan
# parameter: "bc221h", , , startpos, bliste, radius
sub bc221h_default_
{
    my ($iAnz, $p1, $p2, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 7;
    $$iStart = $$p1 = $$p2 = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (9, 9, 9, 0, 0, 0, 9, 0);
}

sub bc221h_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $p1, $p2, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    my ($dx, $dy) = (cos(30*$pi/180)*$$rRadius, sin(30*$pi/180)*$$rRadius);
    my ($sx, $sy) = (0.6*$$rRadius, 0.7*$$rRadius);
    my $l1 = sqrt($sx*$sx+$sy*$sy);
    @$XYa = (loc->new(0,0), loc->new($dx,$dy), loc->new(2*$dx,0), 
	     loc->new($sx+2*$dx,$sy), loc->new($sx+$dx,$sy+$dy), loc->new($sx,$sy),
	     loc->new($dx*1.5,$sy*3));
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$rThetaa = (30, -30, getangle($$XYa[2], $$XYa[3]), 150, -150,
		getangle($$XYa[5], $$XYa[0]),  
		getangle($$XYa[1], $$XYa[6]), getangle($$XYa[4], $$XYa[6]));
    @$rLena = ($$rRadius, $$rRadius, $l1, $$rRadius, $$rRadius, $l1,
		getlength($$XYa[1], $$XYa[6]), getlength($$XYa[4], $$XYa[6]));
    @$BLa = (0, 1, 2, 3, 4, 5, 1, 4);   # start atom
    @$r = (-140, -120, -80, 10, 30, 150, 90);
    @$t = (150, 30, 30, 30, 150, 150, 150);
    @$b = (-90, 150, -90, -90, 30, -90, 30);
}


# Norpinan-Geruest
# parameter: "bc311h", , , startpos, bliste, radius
sub bc311h_default_
{
    my ($iAnz, $p1, $p2, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 7;
    $$iStart = $$p1 = $$p2 = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (0, 0, 0, 9, 9, 9, 9, 0);
}

sub bc311h_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $p1, $p2, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    my ($dx, $dy) = (cos(30*$pi/180)*$$rRadius, sin(30*$pi/180)*$$rRadius);
    my ($sx, $sy) = ($$rRadius, sin(30*$pi/180)*(2*$$rRadius));
    my $l1 = sqrt($sx*$sx+$sy*$sy);
    @$XYa = (loc->new(0,0), loc->new($dx,-$dy), loc->new(2*$dx,0), 
	    loc->new($sx+2*$dx,-$sy), loc->new($sx+$dx,$dy-$sy), loc->new($sx,-$sy),
	    0);
    $$XYa[6] = getpos($$XYa[5], -120,$$rRadius);
    @$rThetaa = (-30, +30, getangle($$XYa[2], $$XYa[3]), 
	    150, -150, getangle($$XYa[5], $$XYa[0]),
	    -120,  getangle($$XYa[1], $$XYa[6]));
    @$rLena = ($$rRadius, $$rRadius, $l1, $$rRadius, $$rRadius, $l1,
	    $$rRadius, getlength($$XYa[1], $$XYa[6]));
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$BLa = (0, 1, 2, 3, 4, 5, 5, 1);   # start atom
    @$r = (142, -60, 82, -37, 90, -60, -120);
    @$t = (90, -30, 90, 30, 90, 10, 180);
    @$b = (-150, -150, -20, -90, -120, -90, -60);
}

# Bizyklo[2.2.2]oktan
# parameter: "bc222o", , , startpos, bliste, radius
sub bc222o_default_
{
    my ($iAnz, $p1, $p2, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 8;
    $$iStart = $$p1 = $$p2 = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (0, 0, 9, 9, 9, 0, 9, 9, 0);
}

sub bc222o_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $p1, $p2, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    my ($dx, $dy) = (cos(30*$pi/180)*$$rRadius, sin(30*$pi/180)*$$rRadius);
    my ($sx, $sy) = (0.6*$$rRadius, 0.7*$$rRadius);
    my $l1 = sqrt($sx*$sx+$sy*$sy);
    @$XYa = (loc->new(0,0), loc->new($dx,$dy), loc->new(2*$dx,0), 
	     loc->new(2*$dx-$sx,-$sy), loc->new($dx-$sx,$dy-$sy), loc->new(-$sx,-$sy),
	     0,0);
    $$XYa[6] = getpos($$XYa[4], 90, $$rRadius);
    $$XYa[7] = getpos($$XYa[1], 90, $$rRadius);
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$rThetaa = (30, -30, getangle($$XYa[2], $$XYa[3]), 150, -150,
		getangle($$XYa[5], $$XYa[0]),  
		90, getangle($$XYa[6], $$XYa[7]), 90);
    @$rLena = ($$rRadius, $$rRadius, $l1, $$rRadius, $$rRadius, $l1,
		$$rRadius, $l1, $$rRadius);
    @$BLa = (0, 1, 2, 3, 4, 5, 4, 6, 1);   # start atom
    @$r = (135, 45, 30, -80, -120, -138, 140, 70);
    @$t = (150, 30, 30, 30, 150, 150, 150, 150);
    @$b = (-90, 150, -90, -90, -90, -90, 20, 30);
}


# Tropin-Geruest
# parameter: "bc321o", , , startpos, bliste, radius
sub bc321o_default_
{
    my ($iAnz, $p1, $p2, $iStart, $BT, $bAromat, $rRadius) = @_;
    $$iAnz = 8;
    $$iStart = $$p1 = $$p2 = 0;
    $$rRadius = $rLenN;
    $$bAromat = $false;
    @$BT = (0, 0, 0, 9, 9, 9, 9, 0, 0);
}

sub bc321o_
{
    my ($XYstart, $rRadius, $rRadius_bak, $iAnz, $p1, $p2, $iStart, 
			$M, $rLena, $rThetaa, $XYa, $BLa, $t, $b, $r) = @_;

    $$rRadius_bak = $$rRadius = abs($$rRadius);
    my ($dx, $dy) = (cos(30*$pi/180)*$$rRadius, sin(30*$pi/180)*$$rRadius);
    my ($sx, $sy) = ($$rRadius, sin(30*$pi/180)*(2*$$rRadius));
    my $l1 = sqrt($sx*$sx+$sy*$sy);
    @$XYa = (loc->new(0,0), loc->new($dx,-$dy), loc->new(2*$dx,0), 
	    loc->new($sx+2*$dx,-$sy), loc->new($sx+$dx,$dy-$sy), 
	    loc->new($sx,-$sy), 0, 0);
    $$XYa[6] = getpos($$XYa[5],-100,$$rRadius);
    $$XYa[7] = getpos($$XYa[1],-100,$$rRadius);
    @$rThetaa = (-30, +30, getangle($$XYa[2], $$XYa[3]), 
	    150, -150, getangle($$XYa[5], $$XYa[0]),
	    -100, getangle($$XYa[6], $$XYa[7]), -100);
    @$rLena = ($$rRadius, $$rRadius, $l1, $$rRadius, $$rRadius, $l1,
	    $$rRadius, getlength($$XYa[6], $$XYa[7]), $$rRadius);
    my $XYshift = loc->new($$XYa[$iStart]);
    grep(($_->translate(- $XYshift->{"x"},
			- $XYshift->{"y"}) && 0), @$XYa);
    grep(($_->translate($XYstart) && 0), @$XYa);
    $M->eq(0,0);
    $M->translate($XYstart);
    @$BLa = (0, 1, 2, 3, 4, 5, 5, 6, 1);   # start atom
    @$r = (143, 100, 82, -37, 90, -60, -100, -120);
    @$t = (90, -30, 90, 30, 90, -150, -30, -20);
    @$b = (-150, -150, -20, -90, -60, -45, -150, -160);
}
