/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "refs.h"
#include "re_brow.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "ix04_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "initial.h"
#include "interf.h"
#include "rfnr_fun.h"

#define RECORD_ZAHLSTRING_LEN 8
#define RECORD_ZAHL_MAX_VORGABE 99999999L
#define BROWSE_BBT_NAME "br.bb_"


 extern char rdbpfad[PFAD_LEN+1];


 static char * au_zeile;
 static char * ed_zeile;
 static char * showrec;
 static char * ex_au_zeile;
 static char * desc_zeile;

 extern FILE * fpjournal;
 extern FILE * fpdesc;
 extern FILE * fpbuch;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;

 extern FILE * ix01file;
 extern FILE * ix04file;

 extern char journal_pix_name[PFAD_LEN+1];
 extern char journal_name[PFAD_LEN+1];
 extern char desc_name[PFAD_LEN+1];
 extern char book_name[PFAD_LEN+1];
 extern char autorjl_name[PFAD_LEN+1];
 extern char autorbu_name[PFAD_LEN+1];
 extern char quell_pix_name[PFAD_LEN+1];
 extern char quell_name[PFAD_LEN+1];
 extern char stichw_name[PFAD_LEN+1];
 extern char stichw_pix_name[PFAD_LEN+1];
 extern char abstr_pix_name[PFAD_LEN+1];
 extern char abstr_dat_name[PFAD_LEN+1];

 extern char abst_text_temp[PFAD_LEN+1];

 extern journal_rec one_journal_rec;
 extern desc_rec one_desc_rec;
 extern buch_rec one_buch_rec;
 extern quell_rec one_quell_rec;
 extern refspix_rec ix01rec;
 extern quellpix_rec ix02rec;
 extern keylistpix_rec ix03rec;
 extern keylist_rec one_stichw_rec;
 extern abstr_rec one_abstr_rec;
 extern abstrpix_rec ix04rec;
 extern author_rec one_aued_rec;

 extern config_set one_config_set;
 extern char wrtxtbu[WRTXTBU_LEN+1];
 extern char kennziffer_global[KENNZIFFER_LEN+1];

 static void desc_blaettern(
                            char * desc_zeile,
                            FILE * datfl,
                            long desc_rptr
                          );
 static void auedstring_blaettern(
                            char * au_zeile,
                            FILE * datfl,
                            long aued_rptr
                          );
 static int show_textfile(char * t_name);
 static int daten_datei_lesen(char * kennziffer);
 static void save_bbt(const char * schluessel, char * browse_bbt_name);


int re_brow_main(char * bbt_file,char * code)
{
   kennziffer_lesen_allein(kennziffer_global);
   /// if (strlen(kennziffer_global)>0)
   /// {
   ///    sprintf(wrtxtbu,"\n(Current reference number is `%s')\n",
   ///      kennziffer_global);
   ///    wrtxt(wrtxtbu);
   /// }
   if (strcmp(code,"-c")==0)
   {
     re_brow_allocate_memory();
     logdatei_oeffnen();
     logdatei_schreiben("Browsing complete database:");
     logdatei_schreiben("--");
     browse_menu(); 
     logdatei_schreiben("End browsing database");
     logdatei_schliessen(); 
     re_brow_free_memory();
   }
   else if (strcmp(code,"-b")==0)
   {
     // wrtxt(bbt_file);
     re_brow_allocate_memory();
     logdatei_oeffnen();
     logdatei_schreiben("Browsing database by bbt-file:");
     logdatei_schreiben(bbt_file);
     logdatei_schreiben("--");
     browse_bbt(bbt_file); 
     logdatei_schreiben("End browsing database");
     logdatei_schliessen(); 
     re_brow_free_memory();
   }
   // ... 
   else 
   {
     kennziffer_schreiben(kennziffer_global);
     return 0;
   }
   kennziffer_schreiben(kennziffer_global);
   return 1;
}

int re_brow_allocate_memory(void)
{
   if ((au_zeile =  (char *) malloc(AUTORZEILE_LEN * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nProblem in re_brow_allocate_memory()\n");
      exit(1);
   }

   if  ((ed_zeile = (char *) malloc(AUTORZEILE_LEN * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nProblem in re_brow_allocate_memory()\n");
      exit(1);
   }
   if  ((showrec = (char *) malloc(SHOWREC_LEN * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nProblem in re_brow_allocate_memory()\n");
      exit(1);
   }

   if  ((ex_au_zeile = (char *) malloc(AUTORZEILE_LEN * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nProblem in re_brow_allocate_memory()\n");
      exit(1);
   }
   if  ((desc_zeile = (char *) malloc(DESC_ZEILE_LEN * sizeof(char)))==NULL)
   {
      fprintf(stderr,"\nProblem in re_brow_allocate_memory()\n");
      exit(1);
   }
   return 1;
}

int re_brow_free_memory(void)
{
   free(au_zeile);
   free(ed_zeile);
   free(showrec);
   free(ex_au_zeile);
   free(desc_zeile);
   return 1;
}

void browse_menu(void)
{
   int  erst_ansicht;
     /*
        1 : beim Ersteintritt in die Anzeigeschleife
        0 : beim Verbleib in der Schleife;
     */
   long ix_zeiger, byte_zeiger;
   long abst_ix_zeiger;
   long n_ix; /* Anzahl Indexeintraege */
   char browse_bbt_pfad[PFAD_LEN+1];
   char neu_bbt_pfad[PFAD_LEN+1];
    refspix_rec ix01rec_lokal;
    abstrpix_rec ix04rec_lokal;

   int taste;
   static char ein[INPUT_BU_LEN+1];

   if (!isfile(journal_pix_name))
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",journal_pix_name);
      exit(1);
   }
   if (filesize(journal_pix_name) < sizeof(ix01rec_lokal))
   {
      fprintf(stderr,"\nProblem: Cannot read data from %s (empty)\n",
        journal_pix_name);
      exit(1);
   }
   /* Groesse der Indexdatei abfragen */
   n_ix = filesize(journal_pix_name)/sizeof(ix01rec);
   n_ix--;
   
   
   
   if ((!isfile(journal_name)) ||
       (!isfile(book_name)) ||
       (!isfile(autorjl_name)) ||
       (!isfile(autorbu_name)) ||
       (n_ix < 0)
      )
   {
      fprintf(stderr,"\nProblem: For browsing, a complete set of data files "
             "and at least one record must be available\n");
      exit(1);
   }
   if (!read_ix04(abstr_pix_name))
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",abstr_pix_name);
      exit(1);
   }
   if ((fpjournal = fopen(journal_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",journal_name);
      exit(1);
   }
   if ((fpdesc = fopen(desc_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",desc_name);
      exit(1);
   }
   read_ix01(journal_pix_name);
   if ((fpbuch = fopen(book_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",book_name);
      exit(1);
   }
   if ((fpautorjl = fopen(autorjl_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",autorjl_name);
      exit(1);
   }
   if ((fpautorbu = fopen(autorbu_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",autorbu_name);
      exit(1);
   }
    
   strlimcpy(browse_bbt_pfad,rdbpfad,PFAD_LEN);
   strlimcat(browse_bbt_pfad,BROWSE_BBT_NAME,PFAD_LEN);
   strlimcpy(neu_bbt_pfad,rdbpfad,PFAD_LEN);
   /*------*/
   wrtxt("\nMenu: browse complete database [f/l/n/p/c/k/#/i/s/a/q]\n");
   strcpy(ein,"menu");
   taste = 1;
   ix_zeiger = 0;
   erst_ansicht = 1;
   do
   {
       if (erst_ansicht)
       {
          erst_ansicht = 0;
          if (strlen(kennziffer_global) > 0)
          {
             ix_zeiger = locate_ix01(kennziffer_global,&ix01rec_lokal);
             if (ix_zeiger > -1)
             {
                fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
                fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
                fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
                taste=-1;
             }
             else taste = 2;
          }
          else taste = 2;
       } else 
       {
           taste = menu_wahl(ein,BROWSE_RECORDS_MENU);
       }
       if (taste==1)  /* option f: */
       {
            ix_zeiger = 0;
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==2)  /* option l: */
       {
            if (n_ix > 0)
            {
               ix_zeiger = n_ix;
            }
            else
            {
               ix_zeiger = 0;
            }
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==3)   /* option n: */
       {
            if ((n_ix > 0) && (ix_zeiger < n_ix))
            {
                ix_zeiger++;
            }
            else
            {
               wrtxt("\nThis is the last record!\n");
               ix_zeiger = n_ix;
            }
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==4)   /* option p: */
       {
            if ((n_ix > 0) && (ix_zeiger > 0))
            {
                ix_zeiger--;
            }
            else
            {
               wrtxt("\nThis is the first record!\n");
               ix_zeiger = 0;
            }
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==5)  /* option c: */
       {
            strlimcpy(ein,"menu",INPUT_BU_LEN);
            if (n_ix > 0)
            {
               ix_zeiger = ix_zeiger;
            }
            else
            {
               ix_zeiger = 0;
            }
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==6) /* option k: */
       {
            static char ein_kennziffer[INPUT_BU_LEN+1];
            strlimcpy(ein,"menu",INPUT_BU_LEN);
            if (n_ix > 0)
            {
              ein_zeile(ein_kennziffer,"Please enter reference number",INPUT_BU_LEN);
              if (strlen(ein_kennziffer)==0) continue;

              ix_zeiger = locate_ix01(ein_kennziffer,&ix01rec_lokal);
              if (ix_zeiger==-1)
              {
                  sprintf(wrtxtbu,"\nREFERENCE with key `%s' not found\n",ein_kennziffer);
                  wrtxt(wrtxtbu);
                  ix_zeiger = 0;
                  continue;
              }
            }
            else
            {
               ix_zeiger = 0;
            }
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
            fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
            fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==7) /* option #: */
       {
          long zahl;
          char zahlstring[INPUT_BU_LEN+1];
          int ok_zahl, ok_schleife;
          strlimcpy(ein,"menu",INPUT_BU_LEN);
          if (ix_zeiger < RECORD_ZAHL_MAX_VORGABE)
            sprintf(zahlstring,"%li",ix_zeiger);
          else
            strcpy(zahlstring,"");
          ok_schleife = 0;
          do
          {
             sprintf(wrtxtbu,"Please enter record number: %li..%li "
                   "to be shown",0L,n_ix);
             ein_zeile(zahlstring,wrtxtbu,INPUT_BU_LEN);
             string_in_long(zahlstring,&zahl,&ok_zahl);
             if (((ok_zahl) && (zahl >= 0L) && (zahl <= n_ix)) &&
                 (strlen(zahlstring) > 0))
             {
                 ok_schleife=1;
                 ix_zeiger = zahl;
             }
             else
                 ok_schleife = 0;
             if (strlen(zahlstring) == 0) ok_schleife=1;
             

          } while (!ok_schleife);
          if (strlen(zahlstring) == 0) continue;
          fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
          fread(&ix01rec_lokal,sizeof(ix01rec_lokal),1,ix01file);
          fseek(ix01file,ix_zeiger * sizeof(ix01rec_lokal),SEEK_SET);
       }
       if (taste==8) /* option i: */
       {
         strlimcpy(ein,"menu",INPUT_BU_LEN);
         abst_ix_zeiger = locate_ix04(ix01rec_lokal.kennziffer,&ix04rec_lokal);
         if (abst_ix_zeiger==-1)
         {
           sprintf(wrtxtbu,"\nCurrent record %li, range: %li..%li, no abstract\n",
             ix_zeiger,0L,n_ix);
           wrtxt(wrtxtbu);
         }
         else
         {
           sprintf(wrtxtbu,"\nCurrent record %li, range %li..%li with abstract\n",
                ix_zeiger,0L,n_ix);
           wrtxt(wrtxtbu);
         }
         continue;
       }
       if (taste==9) /* option s: */
       { 
          save_bbt(ix01rec_lokal.kennziffer,browse_bbt_pfad);
          strlimcpy(ein,"menu",INPUT_BU_LEN);
          
          continue;
       }
       if (taste==10) /* option a: */
       {
          if(daten_datei_lesen(ix01rec_lokal.kennziffer))
          {
              show_textfile(abst_text_temp);
              strcpy(ein,"menu"); /* 4.8.01 */
           }
           else
           {
             strcpy(ein,"menu");
             continue;
           }
       }
       else if (taste==11) break; /* option q: */
       strcpy(kennziffer_global,ix01rec_lokal.kennziffer);
       byte_zeiger = ix01rec_lokal.journal_rptr * sizeof(one_journal_rec);
       fseek(fpjournal,byte_zeiger,SEEK_SET);
       fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

       desc_blaettern(desc_zeile,fpdesc,ix01rec_lokal.desc_rptr);
       if (!strcmp(one_journal_rec.reftyp,"j1"))
       {
          auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          j1_rec_zeigen(au_zeile,desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"m1"))
       {
          auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          m1_rec_zeigen(au_zeile,desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"j2"))
       {
          // auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          j2_rec_zeigen("",desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"m2"))
       {
          // auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          m2_rec_zeigen("",desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"b1") || !strcmp(one_journal_rec.reftyp,"b2")
           || !strcmp(one_journal_rec.reftyp,"b3"))
       {

          byte_zeiger = ix01rec_lokal.buch_rptr * sizeof(one_buch_rec);
          fseek(fpbuch,byte_zeiger,SEEK_SET);
          fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

          if (!strcmp(one_journal_rec.reftyp,"b1"))
          {
              auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              b1_rec_zeigen(ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
          if (!strcmp(one_journal_rec.reftyp,"b2"))
          {
              auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
              b2_rec_zeigen(au_zeile,ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
          if (!strcmp(one_journal_rec.reftyp,"b3"))
          {
              // auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              b3_rec_zeigen(ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
       }
   } while (1);
   close_ix01();
   close_ix04();
   fclose(fpjournal);
   fclose(fpdesc);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);

   if (isfile(browse_bbt_pfad))
   {
      do
      {
        ein_zeile(ein,"Please enter name for BBT-file "
            "(.bbt will be appended)",INPUT_BU_LEN);
        if (strlen(ein)==0)
        {
           remove(browse_bbt_pfad);
           wrtxt("\n(Selected references removed)\n");
           break;
        }
        if (isvalidfilename(ein))
        {
           FILE * fpalt;
           FILE * fpneu;
           bbatchtable_rec one_bbt_rec;
           long i, anzahl_records, byte_zeiger;
           int do_overwrite;
           
           do_overwrite = 0;
           
           strlimcat(neu_bbt_pfad,ein,PFAD_LEN);
           strlimcat(neu_bbt_pfad,".bbt",PFAD_LEN);
           if (isfile(neu_bbt_pfad))
           {
              do_overwrite = do_overwrite_append_oa();
           }
           /* Zu ende Schreiben: Datensaetze kopieren */
           if (do_overwrite==0)
           {
             if ((fpneu=fopen(neu_bbt_pfad,"a+b"))==NULL)
             {
                 fprintf(stderr,"\nProblem: cannot create or write into `%s'\n",
                   neu_bbt_pfad);
                 exit(1);
             }
           }
           else
           {
             if ((fpneu=fopen(neu_bbt_pfad,"wb"))==NULL)
             {
                 fprintf(stderr,"\nProblem: cannot create or write into `%s'\n",
                   neu_bbt_pfad);
                 exit(1);
             }
           }

           if ((fpalt=fopen(browse_bbt_pfad,"rb"))==NULL)
           {
               fprintf(stderr,"\nProblem: read from `%s'\n",
                 browse_bbt_pfad);
               exit(1);
           }
           memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
           fseek(fpalt,0L,SEEK_END);
           byte_zeiger = ftell(fpalt);
           anzahl_records=byte_zeiger / sizeof(one_bbt_rec);
           anzahl_records--;
           rewind(fpalt);
           for (i=0;i<=anzahl_records;i++)
           {
              fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpalt);
              if (fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpneu) < 1) schreibfehler();
           }
           fclose(fpneu);
           fclose(fpalt);
           sprintf(wrtxtbu,"\nSelected references written into `%s'\n",
             neu_bbt_pfad);
           wrtxt(wrtxtbu);
           remove(browse_bbt_pfad);
           break;
        }
      } while (1);
   }
}

void browse_bbt(char * bbt_name)
{
   int  erst_ansicht;
     /*
        1 : beim Ersteintritt in die Anzeigeschleife
        0 : beim Verbleib in der Schleife;
     */
   int kennziffer_gefunden; /* 1 if kennziffer has been found */
   long bbt_zeiger, byte_zeiger, abst_ix_zeiger;
   long n_bbt; /* Anzahl Indexeintraege */
   refspix_rec ix01rec_lokal;
   abstrpix_rec ix04rec_lokal;
   bbatchtable_rec one_bbt_rec;
   char browse_bbt_pfad[PFAD_LEN+1];
   char neu_bbt_pfad[PFAD_LEN+1];

   FILE * fpbbt;

   int taste;
   static char ein[INPUT_BU_LEN+1];

   if (!isfile(journal_pix_name))
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",journal_pix_name);
      exit(1);
   }
   if (!isfile(abstr_pix_name))
   {
      fprintf(stderr,"\nProblem: Cannot read file %s\n",abstr_pix_name);
      exit(1);
   }
   if (filesize(journal_pix_name) < sizeof(ix01rec_lokal))
   {
      fprintf(stderr,"\nProblem: Cannot read data from %s\n",journal_pix_name);
      exit(1);
   }
   if (!isfile(bbt_name))
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",bbt_name);
      exit(1);
   }
   if (filesize(bbt_name) < sizeof(one_bbt_rec))
   {
      sprintf(wrtxtbu,"\nWARNING: file %s is empty, leaving ``b'' menu option\n"
                 ,bbt_name);
      wrtxt(wrtxtbu);

      return;
   }

   /* Groesse der Bbt-datei abfragen */
   n_bbt = filesize(bbt_name)/sizeof(one_bbt_rec);
   n_bbt--;
   
   if (!read_ix04(abstr_pix_name))
   {
      fprintf(stderr,"\nProblem: Cannot open %s\n",abstr_pix_name);
      exit(1);
   }
   if ((fpbbt = fopen(bbt_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nERROR: Cannot open %s\n",bbt_name);
      exit(1);
   }
   if ((!isfile(journal_name)) ||
       (!isfile(book_name)) ||
       (!isfile(autorjl_name)) ||
       (!isfile(autorbu_name))
      )
   {
      fprintf(stderr,"\nProblem: For browsing, a complete set of data files "
               "must be available\n");
      close_ix04();
      fclose(fpbbt);
      exit(1);
   }

   if ((fpjournal = fopen(journal_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",journal_name);
      exit(1);
   }
   if ((fpdesc = fopen(desc_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",desc_name);
      exit(1);
   }
   read_ix01(journal_pix_name);

   if ((fpbuch = fopen(book_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",book_name);
      exit(1);
   }
   if ((fpautorjl = fopen(autorjl_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",autorjl_name);
      exit(1);
   }
   if ((fpautorbu = fopen(autorbu_name,"rb"))==NULL)
   {
      fprintf(stderr,"\nProblem: Cannot read %s\n",autorbu_name);
      exit(1);
   }

   bbt_zeiger = 0;
   rewind(fpbbt);
   taste = 1;

   strlimcpy(browse_bbt_pfad,rdbpfad,PFAD_LEN);
   strlimcat(browse_bbt_pfad,BROWSE_BBT_NAME,PFAD_LEN);
   strlimcpy(neu_bbt_pfad,rdbpfad,PFAD_LEN);

   sprintf(wrtxtbu,"\n(File `%s' with %li records)\n\n"
                   "Menu: browse database records of bbt-file [f/l/n/p/c/k/#/i/s/a/q]\n",
                    
          bbt_name, n_bbt+1);
   wrtxt(wrtxtbu);
   strcpy(ein,"menu");
   taste = 1;
   kennziffer_gefunden=0;
   erst_ansicht = 1;
   do
   {
       /* 
        * At which position in bbt-file is the record with
        * `kennziffer_global'?
        */
       if ((erst_ansicht==1))
       {
           bbt_zeiger = 0;
           for (bbt_zeiger=0;bbt_zeiger<=n_bbt;bbt_zeiger++)
           {
              byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
              fseek(fpbbt,byte_zeiger,SEEK_SET);
              fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
              /* kennziffer_global found! */
              if (strcmp(one_bbt_rec.kennziffer,kennziffer_global)==0)
              {
                 // printf("\n---%li---\n",bbt_zeiger);
                 kennziffer_gefunden = 1;
                 break;
              }
           }
           if (kennziffer_gefunden==0)
           {
              taste = 1;
           } else
           {
              taste = 5;
           }
           
       } else
       {
          taste = menu_wahl(ein,BROWSE_RECORDS_MENU);
       }
       erst_ansicht = 0;
       if (taste==1)  /* option f: */
       {
            bbt_zeiger = 0;
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\nReference `%s' not found\n",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==2) /* option l: */
       {
            bbt_zeiger = n_bbt;
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\nReference `%s' not found\n",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==3) /* option n: */
       {
            bbt_zeiger++;
            if (bbt_zeiger > n_bbt)
            {
               bbt_zeiger = n_bbt;
               sprintf(wrtxtbu,"\nThis is the last record "
               "referred to in the current batch table!\n");
               wrtxt(wrtxtbu);
               // continue;
            }
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\nReference `%s' not found\n",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               /* next line added 27.4.2002 */
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==4) /* option p: */
       {
            bbt_zeiger--;
            if (bbt_zeiger < 0)
            {
               bbt_zeiger = 0;
               sprintf(wrtxtbu,"\nThis is the first record referred to "
               "in the current batch table!\n");
               wrtxt(wrtxtbu);
               // continue;
            }
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\nReference `%s' not found\n",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==5)  /* option c: */
       {
            strlimcpy(ein,"menu",INPUT_BU_LEN);
            bbt_zeiger = bbt_zeiger; /* refresh view on current record */
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\nReference `%s' not found\n",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==6) /* option k: */
       {
            static char ein_kennziffer[INPUT_BU_LEN+1];
            strlimcpy(ein,"menu",INPUT_BU_LEN);
            if (n_bbt >= 0)
            {
              ein_zeile(ein_kennziffer,"Please enter reference number",INPUT_BU_LEN);
              if (strlen(ein_kennziffer)==0) continue;
              fseek(fpbbt,0L,SEEK_SET);
              for (bbt_zeiger=0;bbt_zeiger<=n_bbt;bbt_zeiger++)
              {
                 fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
                 if (!strcmp(one_bbt_rec.kennziffer,ein_kennziffer))
                 {
                   break; /* record found in bbt-file */
                 }
                 if (bbt_zeiger == n_bbt)
                 {
                    sprintf(wrtxtbu,"\nKey `%s' not found in BBT-file\n",
                      ein_kennziffer);
                    wrtxt(wrtxtbu);
                    bbt_zeiger = 0;
                    break;
                 }
              }
              byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
              fseek(fpbbt,byte_zeiger,SEEK_SET);
              fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
              if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
              {
                 sprintf(wrtxtbu,"\nReference `%s' not found\n",one_bbt_rec.kennziffer);
                 wrtxt(wrtxtbu);
                 continue;
              }
              fseek(fpbbt,byte_zeiger,SEEK_SET);
            }
            else
            {
               bbt_zeiger = 0;
            }
       }
       if (taste==7) /* option #: */
       {
          long zahl;
          char zahlstring[RECORD_ZAHLSTRING_LEN + 1];
          int ok_zahl, ok_schleife;
          strlimcpy(ein,"menu",INPUT_BU_LEN);
          if (bbt_zeiger < RECORD_ZAHL_MAX_VORGABE)
             sprintf(zahlstring,"%li",bbt_zeiger);
          else
             strcpy(zahlstring,"");
          ok_schleife = 0;
          do
          {
             sprintf(wrtxtbu,"Please enter record number: %li..%li "
                   "to be shown",0L,n_bbt);
             ein_zeile(zahlstring,wrtxtbu,INPUT_BU_LEN);
             string_in_long(zahlstring,&zahl,&ok_zahl);
             if (((ok_zahl) && (zahl >= 0L) && (zahl <= n_bbt)) &&
                 (strlen(zahlstring) > 0))
             {
                 ok_schleife=1;
                 bbt_zeiger = zahl;
             }
             else
                 ok_schleife = 0;
             if (strlen(zahlstring) == 0) ok_schleife=1;
          } while (!ok_schleife);
          if (strlen(zahlstring) == 0) continue;
          byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
          fseek(fpbbt,byte_zeiger,SEEK_SET);
          fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
          if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
          {
             sprintf(wrtxtbu,"\nReference `%s' not found!\n",one_bbt_rec.kennziffer);
             wrtxt(wrtxtbu);
             continue;
          }
          fseek(fpbbt,byte_zeiger,SEEK_SET);
       }
       if (taste==9) /* option s: */
       {
            strlimcpy(ein,"menu",INPUT_BU_LEN);
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\nReference `%s' not found?\n",one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               continue;
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            // save_bbt(ix01rec_lokal.kennziffer);
            save_bbt(ix01rec_lokal.kennziffer,browse_bbt_pfad);
            continue;
       }
       if (taste==8 ||  taste== 10)
       {
            strlimcpy(ein,"menu",INPUT_BU_LEN);
            sprintf(wrtxtbu,"\n(File %s: record %li, range: %li..%li)\n",
              bbt_name,bbt_zeiger,0L,n_bbt);
            wrtxt(wrtxtbu);
            byte_zeiger = bbt_zeiger * sizeof(one_bbt_rec);
            fseek(fpbbt,byte_zeiger,SEEK_SET);
            fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
            if (locate_ix01(one_bbt_rec.kennziffer,&ix01rec_lokal)==-1)
            {
               sprintf(wrtxtbu,"\nReference `%s' not found in database\n",
                  one_bbt_rec.kennziffer);
               wrtxt(wrtxtbu);
               continue;
            }
            else
            {
               abst_ix_zeiger=locate_ix04(one_bbt_rec.kennziffer,
                     &ix04rec_lokal);
               if (abst_ix_zeiger >= 0)
               {
                  if (taste==10) /* ViewAbstract */
                  {
                     if(daten_datei_lesen(ix01rec_lokal.kennziffer))
                     {
                        show_textfile(abst_text_temp);
                        strcpy(ein,"menu"); /* 4.8.01 */
                     }
                     else
                     {
                         strcpy(ein,"menu");
                         continue;
                      }
                  }
                  else /* Info */
                  {
                    sprintf(wrtxtbu,"\nReference `%s' and abstract in database\n",
                              one_bbt_rec.kennziffer);
                    wrtxt(wrtxtbu);
                    continue;
                  }
               }
               else
               {
                  sprintf(wrtxtbu,"\nREFERENCE `%s' in database, no abstract\n",
                            one_bbt_rec.kennziffer);
                  wrtxt(wrtxtbu);
                  continue;
               }
            }
            fseek(fpbbt,byte_zeiger,SEEK_SET);
       }

       if (taste==11) break; /* option q: */
       strcpy(kennziffer_global,ix01rec_lokal.kennziffer);
       byte_zeiger = ix01rec_lokal.journal_rptr * sizeof(one_journal_rec);
       fseek(fpjournal,byte_zeiger,SEEK_SET);
       fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

       desc_blaettern(desc_zeile,fpdesc,ix01rec_lokal.desc_rptr);

       if (!strcmp(one_journal_rec.reftyp,"j1"))
       {
          auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          j1_rec_zeigen(au_zeile,desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"m1"))
       {
          auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          m1_rec_zeigen(au_zeile,desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"j2"))
       {
          // auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          j2_rec_zeigen("",desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"m2"))
       {
          // auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
          m2_rec_zeigen("",desc_zeile,showrec,ex_au_zeile);
       }
       if (!strcmp(one_journal_rec.reftyp,"b1") || !strcmp(one_journal_rec.reftyp,"b2") 
           || !strcmp(one_journal_rec.reftyp,"b3"))
       {
          byte_zeiger = ix01rec_lokal.buch_rptr * sizeof(one_buch_rec);
          fseek(fpbuch,byte_zeiger,SEEK_SET);
          fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

          if (!strcmp(one_journal_rec.reftyp,"b1"))
          {
              auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              b1_rec_zeigen(ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
          if (!strcmp(one_journal_rec.reftyp,"b2"))
          {
              auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              auedstring_blaettern(au_zeile,fpautorjl,ix01rec_lokal.autorjl_rptr);
              b2_rec_zeigen(au_zeile,ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
          if (!strcmp(one_journal_rec.reftyp,"b3"))
          {
              // auedstring_blaettern(ed_zeile,fpautorbu,ix01rec_lokal.autorbu_rptr);
              b3_rec_zeigen(ed_zeile,desc_zeile,showrec,ex_au_zeile);
          }
       }
   } while (1);

   close_ix01();
   close_ix04();
   fclose(fpjournal);
   fclose(fpdesc);
   fclose(fpbbt);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);

   if (isfile(browse_bbt_pfad))
   {
      do
      {
        ein_zeile(ein,"Please enter name for BBT-file "
            "(.bbt will be appended)",INPUT_BU_LEN);
        if (strlen(ein)==0)
        {
           remove(browse_bbt_pfad);
           wrtxt("\n(Selected references removed)\n");
           break;
        }
        if (isvalidfilename(ein))
        {
           FILE * fpalt;
           FILE * fpneu;
           bbatchtable_rec one_bbt_rec;
           long i, anzahl_records, byte_zeiger;
           int do_overwrite;

           do_overwrite = 0;
           
           strlimcat(neu_bbt_pfad,ein,PFAD_LEN);
           strlimcat(neu_bbt_pfad,".bbt",PFAD_LEN);
           if (isfile(neu_bbt_pfad))
           {
              do_overwrite = do_overwrite_append_oa();
           }
           /* Zu ende Schreiben: Datensaetze kopieren */
           if (do_overwrite==0)
           {
             if ((fpneu=fopen(neu_bbt_pfad,"a+b"))==NULL)
             {
                 fprintf(stderr,"\nProblem: cannot create or write into `%s'\n",
                   neu_bbt_pfad);
                 exit(1);
             }
           } 
           else
           {
             if ((fpneu=fopen(neu_bbt_pfad,"wb"))==NULL)
             {
                 fprintf(stderr,"\nProblem: cannot create or write into `%s'\n",
                   neu_bbt_pfad);
                 exit(1);
             }
           }
           if ((fpalt=fopen(browse_bbt_pfad,"rb"))==NULL)
           {
               fprintf(stderr,"\nProblem: read from `%s'\n",
                 browse_bbt_pfad);
               exit(1);
           }
           memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
           fseek(fpalt,0L,SEEK_END);
           byte_zeiger = ftell(fpalt);
           anzahl_records=byte_zeiger / sizeof(one_bbt_rec);
           anzahl_records--;
           rewind(fpalt);
           for (i=0;i<=anzahl_records;i++)
           {
              fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpalt);
              if (fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpneu) < 1) schreibfehler();
           }
           fclose(fpneu);
           fclose(fpalt);
           sprintf(wrtxtbu,"\nSelected references written into `%s'\n",
             neu_bbt_pfad);
           wrtxt(wrtxtbu);
           remove(browse_bbt_pfad);
           break;
        }
      } while (1);
   }
   return;
}

static void desc_blaettern(
                           char * desc_zeile,
                           FILE * datfl,
                           long desc_rptr
                         )
{
   desc_rec dr;
   int i, anz_rec;

   strcpy(desc_zeile,"");
   if (desc_rptr==-1)
   {
      return;
   }
   fseek(datfl,desc_rptr*sizeof(dr),SEEK_SET);
   fread(&dr,sizeof(dr),1,datfl);
   anz_rec = dr.desc_n;
   fseek(datfl,desc_rptr*sizeof(dr),SEEK_SET);
   for(i=1;i<=anz_rec;i++)
   {
      if (i > MAX_N_DESC)
      {
         trim(au_zeile,' ');
         break;
      }
      fread(&dr,sizeof(dr),1,datfl);
      strlimcat(desc_zeile,dr.keywordsfield,DESC_ZEILE_LEN);
      if (i < anz_rec)
      {
         strlimcat(desc_zeile,", ",DESC_ZEILE_LEN);
      }
   }
   trim(desc_zeile,' ');
   return;
}


static void auedstring_blaettern(
                           char * au_zeile,
                           FILE * datfl,
                           long aued_rptr
                         )
{
   /* Diese Funktion erfordert, dass datfl bereits offen ist */
   author_rec aued_rec;
   int i, anz_autoren;

   strcpy(au_zeile,"");
   if (aued_rptr==-1)
   {
       return;
   }

   fseek(datfl,aued_rptr*sizeof(aued_rec),SEEK_SET);
   fread(&aued_rec,sizeof(aued_rec),1,datfl);
   anz_autoren = aued_rec.au_n;
   fseek(datfl,aued_rptr*sizeof(aued_rec),SEEK_SET);

   for(i=1;i<=anz_autoren;i++)
   {
      if (i > MAX_N_AUTHORS)
      {
         trim(au_zeile,' ');
         break;
      }
      fread(&aued_rec,sizeof(aued_rec),1,datfl);
      strlimcat(au_zeile,aued_rec.au_nachname,AUTORZEILE_LEN);
      strlimcat(au_zeile,",",AUTORZEILE_LEN);
      strlimcat(au_zeile,aued_rec.au_vornamen,AUTORZEILE_LEN);
      strlimcat(au_zeile,";",AUTORZEILE_LEN);
   }
   trim(au_zeile,' ');
   return;
}

void j1_rec_zeigen(char * au_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];
   // int taste;

   long i, j, n_zeilen;
   if (!auedstring_ok(au_zeile,ex_au_zeile))
       return;

   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';
   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *ARTICLE IN A JOURNAL* ",one_journal_rec.kennziffer);
   aued_zeile_zeigen(au_zeile,ex_au_zeile,showrec);
   strlimcat(showrec,": ",SHOWREC_LEN);

   if (strlen(one_journal_rec.titel)>=1)
   {
      strlimcat(showrec,one_journal_rec.titel,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.kuerzel)>=1)
   {
      show_quell(one_journal_rec.kuerzel,showrec);
   }
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
      strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
      if (strlen(one_journal_rec.monat) > 0)
      {
         strlimcat(showrec,"/",SHOWREC_LEN);
         strlimcat(showrec,one_journal_rec.monat,SHOWREC_LEN);
         if (strlen(one_journal_rec.tag) > 0)
         {
            strlimcat(showrec,"/",SHOWREC_LEN);
            strlimcat(showrec,one_journal_rec.tag,SHOWREC_LEN);
         }
      }
      strlimcat(showrec,"; ",SHOWREC_LEN);
   }


   if (strlen(one_journal_rec.band)>=1)
   {
      strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
      if (strlen(one_journal_rec.issue_nummer)>0)
      {
         strlimcat(showrec,"(",SHOWREC_LEN);
         strlimcat(showrec,one_journal_rec.issue_nummer,SHOWREC_LEN);
         strlimcat(showrec,")",SHOWREC_LEN);
      }
      strlimcat(showrec,": ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.seite_bis)>=1)
   {
      strlimcat(showrec,"-",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1 ||
           strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,". ",SHOWREC_LEN);
   }

   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.idnr)>=1)
   {
      strlimcat(showrec," (IDNR: ",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.idnr,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   wrtxt("\n");
   for (i=1;i<=n_zeilen;i++)
   {
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");
      logdatei_schreiben(wrtxtbu);
   }
   logdatei_schreiben("--");
}

//// Noch einmal lesen
void j2_rec_zeigen(char * au_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];
   // int taste;

   long i, j, n_zeilen;
   //if (!auedstring_ok(au_zeile,ex_au_zeile))
   //    return;

   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';
   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *ARTICLE IN A JOURNAL (INSTITUTIONAL AUTHOR)* ",one_journal_rec.kennziffer);
   // aued_zeile_zeigen(au_zeile,ex_au_zeile,showrec);
   if (strlen(one_journal_rec.instau) > 0)
   {
      strlimcat(showrec,one_journal_rec.instau,SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.instau) > 0)
   {
     strlimcat(showrec,": ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.titel)>=1)
   {
      strlimcat(showrec,one_journal_rec.titel,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.kuerzel)>=1)
   {
      show_quell(one_journal_rec.kuerzel,showrec);
   }
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
      strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
      if (strlen(one_journal_rec.monat) > 0)
      {
         strlimcat(showrec,"/",SHOWREC_LEN);
         strlimcat(showrec,one_journal_rec.monat,SHOWREC_LEN);
         if (strlen(one_journal_rec.tag) > 0)
         {
            strlimcat(showrec,"/",SHOWREC_LEN);
            strlimcat(showrec,one_journal_rec.tag,SHOWREC_LEN);
         }
      }
      strlimcat(showrec,"; ",SHOWREC_LEN);
   }


   if (strlen(one_journal_rec.band)>=1)
   {
      strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
      if (strlen(one_journal_rec.issue_nummer)>0)
      {
         strlimcat(showrec,"(",SHOWREC_LEN);
         strlimcat(showrec,one_journal_rec.issue_nummer,SHOWREC_LEN);
         strlimcat(showrec,")",SHOWREC_LEN);
      }
      strlimcat(showrec,": ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.seite_bis)>=1)
   {
      strlimcat(showrec,"-",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1 ||
           strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,". ",SHOWREC_LEN);
   }

   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.idnr)>=1)
   {
      strlimcat(showrec," (IDNR: ",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.idnr,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   wrtxt("\n");
   for (i=1;i<=n_zeilen;i++)
   {
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");
      logdatei_schreiben(wrtxtbu);
   }
   logdatei_schreiben("--");
}



void b2_rec_zeigen(char * au_zeile, char * ed_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];

   long i, j, n_zeilen;
   if (!auedstring_ok(au_zeile,ex_au_zeile))
       return;
   if (!auedstring_ok(ed_zeile,ex_au_zeile))
       return;
   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';

   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *CHAPTER/ARTICLE IN A BOOK* ",one_journal_rec.kennziffer);
   aued_zeile_zeigen(au_zeile,ex_au_zeile,showrec);
   strlimcat(showrec,": ",SHOWREC_LEN);

   if (strlen(one_journal_rec.titel)>=1)
   {
      strlimcat(showrec,one_journal_rec.titel,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". In: ",SHOWREC_LEN);
      else
         strlimcat(showrec," In: ",SHOWREC_LEN);
   }
   aued_zeile_zeigen(ed_zeile,ex_au_zeile,showrec);
   strlimcat(showrec,": editor(s). ",SHOWREC_LEN);

   if (strlen(one_buch_rec.titel_bu)>=1)
   {
      strlimcat(showrec,one_buch_rec.titel_bu,SHOWREC_LEN);
      if (!satzzeichen(showrec))
        strlimcat(showrec,". ",SHOWREC_LEN);
      else
        strlimcat(showrec," ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.isbn)>0)
   {
     strlimcat(showrec,"(ISBN: ",SHOWREC_LEN);
     strlimcat(showrec,one_buch_rec.isbn,SHOWREC_LEN);
     strlimcat(showrec,") ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.band)>=1)
   {
      strlimcat(showrec,"(",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
      strlimcat(showrec,". ed) ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.publ_ort)>=1)
   {
       strlimcat(showrec,one_buch_rec.publ_ort,SHOWREC_LEN);
       strlimcat(showrec,": ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.verlag)>=1)
   {
       strlimcat(showrec,one_buch_rec.verlag,SHOWREC_LEN);
       strlimcat(showrec,", ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
       strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
       strlimcat(showrec,": ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
       strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,"-",SHOWREC_LEN);
       strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   /* 19.3.1997 */
   if (strlen(one_journal_rec.seite_bis)>=1 ||
           strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,". ",SHOWREC_LEN);
   }


   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.idnr)>=1)
   {
      strlimcat(showrec," (IDNR: ",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.idnr,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }


   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   wrtxt("\n");
   for (i=1;i<=n_zeilen;i++)
   {
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");
      logdatei_schreiben(wrtxtbu);
   }
   logdatei_schreiben("--");
}


void b1_rec_zeigen(char * ed_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];

   long i, j, n_zeilen;
   if (!auedstring_ok(ed_zeile,ex_au_zeile))
       return;

   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';

   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *BOOK* ",one_journal_rec.kennziffer);

   aued_zeile_zeigen(ed_zeile,ex_au_zeile,showrec);
   strlimcat(showrec,": editor(s). ",SHOWREC_LEN);

   if (strlen(one_buch_rec.titel_bu)>=1)
   {
      strlimcat(showrec,one_buch_rec.titel_bu,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.isbn)>0)
   {
     strlimcat(showrec,"(ISBN: ",SHOWREC_LEN);
     strlimcat(showrec,one_buch_rec.isbn,SHOWREC_LEN);
     strlimcat(showrec,") ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.band)>=1)
   {
      strlimcat(showrec,"(",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
      strlimcat(showrec,". ed) ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.publ_ort)>=1)
   {
       strlimcat(showrec,one_buch_rec.publ_ort,SHOWREC_LEN);
       strlimcat(showrec,": ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.verlag)>=1)
   {
       strlimcat(showrec,one_buch_rec.verlag,SHOWREC_LEN);
       strlimcat(showrec,", ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
       strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
       strlimcat(showrec,". ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1  ||
        strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,"(",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
       strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,"-",SHOWREC_LEN);
       strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   /* 19.3.1997 */
   if (strlen(one_journal_rec.seite_von)>=1 ||
            strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,") ",SHOWREC_LEN);
   }


   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.idnr)>=1)
   {
      strlimcat(showrec," (IDNR: ",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.idnr,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }



   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   wrtxt("\n");
   for (i=1;i<=n_zeilen;i++)
   {
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");
      logdatei_schreiben(wrtxtbu);
   }
   logdatei_schreiben("--");
}


void b3_rec_zeigen(char * ed_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];

   long i, j, n_zeilen;
   // if (!auedstring_ok(ed_zeile,ex_au_zeile))
   //     return;

   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';
   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *BOOK (INSTITUTIONAL EDITOR)* ",one_journal_rec.kennziffer);

   // aued_zeile_zeigen(ed_zeile,ex_au_zeile,showrec);
   if (strlen(one_buch_rec.insted) > 0)
   {
      strlimcat(showrec,one_buch_rec.insted,SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.insted) > 0)
   {
     strlimcat(showrec,": editor(s). ",SHOWREC_LEN);
   }


   if (strlen(one_buch_rec.titel_bu)>=1)
   {
      strlimcat(showrec,one_buch_rec.titel_bu,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.isbn)>0)
   {
     strlimcat(showrec,"(ISBN: ",SHOWREC_LEN);
     strlimcat(showrec,one_buch_rec.isbn,SHOWREC_LEN);
     strlimcat(showrec,") ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.band)>=1)
   {
      strlimcat(showrec,"(",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
      strlimcat(showrec,". ed) ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.publ_ort)>=1)
   {
       strlimcat(showrec,one_buch_rec.publ_ort,SHOWREC_LEN);
       strlimcat(showrec,": ",SHOWREC_LEN);
   }
   if (strlen(one_buch_rec.verlag)>=1)
   {
       strlimcat(showrec,one_buch_rec.verlag,SHOWREC_LEN);
       strlimcat(showrec,", ",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
       strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
       strlimcat(showrec,". ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1  ||
        strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,"(",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
       strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,"-",SHOWREC_LEN);
       strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   /* 19.3.1997 */
   if (strlen(one_journal_rec.seite_von)>=1 ||
            strlen(one_journal_rec.seite_bis)>=1)
   {
       strlimcat(showrec,") ",SHOWREC_LEN);
   }


   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.idnr)>=1)
   {
      strlimcat(showrec," (IDNR: ",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.idnr,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }



   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   wrtxt("\n");
   for (i=1;i<=n_zeilen;i++)
   {
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");
      logdatei_schreiben(wrtxtbu);
   }
   logdatei_schreiben("--");
}

void m1_rec_zeigen(char * au_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];
   // int taste;

   long i, j, n_zeilen;
   if (!auedstring_ok(au_zeile,ex_au_zeile))
       return;

   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';
   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *MISC* ",one_journal_rec.kennziffer);
   aued_zeile_zeigen(au_zeile,ex_au_zeile,showrec);
   strlimcat(showrec,": ",SHOWREC_LEN);

   if (strlen(one_journal_rec.titel)>=1)
   {
      strlimcat(showrec,one_journal_rec.titel,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   // if (strlen(one_journal_rec.kuerzel)>=1)
   // {
   //    show_quell(one_journal_rec.kuerzel,showrec);
   // }
   if (strlen(one_journal_rec.howpublished)>=1)
   {
      strlimcat(showrec,one_journal_rec.howpublished,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   // 
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
      strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
      if (strlen(one_journal_rec.monat) > 0)
      {
         strlimcat(showrec,"/",SHOWREC_LEN);
         strlimcat(showrec,one_journal_rec.monat,SHOWREC_LEN);
         if (strlen(one_journal_rec.tag) > 0)
         {
            strlimcat(showrec,"/",SHOWREC_LEN);
            strlimcat(showrec,one_journal_rec.tag,SHOWREC_LEN);
         }
      }
      strlimcat(showrec,"; ",SHOWREC_LEN);
   }


   // if (strlen(one_journal_rec.band)>=1)
   // {
   //    strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
   //    if (strlen(one_journal_rec.issue_nummer)>0)
   //    {
   //       strlimcat(showrec,"(",SHOWREC_LEN);
   //       strlimcat(showrec,one_journal_rec.issue_nummer,SHOWREC_LEN);
   //       strlimcat(showrec,")",SHOWREC_LEN);
   //    }
   //    strlimcat(showrec,": ",SHOWREC_LEN);
   // }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.seite_bis)>=1)
   {
      strlimcat(showrec,"-",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1 ||
           strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,". ",SHOWREC_LEN);
   }

   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.idnr)>=1)
   {
      strlimcat(showrec," (IDNR: ",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.idnr,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   wrtxt("\n");
   for (i=1;i<=n_zeilen;i++)
   {
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");
      logdatei_schreiben(wrtxtbu);
   }
   logdatei_schreiben("--");
}

void m2_rec_zeigen(char * au_zeile, char * desc_zeile, char * showrec, char * ex_au_zeile)
{
   char zeile[SCREENLINE_LEN + 256];
   // int taste;

   long i, j, n_zeilen;
   //if (!auedstring_ok(au_zeile,ex_au_zeile))
   //    return;

   if (descstring_ok(desc_zeile,ex_au_zeile) < 0)
       return;

   showrec[0] = '\0';
   if (strlen(one_journal_rec.kennziffer)>0)
      sprintf(showrec,"[%s] *MISC (INSTITUTIONAL AUTHOR)* ",one_journal_rec.kennziffer);
   // aued_zeile_zeigen(au_zeile,ex_au_zeile,showrec);
   if (strlen(one_journal_rec.instau) > 0)
   {
      strlimcat(showrec,one_journal_rec.instau,SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.instau) > 0)
   {
     strlimcat(showrec,": ",SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.titel)>=1)
   {
      strlimcat(showrec,one_journal_rec.titel,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   // if (strlen(one_journal_rec.kuerzel)>=1)
   // {
   //    show_quell(one_journal_rec.kuerzel,showrec);
   // }
   if (strlen(one_journal_rec.howpublished)>=1)
   {
      strlimcat(showrec,one_journal_rec.howpublished,SHOWREC_LEN);
      if (!satzzeichen(showrec))
         strlimcat(showrec,". ",SHOWREC_LEN);
      else
         strlimcat(showrec," ",SHOWREC_LEN);
   }
   // 
   if (strlen(one_journal_rec.jahrgang)>=1)
   {
      strlimcat(showrec,one_journal_rec.jahrgang,SHOWREC_LEN);
      if (strlen(one_journal_rec.monat) > 0)
      {
         strlimcat(showrec,"/",SHOWREC_LEN);
         strlimcat(showrec,one_journal_rec.monat,SHOWREC_LEN);
         if (strlen(one_journal_rec.tag) > 0)
         {
            strlimcat(showrec,"/",SHOWREC_LEN);
            strlimcat(showrec,one_journal_rec.tag,SHOWREC_LEN);
         }
      }
      strlimcat(showrec,"; ",SHOWREC_LEN);
   }


   // if (strlen(one_journal_rec.band)>=1)
   // {
   //    strlimcat(showrec,one_journal_rec.band,SHOWREC_LEN);
   //    if (strlen(one_journal_rec.issue_nummer)>0)
   //    {
   //       strlimcat(showrec,"(",SHOWREC_LEN);
   //       strlimcat(showrec,one_journal_rec.issue_nummer,SHOWREC_LEN);
   //       strlimcat(showrec,")",SHOWREC_LEN);
   //    }
   //    strlimcat(showrec,": ",SHOWREC_LEN);
   // }

   if (strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,one_journal_rec.seite_von,SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.seite_bis)>=1)
   {
      strlimcat(showrec,"-",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.seite_bis,SHOWREC_LEN);
   }

   if (strlen(one_journal_rec.seite_bis)>=1 ||
           strlen(one_journal_rec.seite_von)>=1)
   {
      strlimcat(showrec,". ",SHOWREC_LEN);
   }

   if (strlen(desc_zeile)>=1)
   {
      strlimcat(showrec,"KEYWORDS: ",SHOWREC_LEN);
      strlimcat(showrec,desc_zeile,SHOWREC_LEN);
      strlimcat(showrec,".",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.status)>=1)
   {
      strlimcat(showrec," (STATUS=",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.status,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   if (strlen(one_journal_rec.idnr)>=1)
   {
      strlimcat(showrec," (IDNR: ",SHOWREC_LEN);
      strlimcat(showrec,one_journal_rec.idnr,SHOWREC_LEN);
      strlimcat(showrec,")",SHOWREC_LEN);
   }
   wwrap(showrec,SCREENLINE_LEN);
   /* cls_line(""); */
   n_zeilen=countitem(showrec,"\n");
   j = 1;
   wrtxt("\n");
   for (i=1;i<=n_zeilen;i++)
   {
      extractitem((int) i,showrec,"\n",zeile);
      sprintf(wrtxtbu,"%s",zeile);
      wrtxt(wrtxtbu);
      wrtxt("\n");
      logdatei_schreiben(wrtxtbu);
   }
   logdatei_schreiben("--");
}

int auedstring_ok(char * au_zeile, char * ex_au_zeile)
{
  int i, anz_autoren;
  char a_name[AUNAME_LEN + AUVORNAMEN_LEN + 12 + 1];
  char v_name[AUNAME_LEN + AUVORNAMEN_LEN + 12 + 1];

  char ein[INPUT_BU_LEN+1];

  anz_autoren = countitem(au_zeile,";");

  if (anz_autoren > MAX_N_AUTHORS)
  {
     sprintf(wrtxtbu,"\nProblem: List of authors/editors contains > %i items\n",MAX_N_AUTHORS);
     wrtxt(wrtxtbu);
     ein_zeile(ein,"Please press ENTER",INPUT_BU_LEN);
     return 0;
  }
  if (strlen(au_zeile)==0)
  {
     sprintf(wrtxtbu,"\nProblem in %s: No authors/editors entered\n",ix01rec.kennziffer);
     wrtxt(wrtxtbu);
     ein_zeile(ein,"Please press ENTER",INPUT_BU_LEN);
     return 0;
  }
  for (i=1;i<=anz_autoren;i++)
  {
      strcpy(ex_au_zeile,"");
      extractitem(i,au_zeile,";",ex_au_zeile);
      trim(ex_au_zeile,' ');
      ex_au_zeile[AUNAME_LEN + AUVORNAMEN_LEN + 12] = '\0';
      extractitem(1,ex_au_zeile,",",a_name);
      trim(a_name,' ');
      if (strlen(a_name) > AUNAME_LEN)
      {
        sprintf(wrtxtbu,"\nProblem in %s: Authors/Editors no %i: name too long, 1..%i allowed\n",
           ix01rec.kennziffer,i,AUNAME_LEN);
        wrtxt(wrtxtbu);
        ein_zeile(ein,"Please press ENTER",INPUT_BU_LEN);
        return 0;
      }
      a_name[AUNAME_LEN]= '\0';
      if (strlen(a_name) < 1)
      {
        sprintf(wrtxtbu,"\nProblem in %s: Authors/Editors no %i: No name?\n",ix01rec.kennziffer,i);
        wrtxt(wrtxtbu);
        ein_zeile(ein,"Please press ENTER",INPUT_BU_LEN);
        return 0;
      }

      extractitem(2,ex_au_zeile,",",v_name);
      trim(v_name,' ');
      if (strlen(v_name) > AUVORNAMEN_LEN)
      {
        sprintf(wrtxtbu,"\nProblem in %s: Authors/Editors no %i: too many first names, 1..%i allowed\n",
           ix01rec.kennziffer,i,AUVORNAMEN_LEN);
        wrtxt(wrtxtbu);
        ein_zeile(ein,"Please press ENTER",INPUT_BU_LEN);
        return 0;
      }


      v_name[AUVORNAMEN_LEN] = '\0';
      if (strlen(v_name) < 1)
      {
        sprintf(wrtxtbu,"\nProblem in %s: Authors/Editors no %i: No first name?\n",ix01rec.kennziffer,i);
        wrtxt(wrtxtbu);
        ein_zeile(ein,"Please press ENTER",INPUT_BU_LEN);
        return 0;
      }
  }
   return anz_autoren;
}

int descstring_ok(char * desc_zeile, char * ex_au_zeile)
{
  int i, anz_desc;

  char ein[INPUT_BU_LEN+1];

  anz_desc = countitem(desc_zeile,",");
  if (anz_desc > MAX_N_DESC)
  {
     sprintf(wrtxtbu,"\nProblem: List of keywords contains > %i items\n",MAX_N_DESC);
     wrtxt(wrtxtbu);
     ein_zeile(ein,"Please press ENTER",INPUT_BU_LEN);
     return -1;
  }

  if (strlen(desc_zeile)==0)
  {
     sprintf(wrtxtbu,"\nProblem in %s: No keywords entered\n",ix01rec.kennziffer);
     wrtxt(wrtxtbu);
     ein_zeile(ein,"Please press ENTER",INPUT_BU_LEN);
     return -1;
  }

  for (i=1;i<=anz_desc;i++)
  {
      strcpy(ex_au_zeile,"");
      extractitem(i,desc_zeile,",",ex_au_zeile);
      trim(ex_au_zeile,' ');
      if (strlen(ex_au_zeile) > KEYWORDS_LEN)
      {
        sprintf(wrtxtbu,"\nProblem in %s: keword %i too long: 1..%i characters allowed\n",
           ix01rec.kennziffer,i,KEYWORDS_LEN);
        wrtxt(wrtxtbu);
        ein_zeile(ein,"Please press ENTER",INPUT_BU_LEN);
        return -1;
      }
  }
  return anz_desc;
}

void aued_zeile_zeigen(char * zeile, char * ex_au_zeile, char * showrec)
{
   int i,anz_autoren;
   char a_name[AUNAME_LEN+12];
   char v_name[AUNAME_LEN+12];

   anz_autoren=countitem(zeile,";");
   for (i=1;i<=anz_autoren;i++)
   {
      strcpy(ex_au_zeile,"");
      extractitem(i,zeile,";",ex_au_zeile);
      trim(ex_au_zeile,' ');
      ex_au_zeile[AUNAME_LEN + AUVORNAMEN_LEN + 12] = '\0';
      extractitem(1,ex_au_zeile,",",a_name);
      trim(a_name,' ');
      a_name[AUNAME_LEN]= '\0';
      extractitem(2,ex_au_zeile,",",v_name);
      trim(v_name,' ');
      v_name[AUVORNAMEN_LEN] = '\0';
      strlimcat(showrec,a_name,SHOWREC_LEN);
      strlimcat(showrec," ",SHOWREC_LEN);
      strlimcat(showrec,v_name,SHOWREC_LEN);
      if (i<anz_autoren) strlimcat(showrec,", ",SHOWREC_LEN);
   }

}

int show_quell(const char * key, char * shows)
{
    FILE * dat_quell;
    quellpix_rec ix_rec_lokal;
    long ix_zeiger, rec_zeiger, byte_zeiger;
    quell_rec quell_rec_lokal;

    if (!isfile(quell_pix_name))
    {

       strlimcat(shows,"[",SHOWREC_LEN);
       strlimcat(shows,key,SHOWREC_LEN);
       strlimcat(shows,"] ",SHOWREC_LEN);
       return 0;
    }
    // if (filesize(quell_pix_name) < sizeof(ix_quell_rec))
    if (filesize(quell_pix_name) < sizeof(quellpix_rec))
    {
       strlimcat(shows,"[",SHOWREC_LEN);
       strlimcat(shows,key,SHOWREC_LEN);
       strlimcat(shows,"] ",SHOWREC_LEN);
       return 0;
    }
    read_ix02(quell_pix_name);
    ix_zeiger = locate_ix02(key, &ix_rec_lokal);
    close_ix02();
    if (ix_zeiger==-1)
    {
       strlimcat(shows,"[",SHOWREC_LEN);
       strlimcat(shows,key,SHOWREC_LEN);
       strlimcat(shows,"] ",SHOWREC_LEN);
       return 0;
    }
    rec_zeiger=ix_rec_lokal.quell_rptr;
    byte_zeiger = rec_zeiger*sizeof(quell_rec);
    if ((dat_quell=fopen(quell_name,"rb"))==NULL)
    {
       sprintf("\nProblem: Cannot read in %s\n",quell_name);
       exit(1);
    }
    fseek(dat_quell,byte_zeiger,SEEK_SET);
    fread(&quell_rec_lokal,sizeof(quell_rec),1,dat_quell);
    fclose(dat_quell);
    strlimcat(shows,quell_rec_lokal.quell_zeitschrift,SHOWREC_LEN);
    if (strlen(quell_rec_lokal.quell_issn) > 0)
    {
       strlimcat(shows," (ISSN: ",SHOWREC_LEN);
       strlimcat(shows,quell_rec_lokal.quell_issn,SHOWREC_LEN);
       strlimcat(shows,")",SHOWREC_LEN);
    }

    strlimcat(shows," ",SHOWREC_LEN);
    return 1;
}

static int daten_datei_lesen(char * kennziffer)
{
    long rec_zeiger, byte_zeiger, pos_zeiger;
    int i, anzahl_records;
    unsigned int laenge;
    char * abstract;
    FILE * fpabsdat;
    FILE * fpabstext;

    if ((abstract = (char *) malloc ((ABSTRACT_ZEILE_LEN +1) * sizeof(char)))
                          ==NULL)
    {
        fprintf(stderr,"\nProblem: Unable to alloacte memory for showing abstract\n");
        exit(1);
    }

    /*   read_ix04(abstr_pix_name); */
    pos_zeiger = locate_ix04(kennziffer,&ix04rec);
    /*   close_ix04(); */
    if (pos_zeiger==-1)
    {
        wrtxt("\nNo abstract available!\n");
        free(abstract);
        return 0;
    }
    else
    {
       strcpy(abstract,"");
       rec_zeiger=ix04rec.abstr_rptr;
       byte_zeiger = rec_zeiger * sizeof(one_abstr_rec);

       if ((fpabsdat=fopen(abstr_dat_name,"rb"))==NULL)
       {
           fprintf(stderr,"\nProblem: Cannot read %s\n",
                   abstr_dat_name);
           free(abstract);
           exit(1);
       }
       fseek(fpabsdat,byte_zeiger,SEEK_SET);
       fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);

       fseek(fpabsdat,byte_zeiger,SEEK_SET);
       anzahl_records=one_abstr_rec.abstr_n;
       if (anzahl_records > MAX_BLOECKE)
          anzahl_records = MAX_BLOECKE;
       /* die letzten 2 Zeilen eingefuegt am 18.2.1998 */
       for (i=1;i<=anzahl_records;i++)
       {
          fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
          strcat(abstract,one_abstr_rec.abs_text);

          if (i > MAX_BLOECKE)
          {
            fprintf(stderr,"\nProblem: Unexpected ERROR in 'dat_datei_lesen()', "
                   "please inform program author\n");
            exit(1);
          }
       }
       fclose(fpabsdat);
    }
    laenge = strlen(abstract);
    for (i=0;i<laenge;i++)
    {
      if (abstract[i]=='\xfe')
         abstract[i]='\n';
    }

    if ((fpabstext=fopen(abst_text_temp,"wt"))==NULL)
    {
        fprintf(stderr,"\nProblem: Cannot write into %s\n",abst_text_temp);
        free(abstract);
        exit(1);
    }


    fprintf(fpabstext,"BEGIN OF ABSTRACT\n\n");
    fprintf(fpabstext,"%s",abstract);
    fprintf(fpabstext,"\n\nEND OF ABSTRACT");

    fclose(fpabstext);
    free(abstract);
    return 1;
}


static int show_textfile(char * t_name)
{
     /* vtxt(t_name, "View abstract"); */
     vtxt(t_name,""); 
     return 1;
}

static void save_bbt(const char * schluessel, char * browse_bbt_name)
{
    FILE * fpbrowsebbt;
    bbatchtable_rec one_bbt_rec;

    memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
    if ((fpbrowsebbt=fopen(browse_bbt_name,"a+b"))==NULL)
    {
        fprintf(stderr,"\nProblem: cannot create `%s' or write into `%s'\n",
          browse_bbt_name,browse_bbt_name);
        exit(1);
    }
    fseek(fpbrowsebbt,0L,SEEK_END);
    strncpy(one_bbt_rec.kennziffer,schluessel,KENNZIFFER_LEN +1);
    if (fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbrowsebbt)==1)
    {
       sprintf(wrtxtbu,"\nReference number `%s' stored in temporary BBT-file\n",
            schluessel);
       wrtxt(wrtxtbu);
    }
    fclose(fpbrowsebbt);
}


