/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/* v4.3 */

/* 
  Assertions:
  
  assert(KUERZEL_LEN==QUELLKUERZEL_LEN);
 
*/

#include <limits.h>

#ifndef REFS_H
#define REFS_H

#define REFS_VERSION "4.3"
#define REFS_SUB_VERSION "4.3d"
#define COPYRIGHT_STRING "(c) 1995-2007"
#define COPYRIGHT_STRING_WITH_AUTHOR "(c) 1995-2007 V. Kiefel"

#define PFAD_LEN 255
#define FORM_LABEL_LEN 32
#define DATEINAME_LEN 255
 /* File name length before extension (Win32)*/
#define EINGABE_DATEINAME_VOR_PUNKT 72
 /* Complete filename length (Win32) */
#define EINGABE_DATEINAME_LEN 76

/* if compiled under MSDOS */

#define DOSDATEINAME_LEN         12
#define DOSDATEIVORNAME_LEN       8


#define KAT_SORTIER_N          500 /* max number of files sorted in file
                                      selection (fl_ut.c) */
#define KATDATEINAME_LEN       PFAD_LEN /* in fl_ut.c */

#define WILDCARD_PATTERN_LEN             16

#define PROMPT_LEN 40
#define CS_LEN 256
/* line length of titles etc in text editor */
#define EDITING_LINE_LEN 78

#define EDITOR_CMD_LEN 128

#define CFG_ZEILE_LEN 2048 

#define TEXTFILE_ENCODING_LEN 32
/* values for encoding of text files (Linux/Unix) */
#define ENC_UTF8 "utf-8"
#define ENC_ISO8859 "ISO-8859"


#define WRTXTBU_LEN            2048
#define KEYWORDS_NUMBER_LEN      12

#define MAXFELD_LEN             255 /* Caution: must be enlarged if any field gets larger 255 char! */


#define AUTORZEILE_LEN    (size_t) 32000L
#define SHOWREC_LEN       (size_t) 32000L
#define MAX_N_AUTHORS                 999
#define AUSGABEZEILE_LEN  (size_t) 32000L
#define SCREENLINE_LEN    78
#define DESC_ZEILE_LEN    (size_t) 32000L
#define MAX_N_DESC                    999
#define ENABLE_HL_LEN     3


#define KENNZIFFER_LEN     12
#define TITEL_LEN         255
#define INSTAU_LEN        140
#define INSTED_LEN        140
#define KUERZEL_LEN        10
#define IDNR_LEN          255  /* new in v4.2 */
#define JAHRGANG_LEN        4
#define MONAT_LEN           2
#define TAG_LEN             2
#define ISSUE_NUMMER_LEN    8
#define BAND_LEN           20
#define SEITE_VON_LEN      10
#define SEITE_BIS_LEN      10
#define REFTYP_LEN          2
#define HOWPUBLISHED_LEN  160  /* new in v4.1, m1, m2 */
#define STATUS_LEN         12
#define STICHW_LEN        140
  /* STICHW_LEN wird entbehrlich */

  /* 
   * Length of text file into which an abstract is copied from DAT file 
   * ABSTRACT_ZEILE_LEN is referred to in re_brow.c:
   */
#define ABSTRACT_ZEILE_LEN 30600
#define MAX_BLOECKE 62


/* JOURNAL.DAT */
typedef struct
{
  short int in_use;                  /* 1: record in use, 0: record deleted */
  char kennziffer[KENNZIFFER_LEN + 1];                      /* database key */
  char titel[TITEL_LEN +1];
  char instau[INSTAU_LEN +1];    /* institutional authors introduced in v4.1*/ 
  char kuerzel[KUERZEL_LEN + 1];
  char idnr[IDNR_LEN + 1];       /* new in v4.2 */
  char jahrgang[JAHRGANG_LEN +1];
  char monat[MONAT_LEN + 1];
  char tag[TAG_LEN + 1];
  char band[BAND_LEN + 1];
   /* band field contains for j1, j2: volume number 
                          b1, b2, b3: edition number */
  char issue_nummer[ISSUE_NUMMER_LEN + 1];
  char seite_von[SEITE_VON_LEN + 1];
  char seite_bis[SEITE_BIS_LEN + 1];
  char reftyp[REFTYP_LEN + 1];                /* document type: j1, b1 ... */
  char howpublished[HOWPUBLISHED_LEN + 1];    /* m1, m2 */
  char status[STATUS_LEN + 1];
} journal_rec;
/*  journal_rec */


/* JOURNAL.IX */
typedef struct
{
  char kennziffer[KENNZIFFER_LEN + 1];
  long journal_rptr;
  long buch_rptr;
  long autorjl_rptr;
  long autorbu_rptr;
  long desc_rptr;
} refspix_rec;


// #define KEYWORDS_LEN       45
#define KEYWORDS_LEN       75

/* DESC.DAT */
typedef struct
{
  short int in_use;
  short int desc_i;
  short int desc_n;
  char kennziffer[KENNZIFFER_LEN + 1];
  char keywordsfield[KEYWORDS_LEN + 1];
} desc_rec;


#define AUKENNZIFFER_LEN   12
#define AUNAME_LEN         26
#define AUVORNAMEN_LEN      6

/* AUTORJL.DAT AUTORBO.DAT */
typedef struct
{
   short int in_use_au;
   short int au_i;          /* 1..n */
   short int au_n;          /* n for all n authors */
   char au_kennziffer[AUKENNZIFFER_LEN +1];
   char au_nachname[AUNAME_LEN +1];
   char au_vornamen[AUVORNAMEN_LEN + 1];
} author_rec;



#define QUELLKUERZEL_LEN           10
#define ZEITSCHRIFT_LEN            80
#define KURZFORM_LEN               60
#define ISSN_LEN                   14

/* SOURCE.DAT  */
typedef struct
{
   short int in_use_quell;
   char quell_kuerzel[QUELLKUERZEL_LEN + 1];
   char quell_zeitschrift[ZEITSCHRIFT_LEN + 1];
   char quell_kurzform[KURZFORM_LEN + 1];
   char quell_issn[ISSN_LEN +1];
} quell_rec;


/* SOURCE.IX */
typedef struct
{
  char quell_kuerzel[QUELLKUERZEL_LEN + 1];
  long quell_rptr;
} quellpix_rec;
/* Indexdatei fuer Zeitschriftennamen ..ix02.. */



#define TITELBUCH_LEN                   255
#define PUBLORT_LEN                     255
#define VERLAG_LEN                      140
#define ISBN_LEN                        20

/* BOOK.DAT */
typedef struct
{
  short int in_use_bu;
  char kennziffer[KENNZIFFER_LEN + 1];
  char titel_bu[TITELBUCH_LEN + 1];
  char insted[INSTED_LEN +1];    /* institutional editor introduced in v4.1*/ 
  char publ_ort[PUBLORT_LEN + 1];
  char verlag[VERLAG_LEN + 1];
  char isbn[ISBN_LEN + 1];
} buch_rec;


/* KEYW.DAT */
typedef struct
{
   short int in_use;
   char keywordsfield[KEYWORDS_LEN + 1];
} keylist_rec;



/* KEYW.IX */
typedef struct
{
   char keywordsfield[KEYWORDS_LEN + 1];
   long keywords_rptr;
} keylistpix_rec;

/* Indexdatei fuer Keywords ..ix03.. */


#define SORTIERFELD_LEN AUNAME_LEN + AUVORNAMEN_LEN + JAHRGANG_LEN

/* .BBT */
typedef struct
{
    char kennziffer[KENNZIFFER_LEN + 1];
    char sortierfeld[SORTIERFELD_LEN + 1];
} bbatchtable_rec;


#define ABSTEXT_LEN     492


typedef struct
{
   short int in_use;
   short int abstr_i;
   short int abstr_n;
   char kennziffer[KENNZIFFER_LEN + 1];
   char abs_text[ABSTEXT_LEN + 1];
} abstr_rec;

/*
  Ersatzzeichen ASCII 254 fuer Zeilenende (\xfe)
*/

typedef struct
{
   char kennziffer[KENNZIFFER_LEN + 1];
   long abstr_rptr;
} abstrpix_rec;


typedef struct
{
   char dname[KATDATEINAME_LEN + 1];
} d_katalogstapel_rec;
/* fl_ut.c */ 


/*
   In diese Struktur werden die Daten der
   Konfigurationsdatei eingelesen:
*/
typedef struct
{
   int sl;                     /* `LINES_OF_SCREEN' in refs.cfg */
   int open_editor_yn;         /* OPEN_EDITOR_YN 1 yes, 0 no */
   char prompt[PROMPT_LEN+1];  /* `PROMPT' in refs.cfg */
   char editor_name[PFAD_LEN+1]; /* name of text editor */
   char awk_name[PFAD_LEN+1];    /* locatization of awk binary file AWK */
   char path_to_scripts[PFAD_LEN+1]; /* PATH_TO_SCRIPS */
   char form_name[PFAD_LEN+1]; /* name of input form  text file 
                                  (addressed with `INPUT_FORM' in refs.cfg)*/
   char ky_form_name[PFAD_LEN+1];  /* name of input form text file for
                                      keywords (addressed with KEYW_FORM in
                                      refs.cfg */
   char jn_form_name[PFAD_LEN+1];  /* name of input form text file for journal
                                      names (addressed with JOURN_FORM in
                                      refs.cfg) */                                
   char form_label[FORM_LABEL_LEN+1]; /* string indicating labels in input file */
   char temptext_name[PFAD_LEN+1]; /* name of temporary text file name, 
                                     (addressed with TEMP_TEXT in refs.cfg*/
   char search_form_name[PFAD_LEN+1]; /* name of text file for search commands
                                      (addressed with SEARCH_FORM in refs.cfg */
   char pdf_viewer[PFAD_LEN+1];      /* name of PDF file viewer PDF_VIEWER */
   char help_file[PFAD_LEN+1];      /* name of HELP_FILE */
   char textfile_encoding[TEXTFILE_ENCODING_LEN+1];
                                    /* name of TEXTFILE_ENCODING */
   int  uses_less;                  /* USES_LESS 0: internal pager, 1: less */
   char less_options[PFAD_LEN+1];
                                    /* LESS_OPTIONS less command line
                                     * parameters  */
   char enable_hl[ENABLE_HL_LEN+1]; /* ENABLE_HL */
} config_set;




#endif

