{$I-,M $4000,0,0}
program mkdep;

{
checks the existence and date of source and target files

Usage: [<path>]MKDEP <source file(s)> [/ [<target file(s)>]]
       @<file> indicates a file containing lines with items
       ( file ... ) indicates a group of files (first one counts)

Return codes (Errorlevel) are:
  4: syntax error
  3: some source files don't exist
  2: some target files don't exist
  1: some target files are older
  0: all target files are newer

Copyright (C) 1995,96 Peter Breitenlohner (peb@mppmu.mpg.de)
}

uses dos;

const isf: boolean= false; {processing a list file?}
      index: integer= 0; {param count}

var listfile: text; {a list file}
    next: string; {next item}

{ we don't care when a group starts with a command line parameter and
  ends in a list file, or vice versa, although this makes little sense }

function getnext: boolean; {set next item or return false}
label again;
var c: char;
begin again: if isf then
  begin repeat while eoln(listfile) do
      begin readln(listfile);
      if eof(listfile) then
        begin close(listfile); isf:=false; goto again;
        end;
      end;
    read(listfile,c);
  until c<>' ';
  next:='';
  while c<>' ' do
    begin next:=next+c;
    if eoln(listfile) then c:=' ' else read(listfile,c);
    end;
  end
else if index=paramcount then
  begin getnext:=false; exit;
  end
else  begin inc(index); next:=paramstr(index);
  end;
if next[1]='@' then
  if isf then halt(4) {nested list file}
  else if length(next)=1 then goto again {ignore null list file}
  else  begin assign(listfile,copy(next,2,length(next)-1));
    reset(listfile);
    if ioresult<>0 then halt(4); {missing list file}
    isf:=true; goto again;
    end;
getnext:=true;
end;

var isn: boolean; {does next exist?}
    ndate: longint; {next's date}
    nextfile: text;

procedure testnext; {test existence and time stamp of next file}
begin assign(nextfile,next); reset(nextfile);
if ioresult<>0 then isn:=false
else  begin isn:=true; getftime(nextfile,ndate); close(nextfile);
  end;
end;

const ist: boolean= false; {has '/' been seen/}
      isg: boolean= false; {inside a group?}
      sdate: longint= 0; {source date so far}
      result: integer= 0; {result so far}

label again;

begin
while getnext do
  begin
  if next='/' then
    if isg or ist then halt(4) {duplicate or inside a group}
    else  begin ist:=true; goto again;
      end;
  if next='(' then
    if isg then halt(4) {already in a group}
    else  begin isg:=true; isn:=false; goto again;
      end;
  if next=')' then
    if not isg then halt(4) {not in a group}
    else isg:=false {keep isn and ndate}
  else if isg then
    begin if not isn then testnext; goto again;
    end
  else testnext; {set isn and ndate}
  if ist then
    if not isn then halt(2) {missing target file}
    else  begin if ndate<sdate then result:=1 {target file is older}
      end
  else if not isn then halt(3) {missing source file}
  else if ndate>sdate then sdate:=ndate; {source file is newer}
  again: end;
if isg then halt(4); {unfinished group}
halt(result);
end.
