/*
 * Decompiled with CFR 0.152.
 */
import java.util.Objects;

public class LaTeXScreenshooter {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("No arguments were passed.");
        } else {
            String url = args[0];
            int width = args.length > 1 ? Integer.parseInt(args[1]) : 600;
            int height = args.length > 2 ? Integer.parseInt(args[2]) : 600;
            String fileName = args.length > 3 ? args[3] : "Screenshot";
            Object path = args.length > 3 ? args[4] : System.getProperty("user.dir");
            String os = System.getProperty("os.name").toLowerCase();
            String slash = "";
            slash = os.contains("win") ? "\\" : "/";
            if (!((String)path).endsWith("\\") && !((String)path).endsWith("/")) {
                path = (String)path + slash;
            }
            path = PathValidator.isPathValid((String)path) ? path : System.getProperty("user.dir") + slash;
            System.out.println((String)path);
            String sessionType = System.getenv("XDG_SESSION_TYPE");
            if (Objects.equals(sessionType, "wayland")) {
                WaylandScreenshooter.captureScreenshot(url, width, height, fileName, (String)path);
            } else {
                System.out.println("Unable to determine the session type.");
                ScreenShooter.captureScreenshot(url, width, height, fileName, (String)path);
            }
        }
    }
}

