--[[
Copyright (c) 2011, Philipp Stephani <st_philipp@yahoo.de>

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
]]

local error, warning, info, log = luatexbase.provides_module {
   name = "lualatex-platform",
   date = "2011/03/30",
   version = "0.1",
   description = "Platform-specific enhancements for LuaLaTeX",
   author = "Philipp Stephani",
   licence = "Expat"
}

local pcall = pcall
local require = require

module "lualatex.platform"

local status, native = pcall(require, "lltxplatform")

if status then
   get_installed_fonts = native.get_installed_fonts
   get_inactive_fonts = native.get_inactive_fonts
else
   function get_installed_fonts() end
   function get_inactive_fonts() end
   error(native)
end
