/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  err_symbols_ph_th.lex
Dates:		  23 Mar 2004
Purpose:	  parse error-symbols phrase
              The keeps its own local symbol table: map and list.
              The term_def_ph adds symbol to Yacco2's
              global symbol table.
Output:       error_symbols_phrase
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |err_symbols_ph_th| Thread.\fbreak
Parse the error terminal definitions.
As all terminal vocabulary symbols have the same source template, 
|TH_term_def_ph| is used to parse 
individually each symbol.
\fbreak
Example of an error vocabulary to parse:\fbreak
\listing{"/usr/local/yacco2/diagrams+etc/errsym.txt"}

@/
fsm	
(fsm-id "err_symbols_ph_th.lex"
,fsm-filename err_symbols_ph_th
,fsm-namespace NS_err_symbols_ph_th
,fsm-class Cerr_symbols_ph_th{
  user-prefix-declaration
using namespace NS_yacco2_terminals;
#include "lint_balls.h"
#include "identifier.h"
#include "term_def_ph.h"
#include "c_string.h"
 ***
  user-declaration
    public:
    T_error_symbols_phrase* error_symbols_phrase_;
  ***
  constructor
    error_symbols_phrase_ = 0;
  ***
  op
    if(error_symbols_phrase_ != 0){
      delete error_symbols_phrase_;
      error_symbols_phrase_ = 0;
    }
    error_symbols_phrase_ = new T_error_symbols_phrase;
    error_symbols_phrase_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    AST* t = new AST(*error_symbols_phrase_);
    error_symbols_phrase_->phrase_tree(t);
  ***
}
,fsm-version "1.0",fsm-date "22 mar 2004",fsm-debug "false"
,fsm-comments "Parse Error vocabulary.")
parallel-parser	
(	
  parallel-thread-function
    TH_err_symbols_ph_th
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rerror_symbols_phrase  (){
  -> Rlint 
     Ropen_par 
       Rparameters  
     Rclose_par
     Rlint 
     Rsym_defs_phrase
     Rlint  {
    op
      Cerr_symbols_ph_th* fsm = (Cerr_symbols_ph_th*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->error_symbols_phrase_);
      fsm->error_symbols_phrase_ = 0;
    ***
    }	
}

Ropen_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "("
}

Rclose_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ")"
}

Rparameters  (){
  -> Rlint
     Rfilename_phrase Rlint
     Rnamespace_phrase Rlint
}

Rfilename_phrase  (
lhs{
user-declaration 
public:T_file_name* filename_;
***
}
){
  -> Rfilename Rlint Rfilename_id 
}

Rfilename  (){
  ->  ||| "#file-name" NS_identifier::TH_identifier
  ->  ||| |+| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_filename_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_filename_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfilename_id  (){
  ->  ||| identifier NS_identifier::TH_identifier {
      op
        Cerr_symbols_ph_th* fsm = (Cerr_symbols_ph_th*)rule_info__.parser__->fsm_tbl__;
        fsm->error_symbols_phrase_->filename_id(sf->p2__);
      ***
      } 
  ->  ||| |+| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_filename_id_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_filename_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rnamespace_phrase  (
lhs
){
  -> "," Rlint Rnamespace Rlint Rnamespace_id 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rnamespace  (){
  ->  ||| "#name-space" NS_identifier::TH_identifier 
  ->  ||| |+| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_namespace_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_namespace_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rnamespace_id  (){
  ->  ||| identifier NS_identifier::TH_identifier {
      op
        Cerr_symbols_ph_th* fsm = (Cerr_symbols_ph_th*)rule_info__.parser__->fsm_tbl__;
        fsm->error_symbols_phrase_->namespace_id(sf->p2__);
      ***
      } 
  ->  ||| |+| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_namespace_id_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_namespace_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rsym_defs_phrase  (){
  -> Ropen_brace Rlint
         Rsym_defs 
     Rclose_brace
}

Rsym_defs  (){
  ->  Rsym_def Rlint
  ->  Rsym_defs Rsym_def1 Rlint
}

Rsym_def  
/@
Note: trapped explicitly are directives that are improper
within this context. 
@/
(){
  ->  ||| "terminal-def" NS_term_def_ph::TH_term_def_ph {
    op
      Cerr_symbols_ph_th* fsm = (Cerr_symbols_ph_th*)rule_info__.parser__->fsm_tbl__;
	  sf->p2__->classification(T_terminal_def::err);
      CAbs_lr1_sym* r = 
		fsm->error_symbols_phrase_->add_t_to_alphabet(sf->p2__,rule_info__.parser__);
      if(r == 0) return;
      RSVP(r);
      rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  ||| |+| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ||| "#lrk-sufx" NULL {
      op
         sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  ||| "#terminals-refs" NULL {
      op
         sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  ||| "#terminals-sufx" NULL {
      op
         sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  |?| {
    op
        CAbs_lr1_sym* sym = new Err_no_sym_defs_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
}

Rsym_def1  (){
  ->  ||| "terminal-def" NS_term_def_ph::TH_term_def_ph {
    op
      Cerr_symbols_ph_th* fsm = (Cerr_symbols_ph_th*)rule_info__.parser__->fsm_tbl__;
	  sf->p2__->classification(T_terminal_def::err);
      CAbs_lr1_sym* r = 
		fsm->error_symbols_phrase_->add_t_to_alphabet(sf->p2__,rule_info__.parser__);
      if(r == 0) return;
      RSVP(r);
      rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  ||| "#lrk-sufx" NULL {
      op
         sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  ||| "#terminals-refs" NULL {
      op
         sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  ||| "#terminals-sufx" NULL {
      op
         sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_improper_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }      
  ->  ||| |+| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Ropen_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_open_brace;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "{"
}

Rclose_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_brace;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "}"
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls 
  -> 
}
}// end of rules
