/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  terminal_def_symclass.lex
Dates:		  29 Mar 2004
Purpose:	  terminal-def delete / abort tags
Output:       #sym-class
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |terminal_def_symclass| Thread.\fbreak
Recognize ``sym-class''  keyword.
@/
fsm	
(fsm-id	"terminal_def_symclass.lex"
,fsm-filename terminal_def_symclass
,fsm-namespace NS_terminal_def_symclass
,fsm-class Cterminal_def_symclass
,fsm-version "1.0",fsm-date "29 mar 2004",fsm-debug "false"
,fsm-comments "Lexer of ``sym-class'' keyword.")
parallel-parser	
(	
  parallel-thread-function
    TH_terminal_def_symclass
  ***
  parallel-la-boundary
    eolr - Rminus_la
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rterminal_def_symclass (
  lhs {
    user-declaration
      public:
      CAbs_lr1_sym* rtn_sym_;
    ***
    op
      rtn_sym_->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
      RSVP(rtn_sym_);
      rtn_sym_ = 0;      
    ***  
  }
){
  -> s y m "-" c l a s s          {
  op 
    rtn_sym_ = new T_sym_class;
    ***}
}

Rminus_la () {
  -> "_" 
  -> "-"  
  -> RUPPER_A_M  
  -> RUPPER_N_Z  
  -> Rlower_a_m  
  -> Rlower_n_z  
  -> RNUMBERS  
}

RUPPER_A_M  (){
  -> A -> B -> C -> D -> E -> F -> G -> H -> I -> J -> K -> L -> M 
}

RUPPER_N_Z  (){
  -> N -> O -> P -> Q 
  -> "R" // considered a Rule when not quoted!
  -> S -> T -> U -> V -> W -> X -> Y -> Z
}

Rlower_a_m (){
  -> a -> b -> c -> d -> e -> f -> g -> h -> i -> j -> k -> l -> m 
}

Rlower_n_z  (){
  -> n -> o -> p -> q -> r -> s -> t -> u -> v -> w -> x -> y -> z
}

RNUMBERS (){
  -> 0 -> 1 -> 2 -> 3 -> 4 -> 5 -> 6 -> 7 -> 8 -> 9
}

}// end of rules
