/*
 * Video
 */

#include <InterViews/patch.h>
#include <InterViews/box.h>
#include <InterViews/listener.h>
#include <InterViews/glue.h>
#include <InterViews/event.h>

#include <stream.h>

#include "drawing.h"

/*
 * Drawing
 */

Drawing::Drawing(DrawingBox* box)
   : MonoGlyph(), PointerHandler()
{
  printf("Drawing::Drawing()\n");

  _drawing_box = box;

  _button = Event::none;
  _listener = new Listener(new Overlay(), this);
  MonoGlyph::body(_listener);

  if (_drawing_box)
    append(_drawing_box->structure());
}

Drawing::~Drawing()
{
}

void Drawing::sensitive(boolean b)
{
  printf("Drawing::sensitive(boolean)\n");

  button(b, _button);
}

void Drawing::button(boolean b, EventButton which)
{
  printf("Drawing::button(boolean, EventButton)\n");
  printf("\tb=%s which=%d\n", (b ? "true" : "false"), which);

  _listener->button(b, _button = which);
}

void Drawing::motion(boolean b)
   { _listener->motion(b); }

void Drawing::key(boolean b)
   { _listener->key(b); }

void Drawing::current(boolean b)
{
  printf("Drawing::current(boolean)\n");
  printf("\tb=%s\n", (b ? "true" : "false"));

  if (_drawing_box)
    _drawing_box->current(this, b);

}

void Drawing::visible(boolean b)
{
  printf("Drawing::visible(boolean)\n");
  printf("\tb=%s\n", (b ? "true" : "false"));

  if (_drawing_box)
    _drawing_box->visible(this, b);

}

void Drawing::press(Event& e)
{
  printf("Drawing::press()\n");
  printf("\t x=%f y=%f\n", e.pointer_x(), e.pointer_y());
}

/*
 * DrawingBox
 */

DrawingBox::DrawingBox(Glyph* structure) : Patch(new Overlay())
{
  printf("DrawingBox::DrawingBox(Glyph*)\n");

  _structure = structure;
  append(_structure);
}

DrawingBox::DrawingBox(Coord height, Coord width) : Patch(new Overlay())
{
  printf("DrawingBox::DrawingBox(Coord, Coord)\n");

  _structure = new Overlay(
       new HGlue(width, fil, fil),
       new VGlue(height, fil, fil)
   );
  append(_structure);
  _current = nil;
}

DrawingBox::~DrawingBox()
{
}

boolean DrawingBox::contains(Glyph* g)
{
  return(lookup(g) >= 0);
}


void DrawingBox::visible(Drawing* v, boolean make_visible)
{
  long index = lookup(v);
  
  printf("DrawingBox::visible()\n");
  
  if (make_visible) {
    if (index < 0) {
      MonoGlyph::append(v);
      reallocate();
      redraw();
    }
  } else // make_visible is false
    if (index >= 0) {
      if (_current == v)
	_current = nil;
      
      printf("\tremoving\n");
      MonoGlyph::remove(index);
      redraw();
    }
}

void DrawingBox::current(Drawing* v, boolean make_current)
{
  printf("DrawingBox::current(Drawing, boolean)\n");
  printf("\tmake_current=%s\n", (make_current ? "true" : "false"));

  if (!contains(v)) 
    return;

  if (make_current) {
    if (v == _current)
      return;
    if (_current)
      _current->sensitive(false);
    (_current = v)->sensitive(true);
  } else {
    v->sensitive(false);
    if (v == _current)
      _current = nil;
  }
}

GlyphIndex DrawingBox::lookup(Glyph* g)
{
  for (GlyphIndex i = 0 ; i < count() ; ++i)
    if (g == component(i)) {
      return(i);
    }

  return(-1);
}
