/*
 * VideoSimulation
 */

#include <stdio.h>

#include "drawing_simulation.h"

DrawingSimulation::DrawingSimulation(
       SimulationController* controller, DrawingBox* box)
   : DynamicSimulation(controller),  Drawing(box)
{
}

void DrawingSimulation::press(Event& e)
{
  printf("DrawingSimulation::press()\n");
  printf("\t x=%f y=%f\n", e.pointer_x(), e.pointer_y());
}

void DrawingSimulation::start()
{
  DynamicSimulation::start();
  current(true);
  visible(true);
}

void DrawingSimulation::stop()
{
  DynamicSimulation::stop();
  current(false);
  visible(false);
}

