/*
 * Particle
 */

#include <InterViews/color.h>
#include <InterViews/brush.h>
#include <InterViews/style.h>

#include <OS/string.h>

#include <stream.h>

#include "figure.h"
#include "gems.h"
#include "particle.h"
#include "color_scale.h"

/*
 * Particle
 */

Particle::Particle(ParticleAnimation* animation,
       ScreenCoord x, ScreenCoord y, ScreenCoord z) : MonoGlyph()
{
//  printf("Particle::Particle()\n");
//  printf("\tScreen x=%f y=%f z=%f\n", x, y, z);
  _screen_x = x;
  _screen_y = y;
  _screen_z = _real_z = z;

  _animation = animation;
  _animation->xy_screen_to_real(x, y, _real_x, _real_y);
//  printf("\tReal x=%f y=%f z=%f\n", _real_x, _real_y, _real_z);

  _screen_dx = _screen_dy = _screen_dz = 0.0;
  _real_dx = _real_dy = _real_dz = 0.0;

  _previous = _next = nil;
  _status = 0;

  _animation->append(this);
}

Particle::~Particle()
{
  // Because of a figure bug they get reference twice, once when they
  // are constructed and once when they are put into the MonoGlyph.
  // For this reason we must unrefence them here, so that then
  // the monoglyph destructor will unref the figure and it will be 
  // deleted.
  Resource::unref(_figure);
//  printf("Particle::~Particle\n");
}

Glyph* Particle::body() const
{ 
  return(MonoGlyph::body());
}

void Particle::body(Glyph* g)
{
  MonoGlyph::body(g);
}

void Particle::body(Figure* figure) 
{
  MonoGlyph::body(_figure = figure);
}

void Particle::move(RealCoord threshhold,
       RealCoord x, RealCoord y, RealCoord z,
       RealCoord dx, RealCoord dy, RealCoord dz
   )
{
  update_coords(threshhold, x, y, z, dx, dy, dz);
  // change shape here is necessary
  _animation->move(this);
}

void Particle::update_coords(RealCoord threshhold, 
       RealCoord real_x, RealCoord real_y, RealCoord real_z,
       RealCoord, RealCoord, RealCoord
   )
{
//  printf("Particle::update_coords()\n");
//  printf("\t to real_x=%f \t real_y=%f \t real_z=%f\n", real_x, real_y, real_z);
//  printf("\tthreshhold=%f\n", threshhold);
//  printf("\treal_dx=%f \treal_dy=%f \treal_dz=%f", real_dx, real_dy, real_dz);
//  printf("\t_screen_x=%f \t_screen_y=%f _screen_z=%f\n", _screen_x, _screen_y, _screen_z);
//  printf("\t_real_x=%f \t_real_y=%f\n \t_real_z=%f\n", _real_x, _real_y, _real_z);

  _real_x = real_x;
  _real_y = real_y;
  _real_z = real_z;

  /*
   * Calculate new x, y, and move threshhold values
   */

  Coord x, y, x_threshhold, y_threshhold;

  _animation->xy_real_to_screen(_real_x, _real_y, x, y);
  
  _animation->dxy_real_to_screen(
       threshhold, threshhold,
       x_threshhold, y_threshhold,
   );

//  printf("\tx=%f \ty=%f\n", x, y);
//  printf("\tx_threshhold=%f \ty_threshhold=%f\n", x_threshhold, y_threshhold);
  
  /*
   * We only want to move the particle if there is a visible(i.e. above the move 
   * threshhold) change in the dimensions.
   */

  _z_move = (_old_color_index != 
       _animation->_color_scale->linear_index(
       	   _real_z, _animation->_real_floor, _animation->_real_ceiling
       )
   );
       

  _xy_move = !(
       Math::equal(x, _screen_x, x_threshhold) &&
       Math::equal(y, _screen_y, y_threshhold)
   );

  if (_xy_move) {
    _screen_x = x;
    _screen_y = y;
  }    

//  printf("\t_xy_move=%s\n", (_xy_move ? "true" : "false"));
//  printf("\t_z_move=%s\n", (_z_move ? "true" : "false"));
}

Color* Particle::color_scale(Coord z)
{
  return(
       _animation->_color_scale->color(
       	   _old_color_index = _animation->_color_scale->linear_index(
       	       z, _animation->_real_floor, _animation->_real_ceiling
       	   )
       )
   );
}


static Brush particle_brush(1.0);

/*
 * ParticlePoint
 */

ParticlePoint::ParticlePoint(ParticleAnimation* animation,
       ScreenCoord x, ScreenCoord y, ScreenCoord z)
   : Particle(animation,  x, y, z)
{
  Color* c = color_scale(z);
  body(new Rectangle(&particle_brush,  c, c, 0.0, 0.0, 2.0, 2.0));
}

ParticlePoint::~ParticlePoint()
{
//  printf("ParticlePoint::~ParticlePoint\n");
}

/*
 * PartcileSource
 */

ParticleSource::ParticleSource(ParticleAnimation* animation,
       ScreenCoord x, ScreenCoord y, ScreenCoord z)
   : Particle(animation, x, y, z)
{
//  printf("ParticleSource::ParticleSource()\n");
  Color* c = color_scale(z);
  body(new Circle(&particle_brush, c, nil, 0.0, 0.0, 4.0));
}

ParticleSource::~ParticleSource()
{
// printf("ParticleSource::~ParticleSource\n");
}
