/*
 * Particle
 */

#ifndef particle_h
#define particle_h

#include <InterViews/monoglyph.h>

#include "particle_animation.h"

class ParticleAnimation;
class Particle;
class Figure;

/*
 * Particle
 */

class Particle : public MonoGlyph {
protected:
  friend ParticleAnimation;

  Particle(ParticleAnimation* animation, ScreenCoord x, ScreenCoord y, ScreenCoord z);

  virtual Glyph* body() const;
  virtual void body(Glyph*);

  virtual void body(Figure* figure);

  void Particle::update_coords(RealCoord threshhold,
       RealCoord real_x, RealCoord real_y, RealCoord real_z,
       RealCoord real_dx, RealCoord real_dy, RealCoord real_dz
   );
  Color* color_scale(Coord z);

public:
  ~Particle();

  void move(RealCoord threshhold,
       RealCoord x, RealCoord y, RealCoord z,
       RealCoord dx =0, RealCoord dy =0, RealCoord dz =0
   );

  void real_location(RealCoord& x, RealCoord& y, RealCoord& z);
  void screen_location(ScreenCoord& x, ScreenCoord& y, ScreenCoord& z);
  Particle* next();
  
private:
  boolean _xy_move;
  boolean _z_move;

  ScreenCoord _screen_x, _screen_y, _screen_z;
  ScreenCoord _screen_dx, _screen_dy, _screen_dz;

  RealCoord _real_x, _real_y, _real_z;
  RealCoord _real_dx, _real_dy, _real_dz;

  int _old_color_index;
  Figure* _figure;
  Particle* _next;
  Particle* _previous;

  ParticleAnimation* _animation;
  Allocation _allocation;
  Extension _extension;
  int _status;
};

inline Particle* Particle::next() { return(_next); }

inline void Particle::screen_location(ScreenCoord& x, ScreenCoord& y, ScreenCoord& z)
   { x = _screen_x; y = _screen_y; z = _screen_z; }

inline void Particle::real_location(RealCoord& x, RealCoord& y, RealCoord& z)
   { x = _real_x; y = _real_y; z = _real_z; }

/*
 * ParticleSource
 */

class ParticleSource : public Particle {
public:
  ParticleSource(ParticleAnimation* animation, ScreenCoord x, ScreenCoord y, ScreenCoord z);
  ~ParticleSource();

};

/*
 * ParticlePoint
 */

class ParticlePoint : public Particle {
public:
  ParticlePoint(ParticleAnimation* animation, ScreenCoord x, ScreenCoord y, ScreenCoord z);
  ~ParticlePoint();
};

#endif
