/*
 * ParticleTracker
 */

#ifndef particle_tracker_h
#define particle_tracker_h

#include "drawing_simulation.h"
#include "particle.h"

class Page;
class Patch;
class Transformer;

class ParticleTracker : public DrawingSimulation {
public:
  ParticleTracker(SimulationController* controller, DrawingBox* box);
  ~ParticleTracker();

  virtual void update();

  virtual void move_particles();
  virtual void release_particles();    
  virtual void add_source(ScreenCoord x, ScreenCoord y, ScreenCoord z);
  virtual void add_particle(ScreenCoord x, ScreenCoord y, ScreenCoord z);
  void press(Event& e);

  Particle* head();
  virtual void start();
  virtual void stop();

  void clear_particles();
  void clear_sources();

  int release_step();
  void release_step(int n);

  RealCoord release_height();
  void release_height(RealCoord h);

  RealCoord move_step();
  void move_step(RealCoord s);

  boolean sources_visible();
  void sources_visible(boolean b);

  enum ParticleShape { point };
  void shape(ParticleShape shape);

  void update_real_size(
       Coord top =-1.0, Coord bottom =-1.0, Coord left =-1.0, Coord right =-1.0, 
       Coord floor =-1.0, Coord ceiling =-1.0);

private:
  int _release_counter;
  int _release_step;
  RealCoord _release_height;

  ParticleShape _shape;
  RealCoord _move_step;
  boolean _sources_visible;

  DrawingBox* _particle_tracker;

  Drawing* _source_drawing;
  Drawing* _particle_drawing;

  ParticleAnimation* _source_animation;
  ParticleAnimation* _particle_animation;

};

inline int ParticleTracker::release_step() 
   { return(_release_step); }

inline void ParticleTracker::release_step(int n) 
   { _release_step = n; }

inline RealCoord ParticleTracker::release_height()
   { return(_release_height); }

inline void ParticleTracker::release_height(RealCoord h)
   { _release_height = h; }

inline RealCoord ParticleTracker::move_step()
   { return(_move_step); }

inline void ParticleTracker::move_step(RealCoord s)
   { _move_step = s; }

inline boolean ParticleTracker::sources_visible()
   { return(_sources_visible); }

inline Particle* ParticleTracker::head()
   { return(_particle_animation->head()); }

inline void ParticleTracker::shape(ParticleShape shape)
   { _shape = shape; }

#endif

