/*
 * Selection class - used to keep track of currently selected objects
 */

#include <InterViews/brush.h>
#include <InterViews/resource.h>
#include <InterViews/color.h>
#include <stream.h>

#include "selection.h"


implementList(FigureList, Figure*);

Selection::Selection(Map* map)
{
  _map = map;
  _selected = new FigureList();
  _unselected_brush = new Brush(1.0);
  _selected_brush = new Brush(2.0);
  _area_border = new Color(0.8, 0.0, 0.0);
  _street_border = new Color(0.0, 0.8, 0.0);
  _grid_border = new Color(0.0, 0.0, 0.8);
  Resource::ref(_unselected_brush);
  Resource::ref(_selected_brush);
  Resource::ref(_area_border);
  Resource::ref(_street_border);
  Resource::ref(_grid_border);
}

Selection::~Selection()
{
}

void Selection::add_selection(Figure* f)
{
  f->brush(selected_brush());
  f->redraw();
  _selected->append(f);
}

void Selection::replace_selection(Figure* f)
{

  long i;
  long num_elts = _selected->count();
//  _map->selector()->visible(false);
  for (i = 0; i < num_elts; i++)
    {
      Figure* fig = _selected->item(i);
      fig->brush(unselected_brush());
      fig->redraw();
    }
  _selected->remove_all();
  f->brush(selected_brush());
  f->redraw();
  _selected->append(f);
}
