/*
 * Label - ASCII text glyph with font
 */

#ifndef gems_label_h
#define gems_label_h

#include <InterViews/glyph.h>
#include <InterViews/patch.h>
#include <OS/string.h>

class Color;
class Font;
class String;

class GemsLabel : public Glyph {
public:
    GemsLabel(char*, const Font*, const Color*);
    virtual ~GemsLabel();

    virtual void request(Requisition&) const;
    virtual void allocate(Canvas*, const Allocation&, Extension&);
    virtual void draw(Canvas*, const Allocation&) const;
    virtual void pick(Canvas*, const Allocation&, int depth, Hit&);
    virtual void redraw() const;
    virtual void reallocate();
    void string(char* word);
    char* string();
private:
    char* text_;
    const Font* font_;
    const Color* color_;
    class Allocation allocation_;
    class Extension extension_;
    class Canvas* canvas_;
};

#endif
