/*
 * GEMS text editor
 */

#include <OS/string.h>
#include <InterViews/monoglyph.h>
#include <InterViews/listener.h>
#include <InterViews/handler.h>
#include <InterViews/style.h>
#include <InterViews/boolean.h>
#include <InterViews/action.h>
#include <stdio.h>
#include <strings.h>

#include "label.h"
#include "text_editor.h"

GemsTextEditor::GemsTextEditor(
       GemsLabel* label, Glyph* structure, Action* OK, Action* Cancel, Action* keypress
   ) : MonoGlyph(), Handler()
{
  Resource::ref(_OK = OK);
  Resource::ref(_Cancel = Cancel);
  Resource::ref(_keypress = keypress);
  Resource::ref(_text = label);
  _listener = new Listener((structure ? structure : label), this);
  _listener->key(true);
  _listener->button(true, Event::any);
  body(_listener);
}

GemsTextEditor::~GemsTextEditor()
{
  Resource::unref(_OK);
  Resource::unref(_Cancel);
  Resource::unref(_keypress);
  Resource::unref(_text);
}

void GemsTextEditor::event(Event& e)
{
  switch (e.type())
    {
    case Event::down:
      if (!_grabbed) 
	{
	  e.grab(this);
	  _grabbed = true;
	  char* word = new char[strlen(_text->string()) + 2];
	  strcpy(word,_text->string());
	  delete _text->string();
	  _text->string(strcat(word, "|"));
	}
      break;
    case Event::key:
      char* c = _text->string();
      c[strlen(c) - 1] = '\0';
      _text->string(c);
      switch (e.keycode())
	{
	case escape_key:
	  e.ungrab(this);
	  _grabbed = false;
	  if (_Cancel) 
	    _Cancel->execute();
	  break;
	case return_key:
	  e.ungrab(this);
	  _grabbed = false;
	  if (_OK) 
	    _OK->execute();
	  break;
	case delete_key:
	  if (strlen(c) > 1) 
	    {
	      char* c = _text->string();
	      c[strlen(c) - 1] = '|';
	      _text->string(c);
	    }
	  break;
	case letter_k:
	  if (e.control_is_down())
	    {
	      char* word = new char[2];
	      strcpy(word,"|");
	      delete _text->string();
	      _text->string(word);
	    }
	  break;
	default:
	  {
	    char* key = new char[2];
	    e.mapkey(key, 1);
	    key[1] = '\0';
	    char* word = new char[strlen(_text->string()) + 3];
	    strcpy(word,_text->string());
	    delete _text->string();
	    strcat(word, key);
	    _text->string(strcat(word, "|"));
	  }
	  break;
	}
      break;
    }
}

void GemsTextEditor::string(char* name)
{
  _text->string(name);
}

char* GemsTextEditor::string()
{
  return(_text->string());
}
