.TH apass 1 "Release 1"  "AF Version 3"
.SH NAME
apass - copy from one AF server to another
.SH SYNOPSIS
.B
apass 
[\fB\-ia\fP \fIinput-AF-server\fP] 
[\fB\-oa\fP \fIoutput-AF-server\fP] 
[\fB\-full_duplex\fP]
[\fB\-id\fP \fIinput-device-#\fP] 
[\fB\-od\fP \fIoutput-device-#\fP] 
[\fB\-delay\fP \fIseconds\fP] 
[\fB\-aj\fP \fIanti-jitter-seconds\fP] 
[\fB\-buffering\fP \fIbuffering-seconds\fP] 
[\fB\-g\fP \fIdB-gain\fP] 
[\fB\-e\fP \fIencodingType\fP] 
[\fB\-log\fP]
[\fB\-f\fP \fI<parameter-file>\fP]
.SH DDESCRIPTION
.PP
\fIapass\fP reads samples from the input audio server and writes them
to the output audio server.  There will be \fIdelay\fP seconds between 
input and output.
.SH OPTIONS
.TP
.B \-ia \fIserver\fP
.IP 
Specifies which audio server to record the sound from.  Defaults to the
value of the AUDIOFILE environment variable.

.TP
.B \-oa \fIserver\fP
.IP 
Specifies which audio server to play the sound to.  Defaults to the
value of the AUDIOFILE environment variable.

.TP
.B \-full_duplex
.IP 
Copies sound in both directions (between input and output servers.)

.TP
.B \-id \fIdevice\fP
.IP 
Specifies which audio device on the input server to record the sound from.  
Defaults to the first device that isn't connected to the telephone, 
which is often the local microphone device.

.TP
.B \-od \fIdevice\fP
.IP 
Specifies which audio device on the output server to play the sound to.  
Defaults to the first device that isn't connected to the telephone, 
which is often the local speaker device.

.TP
.B \-delay \fIseconds\fP
.IP
Sets the record to playback delay.  The default value is 0.2 seconds.  This 
delay is made up of three components, the buffer size - because you cannot
play back a sample until the whole buffer is recorded, the nominal
anti-jitter delay, which absorbs variation in the scheduling and transport
delays between the record server and the playback server, and a pure delay.
The minimum value is \fIbuffering+aj\fP and the
maximum is 3.0 seconds.
 
.TP
.B \-aj \fIseconds\fP
.IP
Sets the tolerance for clock drift between the input and the output.  If the
input to output delay drifts from its nominal value by more than this
amount, the delay will be resynchronized, probably resulting in an audible
blip.  Default value is 0.1 seconds.  Legal values are 0 to 1 second.
.TP
.B \-buffering \fIseconds\fP
.IP
This parameter sets the amount of audio read from the input and written to the
output as a single operation.  It sets a minimum value for \fIdelay\fP.  The
default value is 0.2 seconds.  Legal values are 0.1 to 0.5 second.
.TP
.B \-g \fIdB-gain\fP
.IP
Controls the playback gain.  The default value is 0 dB.  Legal values are
from -30 to +30.
.TP
.B \-e \fIencodingType\fP
.IP
Sets the encoding type of the audio.  This information is passed to the
sending and receiving AF servers, where any necessary conversions will be
done.  "-e xxx" will get a list of acceptable types.  Some types may
not be supported by some servers.  If the -e switch is not specified,
the encoding type will be the natural type of the input AF device.
.TP
.B \-log
.IP
If set, apass will print a message on stdout whenever it is necessary to 
resynchronize clocks between input and output and whenever the record side 
of the program takes longer than 400 milliseconds.
.TP
.B \-f \fIfile\fP
.IP
Whenever a SIGUSR1 is received, \fIapass\fP will read \fIfile\fP to acquire 
parameters.  The parameter file should contain one or more lines.  Each value
should have a keyword and a value.  Legal keywords are delay, buffering, 
aj, and gain.
.IP
A typical parameter file might contain: 
.DS L
	delay 0.3 
	buffering 0.2
	aj 0.1 
	gain 0.0
.DE
.IP
The general idea behind the -f \fIfile\fP feature is that another process
can be used to control the \fIapass\fP process.  For example, a tk(1) program
or emacs keybindings could alter the behavior of apass.  This permits
a multi-process but single threaded environment to act like a multi-threaded
environment.
.SH ENVIRONMENT
.TP 15
.B AUDIOFILE
specifies the host and server to use if otherwise unspecified
.SH BUGS
must be some
.PP
If you encounter a \fBreproducible\fP bug, please submit a problem report to
(af-bugs@crl.dec.com).
.SH "SEE ALSO"
AF(1), aplay(1)
.SH COPYRIGHT
Copyright 1993-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Digital Cambridge Research Lab
