.TH LNDIR L
.SH NAME
lndir - create a shadow directory of symbolic links to another directory tree.
.SH SYNOPSIS
.B lndir
fromdir todir
.SH DESCRIPTION
.I Lndir
makes a shadow copy 
.I todir 
of a directory tree
.I fromdir, 
except that the shadow is not
populated with real files but instead with symbolic links pointing at
the real files in the 
.I fromdir
directory tree. This is usually useful for maintaining source code for
different machine architectures. You create a shadow directory
containing links to the real source which you will have usually NFS
mounted from a machine of a different architecture, and then recompile
it. The object files will be in the shadow directory, while the
source files in the shadow directory are just symlinks to the real
files.
.PP 
.ft B
Note that RCS directories are not shadowed - they are symlinks to the
real RCS directories.
.ft
.PP
This has the advantage that if you update the source, you need not 
propagate the change to the other architectures by hand, since all
source in shadow directories are symlinks to the real thing - just cd
to the shadow directory and recompile away.
.PP
Ignore the diagnostics it generates about files already existing when
it runs - those are the directories which it are real, and are created
before the symlinking.
.PP
Note that if you add files, you must run
.I lndir
again. Deleting files is a more painful problem - the symlinks will
just point into never never land.
.SH ORIGIN
From the X11R2 distribution.
.SH BUGS
You can write through symlinks and clobber the files sometimes. Strict
RCS locking can prevent this.
.sp 1
patch gets upset if it cannot change the files.
.sp 1
You need to use something like
.nf
	find todir -type l -print | xargs rm
.fi
to clear out all files before you can relink. (If fromdir moved, for instance)
Something like
.nf
	 find . \\! -type d -print
.fi
will find all files that are not directories.
