/*
** dial:
** 
** Copyright (c) 1992 by John Uhley and XpressWare
** uhley@xpressware.com
**
** Must output the string to pass to the dialer with the appropriate AT 
** command in front.   If the spool directory contains the executable file
** 'dialer' the one line output from the file will be used as the dial string.
**
**	This routine is used to generate the command line to send to the modem
**	to dial a number.   The current US algorhythm is:
**
**	If $prefix is defined then just output prefix,number,postfix
**	  [ handles cases of always using a long distance carrier ]
**	else
**		if area code isn't defined just dial the number
**	else
**		if area code matches phone number requested then STRIP phone
**		to phone less the area code and dial direct
**	otherwise
**		if the length of the number exceeds 7
**			put a '1' in front of the areacode+phone
**		else
**			just dial the phone number
*/
#include "systems.h"
#include <stdio.h>

/*
** define routines and temporary buffer space in this routine
**
*/
void strip_to_numbers();
static char dial_buffer[BUFSIZ];
static char working_prefix[BUFSIZ];
static char working_postfix[BUFSIZ];
static char working_ac[BUFSIZ];
static char working_number[BUFSIZ];


/*
** 
**
*/
main(argc, argv)
	int argc;
	char **argv;
{
	char *prefix, *postfix, *ac, *number;
	if (argc != 5) {
		fprintf(stderr,"usage: %s prefix postfix area-code number\n",
			argv[0]);
		exit(0);
	}
	prefix = argv[1];
	postfix = argv[2];
	ac = argv[3];
	number = argv[4];


	bzero(working_prefix, sizeof(working_prefix));
	bzero(working_postfix, sizeof(working_postfix));
	bzero(working_ac, sizeof(working_ac));
	bzero(working_number, sizeof(working_number));

	strip_to_numbers(prefix, working_prefix);
	strip_to_numbers(postfix, working_postfix);
	strip_to_numbers(ac, working_ac);
	strip_to_numbers(number, working_number);

	if (*working_prefix != NULL)  {
		sprintf(dial_buffer, "ATTD%s%s%s\n", 
			working_prefix,working_number,working_postfix);
		printf("%s", dial_buffer);
		exit(0);
	}
	if (*working_ac == NULL) {
		sprintf(dial_buffer, "ATTD%s\n", working_number);
		printf("%s", dial_buffer);
		exit(0);
	}
	if (strncmp(working_ac, working_number, strlen(working_ac)) == NULL){
		sprintf(dial_buffer, "ATTD%s\n", 
			working_number+ strlen(working_ac));
		printf("%s", dial_buffer);
		exit(0);
	}
	if (strlen(working_number) > 8)
		if (strncmp(working_number,"011", 3) == 0)
			sprintf(dial_buffer, "ATTD%s\n",  working_number);
		else
			sprintf(dial_buffer, "ATTD1%s\n",  working_number);
	else
		sprintf(dial_buffer, "ATTD%s\n",  working_number);
	printf("%s", dial_buffer);
	exit(0);
}

/*
** strip_to_numbers
**	Take 'str' and stuff only the numbers in it into dest.
**
*/
void
strip_to_numbers(str, dest)
	char *str, *dest;
{
	int i,j;
	i = j = 0;
	if (str == NULL){
		*dest = NULL;
		return;
	}
	while (i < strlen(str)) {
		if ((str[i] >= '0' && str[i] <= '9') || str[i] == ',')
			*dest++ = str[i];
		i++;
	}
	*dest = NULL;
}
