/*
** dial:
** 
** Copyright (c) 1992 by John Uhley and XpressWare
** uhley@xpressware.com
**
**
** Modified by Jae Y. Chung, GNP Computers  on Apr 22, 1992
**	1. Algoryhthm is totally rewritten
**	2. Add ',' in strip_to_numbers() routine that it will
**	   actually pause modems as it supposed to be.
**
** The old routine was:
**
** Must output the string to pass to the dialer with the appropriate ATS11=100 
** command in front.   If the spool directory contains the executable file
** 'dialer' the one line output from the file will be used as the dial string.
**
**	This routine is used to generate the command line to send to the modem
**	to dial a number.   The current US algorhythm is:
**
**	If $prefix is defined then just output prefix,number,postfix
**	  [ handles cases of always using a long distance carrier ]
**	else
**		if area code isn't defined just dial the number
**	else
**		if area code matches phone number requested then STRIP phone
**		to phone less the area code and dial direct
**	otherwise
**		if the length of the number exceeds 7
**			put a '1' in front of the areacode+phone
**		else
**			just dial the phone number
**
*/
#include "xpressfax_symbols.h"
#include <stdio.h>
#define NODEBUG

/*
** define routines and temporary buffer space in this routine
**
*/
void strip_to_numbers();
static char dial_buffer[BUFSIZ];
static char working_prefix[BUFSIZ];
static char working_postfix[BUFSIZ];
static char working_ac[BUFSIZ];
static char working_number[BUFSIZ];


/*
** 
**
*/
main(argc, argv)
	int argc;
	char **argv;
{
	char *prefix, *postfix, *ac, *number;
#ifdef DEBUG
        FILE *dfptr;
	int i;
	dfptr = fopen("/usr/xpressfax/Any/dialer.log", "a");
#endif

	if (argc != 5) {
		fprintf(stderr,"usage: %s prefix postfix area-code number\n",
			argv[0]);
#ifdef DEBUG
		fprintf(dfptr, "There is only %d arguments\n", argc);
		for (i = 0; i < argc; i++)
			fprintf(dfptr,"argument %d\t%s\n", i, argv[i]);
#endif
		exit(0);
	}
	prefix = argv[1];
	postfix = argv[2];
	ac = argv[3];
	number = argv[4];


	bzero(working_prefix, sizeof(working_prefix));
	bzero(working_postfix, sizeof(working_postfix));
	bzero(working_ac, sizeof(working_ac));
	bzero(working_number, sizeof(working_number));

	strip_to_numbers(prefix, working_prefix);
	strip_to_numbers(postfix, working_postfix);
	strip_to_numbers(ac, working_ac);
	strip_to_numbers(number, working_number);

	strcpy(dial_buffer, "ATM1S11=100TD");
        if (*working_prefix != NULL)
		strcat(dial_buffer, working_prefix);

        /* Now manipulate phone numbers */
        if (strncmp(working_number, "011", 3) == 0) /* for International call */
		strcat(dial_buffer, working_number);
	else { /* numbers can be safely assumed as domestic calls */
		switch (strlen(working_number)) {
			case 7  : /* local call */
				  strcat(dial_buffer, working_number);
				  break;
			case 10 : /* long distance w/o prefix 1 */
				  if ((strncmp(working_ac, working_number, strlen(working_ac)) == NULL) && (strlen(working_ac) != 0)) /* if it is, in fact, local call */
					strcat(dial_buffer, working_number + strlen(working_ac));
				  else { /* deal with real long distance */
				  	strcat(dial_buffer, "1");
					strcat(dial_buffer, working_number);
				  }
				  break;
			case 11 : /* long distance w/ prefix 1 */
				  if ((strncmp(working_ac, working_number + 1, strlen(working_ac)) == NULL) && (strlen(working_ac) != 0)) /* if it is , in fact, local call */
				  	strcat(dial_buffer, working_number + 1 + strlen(working_ac));
				  else /* deal with real long distance */
					strcat(dial_buffer, working_number);
				  break;
			default : /* For weird phone numbers, use it as is */
				  strcat(dial_buffer, working_number);
				  break;
		}
	}

	if (*working_postfix != NULL)
		strcat(dial_buffer, working_postfix);

	/* Finally, Return dial code */
	printf("%s\n", dial_buffer);
#ifdef DEBUG
	fprintf(dfptr, "%s\n", dial_buffer);
	fclose(dfptr);
#endif

	return;

}

/*
** strip_to_numbers
**	Take 'str' and stuff only the numbers in it into dest.
**
*/
void
strip_to_numbers(str, dest)
	char *str, *dest;
{
	int i,j;
	i = j = 0;
	if (str == NULL){
		*dest = NULL;
		return;
	}
	while (i < strlen(str)) {
		if ((str[i] >= '0' && str[i] <= '9') || str[i] == ',')
			*dest++ = str[i];
		i++;
	}
	*dest = NULL;
}

