/*
 * Written by Jae Y. Chung
 *
 * Simple procedure to create forward book for XpressFax.
 * 
 * Conditions - If there is no gecos, it will ignore it.
 *		If password is disabled with "*", it will ignore it.
 *		If NIS is active, it will use first alias value instead of
 *		username@hostname.
 *
 * Usage - crforward > forwardbook
 *         you can safely ignore warning message on stdout.
 *
 */
#include	<stdio.h>
#include	<pwd.h>

#define		MAP	"mail.aliases"

main()
{
	int i =0, namelen, NIS = 0, mailaddr_len, NIS_entry_exist;
	char hostname[BUFSIZ], **domainname, **mailaddr;
	struct passwd *password;

	if (gethostname(hostname, namelen)) {
		fprintf(stderr, "Fail to identify host name...\n");
		exit(1);
	}
	hostname[namelen] = '\0';

	/* Check if NIS exist. If it does, Let's assume alias map is there */
	NIS = !yp_get_default_domain(&domainname); 

	setpwent(); /* Just for safety precaution, rewind back to orig */

	while ((password = getpwent()) != NULL) {
		/* Give some intelligence to program                   */
		/* If there is no gecos, and if password is disabled,  */
		/* Just Warn this to stderr...                         */
		if ((strlen(password->pw_gecos) <= 0) ||
		    (strcmp(password->pw_passwd, "*") == 0)) {
			fprintf(stderr,
				"Warning! User <%s> is not added to std. output\n", 
				password->pw_name);
		} else { 
			if (NIS)
				NIS_entry_exist = !yp_match(domainname, MAP, 
						    password->pw_name, 
				/* Does not make whole sence, but works... */
				/* I think this is a bug.................. */
						    strlen(password->pw_name)+1,
						    &mailaddr, &mailaddr_len);

			if (NIS_entry_exist) {
				fprintf(stdout, "%.5d\t%s\t%s\n", 
					i, password->pw_gecos, mailaddr);
			} else {
				fprintf(stdout, "%.5d\t%s\t%s@%s\n", 
					i, password->pw_gecos, password->pw_name,
					hostname);
			}
			++i;
		} 
	}

	endpwent(); /* Now, We are done with processing, close it     */

	exit (0);
}

